/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.ArithmeticExpression;
import translator.expression.AtomExpression;
import translator.expression.Conjunction;
import translator.expression.ConstantDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.IdentifierDomain;
import translator.expression.Multiplication;
import translator.expression.Sum;
import translator.expression.Variable;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuantifiedSum
implements ArithmeticExpression {
    boolean isFlattened = false;
    private String[] quantifiedVariables;
    private Domain domain;
    private Expression quantifiedExpression;
    private boolean isNested = true;
    private boolean willBeReified = false;

    public QuantifiedSum(String[] stringArray, Domain domain, Expression expression) {
        this.quantifiedVariables = stringArray;
        this.domain = domain;
        this.quantifiedExpression = expression;
    }

    public QuantifiedSum(ArrayList<String> arrayList, Domain domain, Expression expression) {
        this.quantifiedVariables = new String[arrayList.size()];
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            this.quantifiedVariables[i] = arrayList.remove(i);
        }
        this.domain = domain;
        this.quantifiedExpression = expression;
    }

    @Override
    public boolean isQuantified() {
        if (this.quantifiedExpression.isQuantified()) {
            return true;
        }
        if (this.domain instanceof ExpressionRange) {
            ExpressionRange expressionRange = (ExpressionRange)this.domain;
            if (expressionRange.getLowerAndUpperBound()[0].isQuantified()) {
                return true;
            }
            if (expressionRange.getLowerAndUpperBound()[1].isQuantified()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        ArrayList<Expression> arrayList;
        block2: {
            ExpressionRange expressionRange;
            block3: {
                arrayList = this.quantifiedExpression.getQuantifyingVariables();
                if (!(this.domain instanceof ExpressionRange)) break block2;
                expressionRange = (ExpressionRange)this.domain;
                if (!expressionRange.getLowerAndUpperBound()[0].isQuantified()) break block3;
                ArrayList<Expression> arrayList2 = expressionRange.getLowerAndUpperBound()[0].getQuantifyingVariables();
                int n = arrayList2.size();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(arrayList2.remove(0));
                }
                break block2;
            }
            if (!expressionRange.getLowerAndUpperBound()[1].isQuantified()) break block2;
            ArrayList<Expression> arrayList3 = expressionRange.getLowerAndUpperBound()[1].getQuantifyingVariables();
            int n = arrayList3.size();
            for (int i = 0; i < n; ++i) {
                arrayList.add(arrayList3.remove(0));
            }
        }
        return arrayList;
    }

    @Override
    public ArithmeticExpression copy() {
        String[] stringArray = new String[this.quantifiedVariables.length];
        for (int i = 0; i < this.quantifiedVariables.length; ++i) {
            stringArray[i] = new String(this.quantifiedVariables[i]);
        }
        QuantifiedSum quantifiedSum = new QuantifiedSum(stringArray, this.domain.copy(), this.quantifiedExpression.copy());
        return quantifiedSum;
    }

    @Override
    public ArithmeticExpression evaluate() {
        this.quantifiedExpression = this.quantifiedExpression.evaluate();
        this.domain = this.domain.evaluate();
        return this;
    }

    @Override
    public int[] getDomain() {
        int[] nArray = this.quantifiedExpression.getDomain();
        int n = 0;
        if (this.domain instanceof ConstantDomain) {
            int[] nArray2 = ((ConstantDomain)this.domain).getRange();
            n = nArray2[1] - nArray2[0] + 1;
            nArray[0] = nArray[0] * n * this.quantifiedVariables.length;
            nArray[1] = nArray[1] * n * this.quantifiedVariables.length;
            return new int[]{nArray[0], nArray[1]};
        }
        return new int[]{-100000, 100000};
    }

    @Override
    public Expression[] getDefinedDomain() {
        Expression[] expressionArray = this.quantifiedExpression.getDefinedDomain();
        ArithmeticExpression arithmeticExpression = new ArithmeticAtomExpression(0);
        if (this.domain instanceof ConstantDomain) {
            int[] nArray = ((ConstantDomain)this.domain).getRange();
            arithmeticExpression = new ArithmeticAtomExpression(nArray[1] - nArray[0] + 1);
        } else if (this.domain instanceof ExpressionRange) {
            Expression[] expressionArray2 = ((ExpressionRange)this.domain).getLowerAndUpperBound();
            arithmeticExpression = new Sum(new Expression[]{expressionArray2[1], new ArithmeticAtomExpression(1)}, new Expression[]{expressionArray2[0]});
        } else {
            arithmeticExpression = new ArithmeticAtomExpression(100000);
        }
        expressionArray[0] = new Multiplication(new Expression[]{expressionArray[0], arithmeticExpression, new ArithmeticAtomExpression(this.quantifiedVariables.length)});
        expressionArray[1] = new Multiplication(new Expression[]{expressionArray[1], arithmeticExpression, new ArithmeticAtomExpression(this.quantifiedVariables.length)});
        return new Expression[]{expressionArray[0].evaluate(), expressionArray[1].evaluate()};
    }

    @Override
    public int getType() {
        return 201;
    }

    @Override
    public int getCategory() {
        if (this.domain.getCategory() < this.quantifiedExpression.getCategory()) {
            return this.quantifiedExpression.getCategory();
        }
        return this.domain.getCategory();
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        this.domain = this.domain.insertValueForVariable(n, string);
        this.quantifiedExpression = this.quantifiedExpression.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        this.quantifiedExpression = this.quantifiedExpression.insertValueForVariable(bl, string);
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        this.quantifiedExpression = this.quantifiedExpression.replaceVariableWithExpression(string, expression);
        this.domain = this.domain.replaceVariableWithExpression(string, expression);
        for (int i = 0; i < this.quantifiedVariables.length; ++i) {
            if (!this.quantifiedVariables[i].equals(string) || !(expression instanceof AtomExpression)) continue;
            Variable variable = ((AtomExpression)expression).getVariable();
            this.quantifiedVariables[i] = variable.getVariableName();
        }
        return this;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        QuantifiedSum quantifiedSum = (QuantifiedSum)expression;
        if (this.quantifiedVariables.length == quantifiedSum.quantifiedVariables.length) {
            if (this.quantifiedExpression.getType() == quantifiedSum.quantifiedExpression.getType()) {
                return this.quantifiedExpression.isSmallerThanSameType(quantifiedSum.quantifiedExpression);
            }
            return this.quantifiedExpression.getType() < quantifiedSum.quantifiedExpression.getType() ? (char)'s' : 'g';
        }
        return this.quantifiedVariables.length < quantifiedSum.quantifiedVariables.length ? (char)'s' : 'g';
    }

    @Override
    public void orderExpression() {
        this.quantifiedExpression.orderExpression();
    }

    @Override
    public Expression reduceExpressionTree() {
        this.quantifiedExpression = this.quantifiedExpression.reduceExpressionTree();
        return this;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (!this.isFlattened) {
            stringBuffer.append("sum " + this.quantifiedVariables[0]);
            for (int i = 1; i < this.quantifiedVariables.length; ++i) {
                stringBuffer.append("," + this.quantifiedVariables[i]);
            }
            stringBuffer.append(": " + this.domain + ".\n");
            stringBuffer.append("\t" + this.quantifiedExpression);
        } else if (this.quantifiedExpression instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)this.quantifiedExpression;
            if (conjunction.getArguments().size() > 1) {
                int n;
                stringBuffer.append("forall " + this.quantifiedVariables[0]);
                for (n = 1; n < this.quantifiedVariables.length; ++n) {
                    stringBuffer.append("," + this.quantifiedVariables[n]);
                }
                stringBuffer.append(": " + this.domain + ".\n");
                for (n = 1; n < conjunction.getArguments().size(); ++n) {
                    if (n > 1 && n < conjunction.getArguments().size() - 1) {
                        stringBuffer.append(" /\\ \n");
                    }
                    stringBuffer.append("\t" + conjunction.getArguments().get(n));
                }
                stringBuffer.append("sum " + this.quantifiedVariables[0]);
                for (n = 1; n < this.quantifiedVariables.length; ++n) {
                    stringBuffer.append("," + this.quantifiedVariables[n]);
                }
                stringBuffer.append(": " + this.domain + ".\n");
                stringBuffer.append("\t" + conjunction.getArguments().get(0));
            } else {
                stringBuffer.append("sum " + this.quantifiedVariables[0]);
                for (int i = 1; i < this.quantifiedVariables.length; ++i) {
                    stringBuffer.append("," + this.quantifiedVariables[i]);
                }
                stringBuffer.append(": " + this.domain + ".\n");
                stringBuffer.append("\t" + this.quantifiedExpression);
            }
        } else {
            stringBuffer.append("sum " + this.quantifiedVariables[0]);
            for (int i = 1; i < this.quantifiedVariables.length; ++i) {
                stringBuffer.append("," + this.quantifiedVariables[i]);
            }
            stringBuffer.append(": " + this.domain + ".\n");
            stringBuffer.append("\t" + this.quantifiedExpression);
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        String string2;
        if (this.domain instanceof IdentifierDomain && (string2 = ((IdentifierDomain)this.domain).getDomainName()).equals(string)) {
            this.domain = domain;
        }
        this.quantifiedExpression = this.quantifiedExpression.insertDomainForVariable(domain, string);
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        this.quantifiedExpression = this.quantifiedExpression.replaceVariableWith(variable, variable2);
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    public Domain getQuantifiedDomain() {
        return this.domain;
    }

    public String[] getQuantifiedVariables() {
        return this.quantifiedVariables;
    }

    public Expression getQuantifiedExpression() {
        return this.quantifiedExpression;
    }

    public void updateDomain(Domain domain) {
        this.domain = domain;
    }

    public void setQuantifiedExpression(Expression expression) {
        this.quantifiedExpression = expression;
    }

    public void setIsFlattened(boolean bl) {
        this.isFlattened = bl;
    }

    public boolean isFlattened() {
        return this.isFlattened;
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        this.quantifiedExpression.adaptIndicesForSolver(string, expressionArray);
    }
}

