/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.AtomExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.IdentifierDomain;
import translator.expression.RelationalExpression;
import translator.expression.Variable;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuantifiedExpression
implements RelationalExpression {
    private boolean isUniversal;
    private String[] quantifiedVariables;
    private Domain domain;
    private Expression quantifiedExpression;
    private boolean isNested = true;
    private boolean willBeReified = false;
    private boolean isNestedInConjunction = false;
    private boolean isNestedInDisjunction = false;
    private boolean isAlreadyFlattened = false;
    private ExpressionRange quantifiedRange;

    public QuantifiedExpression(boolean bl, String[] stringArray, Domain domain, Expression expression) {
        this.isUniversal = bl;
        this.quantifiedVariables = stringArray;
        this.domain = domain;
        this.quantifiedExpression = expression;
    }

    public QuantifiedExpression(boolean bl, ArrayList<String> arrayList, Domain domain, Expression expression) {
        this.isUniversal = bl;
        this.quantifiedVariables = new String[arrayList.size()];
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            this.quantifiedVariables[i] = arrayList.remove(i);
        }
        this.domain = domain;
        this.quantifiedExpression = expression;
    }

    @Override
    public boolean isQuantified() {
        if (this.quantifiedExpression.isQuantified()) {
            return true;
        }
        if (this.domain instanceof ExpressionRange) {
            ExpressionRange expressionRange = (ExpressionRange)this.domain;
            if (expressionRange.getLowerAndUpperBound()[0].isQuantified()) {
                return true;
            }
            if (expressionRange.getLowerAndUpperBound()[1].isQuantified()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        ArrayList<Expression> arrayList = this.quantifiedExpression.getQuantifyingVariables();
        if (this.domain instanceof ExpressionRange) {
            ExpressionRange expressionRange = (ExpressionRange)this.domain;
            ArrayList<Expression> arrayList2 = expressionRange.getLowerAndUpperBound()[0].getQuantifyingVariables();
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                arrayList.add(arrayList2.remove(0));
            }
            ArrayList<Expression> arrayList3 = expressionRange.getLowerAndUpperBound()[1].getQuantifyingVariables();
            n = arrayList3.size();
            for (int i = 0; i < n; ++i) {
                arrayList.add(arrayList3.remove(0));
            }
        }
        return arrayList;
    }

    public void setQuantifiedRange(ExpressionRange expressionRange) {
        this.quantifiedRange = expressionRange;
    }

    @Override
    public Expression copy() {
        Expression expression = this.quantifiedExpression.copy();
        String[] stringArray = new String[this.quantifiedVariables.length];
        for (int i = 0; i < this.quantifiedVariables.length; ++i) {
            stringArray[i] = this.quantifiedVariables[i];
        }
        Domain domain = this.domain.copy();
        QuantifiedExpression quantifiedExpression = new QuantifiedExpression(this.isUniversal, stringArray, domain, expression);
        quantifiedExpression.setQuantifiedRange(this.quantifiedRange);
        return quantifiedExpression;
    }

    @Override
    public Expression evaluate() {
        this.quantifiedExpression = this.quantifiedExpression.evaluate();
        this.domain = this.domain.evaluate();
        return this;
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public int getType() {
        return this.isUniversal ? 202 : 203;
    }

    @Override
    public int getCategory() {
        if (this.domain.getCategory() < this.quantifiedExpression.getCategory()) {
            return this.quantifiedExpression.getCategory();
        }
        return this.domain.getCategory();
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        QuantifiedExpression quantifiedExpression = (QuantifiedExpression)expression;
        if (this.quantifiedVariables.length == quantifiedExpression.quantifiedVariables.length) {
            if (this.quantifiedExpression.getType() == quantifiedExpression.quantifiedExpression.getType()) {
                return this.quantifiedExpression.isSmallerThanSameType(quantifiedExpression.quantifiedExpression);
            }
            return this.quantifiedExpression.getType() < quantifiedExpression.quantifiedExpression.getType() ? (char)'s' : 'g';
        }
        return this.quantifiedVariables.length < quantifiedExpression.quantifiedVariables.length ? (char)'s' : 'g';
    }

    @Override
    public void orderExpression() {
        this.quantifiedExpression.orderExpression();
        this.quantifiedVariables = this.lexOrderStringList(this.quantifiedVariables);
    }

    @Override
    public Expression reduceExpressionTree() {
        this.quantifiedExpression = this.quantifiedExpression.reduceExpressionTree();
        return this;
    }

    public void updateDomain(Domain domain) {
        this.domain = domain;
    }

    public Domain getQuantifiedDomain() {
        return this.domain;
    }

    public Expression getQuantifiedExpression() {
        return this.quantifiedExpression;
    }

    public String[] getQuantifiedVariables() {
        return this.quantifiedVariables;
    }

    protected String[] lexOrderStringList(String[] stringArray) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < stringArray.length; ++n) {
            arrayList = this.insertIntoOrderedList(stringArray[n], arrayList);
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = arrayList.get(n);
        }
        return stringArray;
    }

    protected ArrayList<String> insertIntoOrderedList(String string, ArrayList<String> arrayList) {
        if (arrayList.size() == 0) {
            arrayList.add(string);
            return arrayList;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i);
            if (string2.compareTo(string) < 0) continue;
            arrayList.add(i, string);
            return arrayList;
        }
        arrayList.add(string);
        return arrayList;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        this.domain.insertValueForVariable(n, string);
        this.quantifiedExpression.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        this.quantifiedExpression.insertValueForVariable(bl, string);
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        this.domain = this.domain.replaceVariableWithExpression(string, expression);
        this.quantifiedExpression = this.quantifiedExpression.replaceVariableWithExpression(string, expression);
        for (int i = 0; i < this.quantifiedVariables.length; ++i) {
            if (!this.quantifiedVariables[i].equals(string) || !(expression instanceof AtomExpression)) continue;
            Variable variable = ((AtomExpression)expression).getVariable();
            this.quantifiedVariables[i] = variable.getVariableName();
        }
        return this;
    }

    @Override
    public String toString() {
        String string = this.isUniversal ? "forall " : "exists ";
        string = string.concat(this.quantifiedVariables[0]);
        for (int i = 1; i < this.quantifiedVariables.length; ++i) {
            string = string.concat("," + this.quantifiedVariables[i]);
        }
        string = string.concat(": " + this.domain + ".\n");
        string = string.concat("\t" + this.quantifiedExpression);
        return string;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public Expression restructure() {
        this.quantifiedExpression = this.quantifiedExpression.restructure();
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        String string2;
        if (this.domain instanceof IdentifierDomain && (string2 = ((IdentifierDomain)this.domain).getDomainName()).equals(string)) {
            this.domain = domain;
        }
        for (int i = 0; i < this.quantifiedVariables.length; ++i) {
            String string3 = this.quantifiedVariables[i];
            this.quantifiedExpression = this.quantifiedExpression.insertDomainForVariable(this.domain, string3);
        }
        this.quantifiedExpression = this.quantifiedExpression.insertDomainForVariable(domain, string);
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        this.quantifiedExpression = this.quantifiedExpression.replaceVariableWith(variable, variable2);
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    public boolean isNestedInConjunction() {
        return this.isNestedInConjunction;
    }

    public boolean isNestedInDisjunction() {
        return this.isNestedInDisjunction;
    }

    public void setIsNestedInConjunction(boolean bl) {
        this.isNestedInConjunction = bl;
    }

    public void setIsNestedInDisjunction(boolean bl) {
        this.isNestedInDisjunction = bl;
    }

    public void setQuantifiedExpression(Expression expression) {
        this.quantifiedExpression = expression;
    }

    public boolean isAlreadyFlattened() {
        return this.isAlreadyFlattened;
    }

    public void setIsAlreadyFlattened(boolean bl) {
        this.isAlreadyFlattened = bl;
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        this.quantifiedExpression.adaptIndicesForSolver(string, expressionArray);
    }
}

