/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.GlobalConstraint;
import translator.expression.Multiplication;
import translator.expression.Variable;
import translator.solver.Gecode;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductConstraint
implements GlobalConstraint {
    private Expression[] arguments;
    private Expression result;
    private boolean isNested = true;
    private boolean willBeReified = false;

    public ProductConstraint(Expression[] expressionArray, Expression expression) {
        this.arguments = expressionArray;
        this.result = expression;
    }

    public ProductConstraint(Expression[] expressionArray) {
        this.arguments = expressionArray;
    }

    public ProductConstraint(ArrayList<Expression> arrayList) {
        this.arguments = new Expression[arrayList.size()];
        for (int i = this.arguments.length - 1; i >= 0; ++i) {
            this.arguments[i] = arrayList.remove(i);
        }
    }

    public void setResult(Expression expression) {
        this.result = expression;
    }

    public boolean hasResult() {
        return this.result != null;
    }

    @Override
    public boolean isQuantified() {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (!this.arguments[i].isQuantified()) continue;
            return true;
        }
        return this.result.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        ArrayList<Expression> arrayList = this.result.getQuantifyingVariables();
        for (int i = 0; i < this.arguments.length; ++i) {
            ArrayList<Expression> arrayList2 = this.arguments[i].getQuantifyingVariables();
            int n = arrayList2.size();
            for (int j = 0; j < n; ++j) {
                arrayList.add(arrayList2.remove(0));
            }
        }
        return arrayList;
    }

    @Override
    public Expression[] getArguments() {
        return this.arguments;
    }

    @Override
    public Expression copy() {
        Expression[] expressionArray = new Expression[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            expressionArray[i] = this.arguments[i].copy();
        }
        return new ProductConstraint(expressionArray, this.result.copy());
    }

    @Override
    public Expression evaluate() {
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i] = this.arguments[i].evaluate();
        }
        this.result = this.result.evaluate();
        return this;
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public int getType() {
        return this.arguments.length == 2 ? 280 : 290;
    }

    @Override
    public int getCategory() {
        int n = 0;
        for (int i = 0; i < this.arguments.length; ++i) {
            if (n >= this.arguments[i].getCategory()) continue;
            n = this.arguments[i].getCategory();
        }
        return n < this.result.getCategory() ? this.result.getCategory() : n;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i] = this.arguments[i].insertValueForVariable(n, string);
        }
        this.result = this.result.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i] = this.arguments[i].insertValueForVariable(bl, string);
        }
        this.result = this.result.insertValueForVariable(bl, string);
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        this.result = this.result.replaceVariableWithExpression(string, expression);
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i] = this.arguments[i].replaceVariableWithExpression(string, expression);
        }
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        ProductConstraint productConstraint = (ProductConstraint)expression;
        if (this.arguments.length == productConstraint.arguments.length) {
            for (int i = 0; i < this.arguments.length; ++i) {
                if (this.arguments[0].getType() == productConstraint.arguments[i].getType()) {
                    char c = this.arguments[0].isSmallerThanSameType(productConstraint.arguments[i]);
                    if (c == 'e') continue;
                    return c;
                }
                return this.arguments[0].getType() < productConstraint.arguments[i].getType() ? (char)'s' : 'g';
            }
            if (this.result.getType() == productConstraint.result.getType()) {
                return this.result.isSmallerThanSameType(productConstraint.result);
            }
            return this.result.getType() < productConstraint.result.getType() ? (char)'s' : 'g';
        }
        return this.arguments.length < productConstraint.arguments.length ? (char)'s' : 'g';
    }

    @Override
    public void orderExpression() {
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i].orderExpression();
        }
        this.result.orderExpression();
    }

    @Override
    public Expression reduceExpressionTree() {
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i] = this.arguments[i].reduceExpressionTree();
        }
        this.result = this.result.reduceExpressionTree();
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(((Object)this.arguments[0]).toString());
        for (int i = 1; i < this.arguments.length; ++i) {
            stringBuffer.append("* " + this.arguments[i]);
        }
        return stringBuffer + " = " + this.result;
    }

    @Override
    public Expression restructure() {
        this.result = this.result.restructure();
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i] = this.arguments[i].restructure();
        }
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i] = this.arguments[i].insertDomainForVariable(domain, string);
        }
        this.result = this.result.insertDomainForVariable(domain, string);
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        this.result = this.result.replaceVariableWith(variable, variable2);
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i] = this.arguments[i].replaceVariableWith(variable, variable2);
        }
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return !new Multiplication(this.arguments).isNonLinearMultiplication() && this.result.isLinearExpression();
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        if (targetSolver instanceof Gecode && this.isLinearExpression()) {
            if (this.arguments.length == 0) {
                throw new Exception("Multiplication with no arguments.");
            }
            StringBuffer stringBuffer = new StringBuffer(((Object)this.arguments[0]).toString());
            for (int i = 1; i < this.arguments.length; ++i) {
                stringBuffer.append("*" + this.arguments[i]);
            }
            return stringBuffer.append(" == " + this.result.toSolverExpression(targetSolver)).toString();
        }
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i].adaptIndicesForSolver(string, expressionArray);
        }
    }

    public Expression[] getProductArguments() {
        return this.arguments;
    }

    public Expression getResult() {
        return this.result;
    }
}

