/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.Variable;
import translator.solver.Gecode;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Objective
implements Expression {
    public Expression objective;
    boolean maximise;
    private boolean willBeFlattened = true;

    public Objective() {
    }

    public Objective(Expression expression, boolean bl) {
        this.objective = expression;
        this.maximise = bl;
    }

    @Override
    public boolean isQuantified() {
        return this.objective.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        if (this.objective != null) {
            return this.objective.getQuantifyingVariables();
        }
        return new ArrayList<Expression>();
    }

    public Expression getObjectiveExpression() {
        return this.objective;
    }

    public void setObjectiveExpression(Expression expression) {
        this.objective = expression;
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public int getType() {
        return 500;
    }

    @Override
    public int getCategory() {
        if (this.objective == null) {
            return 0;
        }
        return this.objective.getCategory();
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        if (this.objective != null) {
            this.objective = this.objective.insertDomainForVariable(domain, string);
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        if (this.objective != null) {
            this.objective = this.objective.insertValueForVariable(n, string);
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        if (this.objective != null) {
            this.objective = this.objective.insertValueForVariable(bl, string);
        }
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        if (this.objective != null) {
            this.objective = this.objective.replaceVariableWithExpression(string, expression);
        }
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeFlattened;
    }

    @Override
    public boolean isNested() {
        return false;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        return 'e';
    }

    @Override
    public void orderExpression() {
        if (this.objective != null) {
            this.objective.orderExpression();
        }
    }

    @Override
    public Expression reduceExpressionTree() {
        if (this.objective != null) {
            this.objective = this.objective.reduceExpressionTree();
        }
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        if (this.objective != null) {
            this.objective = this.objective.replaceVariableWith(variable, variable2);
        }
        return this;
    }

    @Override
    public Expression restructure() {
        if (this.objective != null) {
            this.objective = this.objective.restructure();
        }
        return this;
    }

    @Override
    public void setIsNotNested() {
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeFlattened = bl;
    }

    public boolean isMaximise() {
        return this.maximise;
    }

    public boolean isEmptyObjective() {
        return this.objective == null;
    }

    public void normalise() {
        if (this.objective != null) {
            this.objective = this.objective.reduceExpressionTree();
            this.objective = this.objective.evaluate();
            this.objective = this.objective.reduceExpressionTree();
            this.objective.orderExpression();
        }
    }

    @Override
    public Expression evaluate() {
        if (this.objective != null) {
            this.objective.reduceExpressionTree();
            this.objective = this.objective.evaluate();
            this.objective.reduceExpressionTree();
        }
        return this;
    }

    public void order() {
        if (this.objective != null) {
            this.objective.orderExpression();
        }
    }

    @Override
    public Objective copy() {
        if (this.objective == null) {
            return new Objective();
        }
        return new Objective(this.objective.copy(), this.maximise);
    }

    @Override
    public String toString() {
        String string = new String("");
        if (this.objective == null) {
            return string;
        }
        string = this.maximise ? "maximising" : "minimising";
        string = string.concat(" " + this.objective);
        return string;
    }

    @Override
    public boolean isLinearExpression() {
        return this.objective.isLinearExpression();
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        if (targetSolver instanceof Gecode && this.isLinearExpression()) {
            this.objective.toSolverExpression(targetSolver);
        }
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        if (this.objective != null) {
            this.objective.adaptIndicesForSolver(string, expressionArray);
        }
    }
}

