/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.AtomExpression;
import translator.expression.BinaryRelationalExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.Negation;
import translator.expression.RelationalAtomExpression;
import translator.expression.Sum;
import translator.expression.UnaryMinus;
import translator.expression.Variable;
import translator.solver.Gecode;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonCommutativeRelationalBinaryExpression
implements BinaryRelationalExpression {
    private Expression leftArgument;
    private Expression rightArgument;
    private int type;
    private boolean isNested = true;
    private boolean willBeReified = false;
    private ExpressionRange quantifiedRange;

    public NonCommutativeRelationalBinaryExpression(Expression expression, int n, Expression expression2) {
        this.leftArgument = expression;
        this.rightArgument = expression2;
        this.type = n;
    }

    @Override
    public boolean isQuantified() {
        return this.leftArgument.isQuantified() || this.rightArgument.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        ArrayList<Expression> arrayList = this.rightArgument.getQuantifyingVariables();
        ArrayList<Expression> arrayList2 = this.leftArgument.getQuantifyingVariables();
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(arrayList2.remove(0));
        }
        return arrayList;
    }

    @Override
    public Expression getLeftArgument() {
        return this.leftArgument;
    }

    @Override
    public Expression getRightArgument() {
        return this.rightArgument;
    }

    @Override
    public int getOperator() {
        return this.type;
    }

    @Override
    public Expression copy() {
        return new NonCommutativeRelationalBinaryExpression(this.leftArgument.copy(), this.type, this.rightArgument.copy());
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getCategory() {
        return Math.max(this.leftArgument.getCategory(), this.rightArgument.getCategory());
    }

    @Override
    public void orderExpression() {
        this.leftArgument.orderExpression();
        this.rightArgument.orderExpression();
    }

    @Override
    public String toString() {
        String string = "";
        switch (this.type) {
            case 116: {
                string = "=>";
                break;
            }
            case 102: {
                string = "<";
                break;
            }
            case 104: {
                string = "<=";
                break;
            }
            case 108: {
                string = ">=";
                break;
            }
            case 106: {
                string = ">";
                break;
            }
            case 103: {
                string = "lex<";
                break;
            }
            case 105: {
                string = "lex<=";
                break;
            }
            case 109: {
                string = "lex>=";
                break;
            }
            case 107: {
                string = "lex>";
            }
        }
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.leftArgument instanceof AtomExpression) {
            stringBuffer.append(this.leftArgument);
        } else {
            stringBuffer.append("(" + this.leftArgument + ")");
        }
        stringBuffer.append(string);
        if (this.rightArgument instanceof AtomExpression) {
            stringBuffer.append(this.rightArgument);
        } else {
            stringBuffer.append("(" + this.rightArgument + ")");
        }
        return stringBuffer.toString();
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        NonCommutativeRelationalBinaryExpression nonCommutativeRelationalBinaryExpression = (NonCommutativeRelationalBinaryExpression)expression;
        if (this.leftArgument.getType() == nonCommutativeRelationalBinaryExpression.leftArgument.getType()) {
            char c = this.leftArgument.isSmallerThanSameType(nonCommutativeRelationalBinaryExpression.leftArgument);
            if (c == 'e') {
                if (this.rightArgument.getType() == nonCommutativeRelationalBinaryExpression.rightArgument.getType()) {
                    return this.rightArgument.isSmallerThanSameType(nonCommutativeRelationalBinaryExpression.rightArgument);
                }
                return this.rightArgument.getType() < nonCommutativeRelationalBinaryExpression.rightArgument.getType() ? (char)'s' : 'g';
            }
            return c;
        }
        return this.leftArgument.getType() < nonCommutativeRelationalBinaryExpression.leftArgument.getType() ? (char)'s' : 'g';
    }

    @Override
    public Expression evaluate() {
        this.leftArgument = this.leftArgument.evaluate();
        this.rightArgument = this.rightArgument.evaluate();
        if (this.type == 116) {
            if (this.leftArgument.getType() == 0 && this.rightArgument.getType() == 0) {
                boolean bl = ((RelationalAtomExpression)this.leftArgument).getBool();
                boolean bl2 = ((RelationalAtomExpression)this.rightArgument).getBool();
                return new RelationalAtomExpression(!bl || bl2);
            }
            if (this.leftArgument.getType() == 0) {
                boolean bl = ((RelationalAtomExpression)this.leftArgument).getBool();
                return bl ? this.rightArgument : new RelationalAtomExpression(true);
            }
            if (this.leftArgument.getType() == 3) {
                int n = ((ArithmeticAtomExpression)this.leftArgument).getConstant();
                if (n == 0) {
                    return new RelationalAtomExpression(true);
                }
                if (n == 1) {
                    return this.rightArgument;
                }
            }
        } else {
            int n = -11111;
            int n2 = -11111;
            if (this.leftArgument.getType() == 0) {
                n = ((RelationalAtomExpression)this.leftArgument).toArithmeticExpression().getConstant();
            }
            if (this.rightArgument.getType() == 0) {
                n2 = ((RelationalAtomExpression)this.rightArgument).toArithmeticExpression().getConstant();
            }
            if (this.leftArgument.getType() == 3) {
                n = ((ArithmeticAtomExpression)this.leftArgument).getConstant();
            }
            if (this.rightArgument.getType() == 3) {
                n2 = ((ArithmeticAtomExpression)this.rightArgument).getConstant();
            }
            if (n != -11111 && n2 != -11111) {
                switch (this.type) {
                    case 102: {
                        return new RelationalAtomExpression(n < n2);
                    }
                    case 104: {
                        return new RelationalAtomExpression(n <= n2);
                    }
                    case 106: {
                        return new RelationalAtomExpression(n > n2);
                    }
                    case 108: {
                        return new RelationalAtomExpression(n >= n2);
                    }
                    case 103: {
                        return new RelationalAtomExpression(n < n2);
                    }
                    case 105: {
                        return new RelationalAtomExpression(n <= n2);
                    }
                    case 107: {
                        return new RelationalAtomExpression(n > n2);
                    }
                    case 109: {
                        return new RelationalAtomExpression(n >= n2);
                    }
                }
            } else if (n != -11111) {
                if (this.type == 102) {
                    if (this.rightArgument.getDomain()[0] > n) {
                        return new RelationalAtomExpression(true);
                    }
                    if (n >= this.rightArgument.getDomain()[1]) {
                        return new RelationalAtomExpression(false);
                    }
                } else if (this.type == 104) {
                    if (this.rightArgument.getDomain()[0] > n) {
                        return new RelationalAtomExpression(true);
                    }
                    if (n > this.rightArgument.getDomain()[1]) {
                        return new RelationalAtomExpression(false);
                    }
                } else if (this.type == 106) {
                    if (this.rightArgument.getDomain()[1] < n) {
                        return new RelationalAtomExpression(true);
                    }
                    if (n <= this.rightArgument.getDomain()[0]) {
                        return new RelationalAtomExpression(false);
                    }
                } else if (this.type == 108) {
                    if (this.rightArgument.getDomain()[1] < n) {
                        return new RelationalAtomExpression(true);
                    }
                    if (n < this.rightArgument.getDomain()[0]) {
                        return new RelationalAtomExpression(false);
                    }
                }
            } else if (n2 != -11111) {
                if (this.type == 106) {
                    if (this.leftArgument.getDomain()[0] > n2) {
                        return new RelationalAtomExpression(true);
                    }
                    if (n2 >= this.leftArgument.getDomain()[1]) {
                        return new RelationalAtomExpression(false);
                    }
                } else if (this.type == 108) {
                    if (this.leftArgument.getDomain()[0] > n2) {
                        return new RelationalAtomExpression(true);
                    }
                    if (n2 > this.leftArgument.getDomain()[1]) {
                        return new RelationalAtomExpression(false);
                    }
                } else if (this.type == 102) {
                    if (this.leftArgument.getDomain()[1] < n2) {
                        return new RelationalAtomExpression(true);
                    }
                    if (n2 <= this.leftArgument.getDomain()[0]) {
                        return new RelationalAtomExpression(false);
                    }
                } else if (this.type == 104) {
                    if (this.leftArgument.getDomain()[1] < n2) {
                        return new RelationalAtomExpression(true);
                    }
                    if (n2 < this.leftArgument.getDomain()[0]) {
                        return new RelationalAtomExpression(false);
                    }
                }
            }
        }
        return this;
    }

    @Override
    public Expression reduceExpressionTree() {
        this.leftArgument = this.leftArgument.reduceExpressionTree();
        this.rightArgument = this.rightArgument.reduceExpressionTree();
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        this.leftArgument = this.leftArgument.insertValueForVariable(n, string);
        this.rightArgument = this.rightArgument.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        this.leftArgument = this.leftArgument.insertValueForVariable(bl, string);
        this.rightArgument = this.rightArgument.insertValueForVariable(bl, string);
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        this.leftArgument = this.leftArgument.replaceVariableWithExpression(string, expression);
        this.rightArgument = this.rightArgument.replaceVariableWithExpression(string, expression);
        return this;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public Expression restructure() {
        if (this.leftArgument instanceof Sum) {
            Sum sum = (Sum)this.leftArgument;
            if (this.rightArgument instanceof UnaryMinus) {
                ArrayList<Expression> arrayList = sum.getPositiveArguments();
                arrayList.add(((UnaryMinus)this.rightArgument).getArgument());
                this.rightArgument = new ArithmeticAtomExpression(0);
            } else if (!(this.rightArgument instanceof ArithmeticAtomExpression) && !(this.rightArgument instanceof RelationalAtomExpression)) {
                ArrayList<Expression> arrayList = sum.getNegativeArguments();
                arrayList.add(this.rightArgument.copy());
                this.rightArgument = new ArithmeticAtomExpression(0);
            }
            this.leftArgument = this.leftArgument.reduceExpressionTree();
            this.leftArgument = this.leftArgument.restructure();
            this.leftArgument.orderExpression();
            this.leftArgument = this.leftArgument.evaluate();
        } else if (this.rightArgument instanceof Sum) {
            Sum sum = (Sum)this.rightArgument;
            if (this.leftArgument instanceof UnaryMinus) {
                ArrayList<Expression> arrayList = sum.getPositiveArguments();
                arrayList.add(((UnaryMinus)this.leftArgument).getArgument());
                this.leftArgument = new ArithmeticAtomExpression(0);
            } else if (!(this.leftArgument instanceof ArithmeticAtomExpression) && !(this.leftArgument instanceof RelationalAtomExpression)) {
                ArrayList<Expression> arrayList = sum.getNegativeArguments();
                arrayList.add(this.leftArgument.copy());
                this.leftArgument = new ArithmeticAtomExpression(0);
            }
            this.rightArgument = this.rightArgument.reduceExpressionTree();
            this.rightArgument = this.rightArgument.restructure();
            this.rightArgument.orderExpression();
            this.rightArgument = this.rightArgument.evaluate();
        }
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        this.leftArgument = this.leftArgument.insertDomainForVariable(domain, string);
        this.rightArgument = this.rightArgument.insertDomainForVariable(domain, string);
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        this.leftArgument = this.leftArgument.replaceVariableWith(variable, variable2);
        this.rightArgument = this.rightArgument.replaceVariableWith(variable, variable2);
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        if (this.type == 116 || this.type == 109 || this.type == 105 || this.type == 103 || this.type == 107) {
            return false;
        }
        return this.leftArgument.isLinearExpression() && this.rightArgument.isLinearExpression();
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        if (targetSolver instanceof Gecode && this.isLinearExpression()) {
            String string = "";
            switch (this.type) {
                case 102: {
                    string = "<";
                    break;
                }
                case 104: {
                    string = "<=";
                    break;
                }
                case 108: {
                    string = ">=";
                    break;
                }
                case 106: {
                    string = ">";
                    break;
                }
                default: {
                    throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
                }
            }
            return this.leftArgument + string + this.rightArgument;
        }
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    public void setType(int n) {
        this.type = n;
    }

    @Override
    public Expression invertExpression() {
        switch (this.type) {
            case 102: {
                this.setType(108);
                return this;
            }
            case 108: {
                this.setType(102);
                return this;
            }
            case 104: {
                this.setType(106);
                return this;
            }
            case 106: {
                this.setType(104);
                return this;
            }
        }
        return new Negation(this);
    }

    @Override
    public boolean isEasyNegatable() {
        return this.type == 102 || this.type == 108 || this.type == 104 || this.type == 106;
    }

    @Override
    public void setLeftExpression(Expression expression) {
        this.leftArgument = expression;
    }

    @Override
    public void setRightExpression(Expression expression) {
        this.rightArgument = expression;
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        this.leftArgument.adaptIndicesForSolver(string, expressionArray);
        this.rightArgument.adaptIndicesForSolver(string, expressionArray);
    }
}

