/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.BinaryArithmeticExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.Variable;
import translator.solver.Gecode;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonCommutativeArithmeticBinaryExpression
implements BinaryArithmeticExpression {
    private Expression leftArgument;
    private Expression rightArgument;
    private int type;
    private boolean isNested = true;
    private boolean willBeReified = false;

    public NonCommutativeArithmeticBinaryExpression(Expression expression, int n, Expression expression2) {
        this.leftArgument = expression;
        this.rightArgument = expression2;
        this.type = n;
    }

    @Override
    public boolean isQuantified() {
        return this.leftArgument.isQuantified() || this.rightArgument.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        ArrayList<Expression> arrayList = this.rightArgument.getQuantifyingVariables();
        ArrayList<Expression> arrayList2 = this.leftArgument.getQuantifyingVariables();
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(arrayList2.remove(0));
        }
        return arrayList;
    }

    @Override
    public Expression getLeftArgument() {
        return this.leftArgument;
    }

    @Override
    public Expression getRightArgument() {
        return this.rightArgument;
    }

    @Override
    public int[] getDomain() {
        int[] nArray = this.rightArgument.getDomain();
        int[] nArray2 = this.leftArgument.getDomain();
        int n = nArray2[0];
        int n2 = nArray[0];
        int n3 = nArray2[1];
        int n4 = nArray[1];
        int n5 = -100000;
        int n6 = 100000;
        switch (this.type) {
            case 112: {
                if (n >= 0 && n2 >= 0) {
                    n5 = 0;
                } else {
                    int n7 = n5 = n3 > n4 ? -n3 : -n4;
                }
                if (n3 >= 0 && n4 >= 0) {
                    n6 = n3 / n2;
                    break;
                }
                n6 = n3 > n4 ? n3 : n4;
                break;
            }
            case 114: {
                n5 = 0;
                n6 = 1;
                if (n4 > 0) {
                    for (int i = 0; i < n4; ++i) {
                        n6 *= n3;
                    }
                    break;
                }
                n6 = n3;
                break;
            }
            case 122: {
                n5 = 0;
                n6 = n4 - 1;
            }
        }
        return new int[]{n5, n6};
    }

    @Override
    public Expression[] getDefinedDomain() {
        Expression expression = this.leftArgument.getDefinedDomain()[0];
        Expression expression2 = this.leftArgument.getDefinedDomain()[1];
        Expression expression3 = this.rightArgument.getDefinedDomain()[0];
        Expression expression4 = this.rightArgument.getDefinedDomain()[1];
        if (expression.getType() == 3 && expression2.getType() == 3 && expression3.getType() == 3 && expression4.getType() == 3) {
            int[] nArray = this.getDomain();
            return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(nArray[0]), new ArithmeticAtomExpression(nArray[1])};
        }
        if (this.type == 122) {
            return new Expression[]{new ArithmeticAtomExpression(0), expression4};
        }
        return new Expression[]{new NonCommutativeArithmeticBinaryExpression(expression, this.type, expression3).evaluate(), new NonCommutativeArithmeticBinaryExpression(expression2, this.type, expression4).evaluate()};
    }

    @Override
    public Expression copy() {
        int n = this.type;
        return new NonCommutativeArithmeticBinaryExpression(this.leftArgument.copy(), n, this.rightArgument.copy());
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getCategory() {
        return Math.max(this.leftArgument.getCategory(), this.rightArgument.getCategory());
    }

    @Override
    public void orderExpression() {
        this.leftArgument.orderExpression();
        this.rightArgument.orderExpression();
    }

    @Override
    public String toString() {
        String string = "";
        switch (this.type) {
            case 112: {
                string = "/";
                break;
            }
            case 114: {
                string = "^";
                break;
            }
            case 111: {
                string = "-";
                break;
            }
            case 110: {
                string = "+";
                break;
            }
            case 113: {
                string = "*";
                break;
            }
            case 122: {
                string = "%";
                break;
            }
            case 121: {
                string = "max";
                return string + "([" + this.leftArgument + "," + this.rightArgument + "])";
            }
            case 120: {
                string = "min";
                return string + "([" + this.leftArgument + "," + this.rightArgument + "])";
            }
        }
        return "(" + this.leftArgument + ")" + string + "(" + this.rightArgument + ")";
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        NonCommutativeArithmeticBinaryExpression nonCommutativeArithmeticBinaryExpression = (NonCommutativeArithmeticBinaryExpression)expression;
        if (this.leftArgument.getType() == nonCommutativeArithmeticBinaryExpression.leftArgument.getType()) {
            char c = this.leftArgument.isSmallerThanSameType(nonCommutativeArithmeticBinaryExpression.leftArgument);
            if (c == 'e') {
                if (this.rightArgument.getType() == nonCommutativeArithmeticBinaryExpression.rightArgument.getType()) {
                    return this.rightArgument.isSmallerThanSameType(nonCommutativeArithmeticBinaryExpression.rightArgument);
                }
                return this.rightArgument.getType() < nonCommutativeArithmeticBinaryExpression.rightArgument.getType() ? (char)'s' : 'g';
            }
            return c;
        }
        return this.leftArgument.getType() < nonCommutativeArithmeticBinaryExpression.leftArgument.getType() ? (char)'s' : 'g';
    }

    @Override
    public Expression evaluate() {
        this.leftArgument = this.leftArgument.evaluate();
        this.rightArgument = this.rightArgument.evaluate();
        if (this.leftArgument.getType() == 3 && this.rightArgument.getType() == 3) {
            int n;
            int n2 = ((ArithmeticAtomExpression)this.leftArgument).getConstant();
            int n3 = ((ArithmeticAtomExpression)this.rightArgument).getConstant();
            if (this.type == 122) {
                n = n2 % n3;
            } else if (this.type == 114) {
                n = 1;
                for (int i = 1; i <= n3; ++i) {
                    n *= n2;
                }
            } else if (this.type == 112) {
                n = n2 / n3;
            } else {
                return this;
            }
            return new ArithmeticAtomExpression(n);
        }
        if (this.leftArgument.getType() == 3 && ((ArithmeticAtomExpression)this.leftArgument).getConstant() == 0) {
            return new ArithmeticAtomExpression(0);
        }
        return this;
    }

    @Override
    public Expression reduceExpressionTree() {
        this.leftArgument = this.leftArgument.reduceExpressionTree();
        this.rightArgument = this.rightArgument.reduceExpressionTree();
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        this.leftArgument = this.leftArgument.insertValueForVariable(n, string);
        this.rightArgument = this.rightArgument.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        this.leftArgument = this.leftArgument.insertValueForVariable(bl, string);
        this.rightArgument = this.rightArgument.insertValueForVariable(bl, string);
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        this.leftArgument = this.leftArgument.replaceVariableWithExpression(string, expression);
        this.rightArgument = this.rightArgument.replaceVariableWithExpression(string, expression);
        return this;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public Expression restructure() {
        this.leftArgument = this.leftArgument.restructure();
        this.rightArgument = this.rightArgument.restructure();
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        this.leftArgument = this.leftArgument.insertDomainForVariable(domain, string);
        this.rightArgument = this.rightArgument.insertDomainForVariable(domain, string);
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        this.leftArgument = this.leftArgument.replaceVariableWith(variable, variable2);
        this.rightArgument = this.rightArgument.replaceVariableWith(variable, variable2);
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return this.leftArgument.isLinearExpression() && this.rightArgument.isLinearExpression();
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        if (targetSolver instanceof Gecode) {
            return this.toString();
        }
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    public int getOperator() {
        if (this.type == 122) {
            return 122;
        }
        return this.type;
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        this.leftArgument.adaptIndicesForSolver(string, expressionArray);
        this.rightArgument.adaptIndicesForSolver(string, expressionArray);
    }
}

