/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.CommutativeBinaryRelationalExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.NonCommutativeRelationalBinaryExpression;
import translator.expression.RelationalAtomExpression;
import translator.expression.UnaryRelationalExpression;
import translator.expression.Variable;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Negation
implements UnaryRelationalExpression {
    private Expression argument;
    private boolean isNested;
    private boolean willBeReified;

    public Negation(Expression expression) {
        this.argument = expression;
    }

    @Override
    public Expression getArgument() {
        return this.argument;
    }

    @Override
    public void setArgument(Expression expression) {
        this.argument = expression;
    }

    @Override
    public Expression copy() {
        Negation negation = new Negation(this.argument.copy());
        negation.willBeFlattenedToVariable(this.willBeReified);
        return negation;
    }

    @Override
    public boolean isQuantified() {
        return this.argument.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        return this.argument.getQuantifyingVariables();
    }

    @Override
    public int getType() {
        return 41;
    }

    @Override
    public int getCategory() {
        return this.argument.getCategory();
    }

    @Override
    public void orderExpression() {
        this.argument.orderExpression();
    }

    @Override
    public String toString() {
        return "not " + ((Object)this.argument).toString();
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        Negation negation = (Negation)expression;
        if (this.argument.getType() == negation.argument.getType()) {
            return this.argument.isSmallerThanSameType(negation.argument);
        }
        return this.argument.getType() < negation.argument.getType() ? (char)'s' : 'g';
    }

    @Override
    public Expression evaluate() {
        NonCommutativeRelationalBinaryExpression nonCommutativeRelationalBinaryExpression;
        this.argument = this.argument.evaluate();
        if (this.argument.getType() == 0) {
            boolean bl = ((RelationalAtomExpression)this.argument).getBool();
            return new RelationalAtomExpression(!bl);
        }
        if (this.argument.getType() == 3) {
            int n = ((ArithmeticAtomExpression)this.argument).getConstant();
            if (n == 0) {
                return new ArithmeticAtomExpression(1);
            }
            if (n == 1) {
                return new ArithmeticAtomExpression(0);
            }
        } else if (this.argument instanceof CommutativeBinaryRelationalExpression) {
            CommutativeBinaryRelationalExpression commutativeBinaryRelationalExpression = (CommutativeBinaryRelationalExpression)this.argument;
            if (commutativeBinaryRelationalExpression.isEasyNegatable()) {
                return commutativeBinaryRelationalExpression.invertExpression();
            }
        } else if (this.argument instanceof NonCommutativeRelationalBinaryExpression && (nonCommutativeRelationalBinaryExpression = (NonCommutativeRelationalBinaryExpression)this.argument).isEasyNegatable()) {
            return nonCommutativeRelationalBinaryExpression.invertExpression();
        }
        if (this.argument instanceof Negation) {
            return ((Negation)this.argument).argument;
        }
        return this;
    }

    @Override
    public Expression reduceExpressionTree() {
        this.argument = this.argument.reduceExpressionTree();
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        this.argument = this.argument.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        this.argument = this.argument.insertValueForVariable(bl, string);
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        this.argument = this.argument.replaceVariableWithExpression(string, expression);
        return this;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public Expression restructure() {
        this.argument = this.argument.restructure();
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        this.argument = this.argument.insertDomainForVariable(domain, string);
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        this.argument = this.argument.replaceVariableWith(variable, variable2);
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return this.argument.isLinearExpression();
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        this.argument.adaptIndicesForSolver(string, expressionArray);
    }
}

