/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.Expression;
import translator.expression.RelationalExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NaryRelationalExpression
implements RelationalExpression {
    private ArrayList<Expression> conjointExpressions;
    private boolean isNested = true;
    private boolean willBeReified = false;

    public ArrayList<Expression> getArguments() {
        return this.conjointExpressions;
    }

    protected ArrayList<Expression> orderExpressionList(ArrayList<Expression> arrayList) {
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList2 = this.insertIntoOrderedList(arrayList.get(i), arrayList2);
        }
        return arrayList2;
    }

    private ArrayList<Expression> insertIntoOrderedList(Expression expression, ArrayList<Expression> arrayList) {
        expression.orderExpression();
        if (arrayList.size() == 0) {
            arrayList.add(expression);
            return arrayList;
        }
        Expression expression2 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            expression2 = arrayList.get(i);
            if (expression2.getCategory() > expression.getCategory()) {
                arrayList.add(i, expression);
                return arrayList;
            }
            if (expression2.getType() > expression.getType() && expression2.getCategory() >= expression.getCategory()) {
                arrayList.add(i, expression);
                return arrayList;
            }
            if (expression2.getType() == expression.getType() && expression.getCategory() == expression2.getCategory()) {
                char c = expression.isSmallerThanSameType(expression2);
                if (c != 'e' && c != 's') continue;
                arrayList.add(i, expression);
                return arrayList;
            }
            if (i != arrayList.size() - 1) continue;
            arrayList.add(expression);
            return arrayList;
        }
        arrayList.add(expression);
        return arrayList;
    }

    protected void print_debug(String string) {
        System.out.println("[ DEBUG n-ary rel expression ] " + string);
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }
}

