/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticExpression;
import translator.expression.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NaryArithmeticExpression
implements ArithmeticExpression {
    private boolean isNested = true;
    private boolean willBeReified = false;

    @Override
    public int[] getDomain() {
        return new int[]{-100000, 100000};
    }

    protected Expression[] orderExpressionList(Expression[] expressionArray) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        for (int i = 0; i < expressionArray.length; ++i) {
            arrayList = this.insertIntoOrderedList(expressionArray[i], arrayList);
        }
        Expression[] expressionArray2 = new Expression[arrayList.size()];
        for (int i = expressionArray2.length - 1; i >= 0; --i) {
            expressionArray2[i] = arrayList.remove(i);
        }
        return expressionArray2;
    }

    protected ArrayList<Expression> orderExpressionList(ArrayList<Expression> arrayList) {
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList2 = this.insertIntoOrderedList(arrayList.get(i), arrayList2);
        }
        return arrayList2;
    }

    private ArrayList<Expression> insertIntoOrderedList(Expression expression, ArrayList<Expression> arrayList) {
        expression.orderExpression();
        if (arrayList.size() == 0) {
            arrayList.add(expression);
            return arrayList;
        }
        Expression expression2 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            char c;
            expression2 = arrayList.get(i);
            if (expression2.getType() > expression.getType()) {
                arrayList.add(i, expression);
                return arrayList;
            }
            if (expression2.getType() == expression.getType() && ((c = expression.isSmallerThanSameType(expression2)) == 'e' || c == 's')) {
                arrayList.add(i, expression);
                return arrayList;
            }
            if (i != arrayList.size() - 1) continue;
            arrayList.add(expression);
            return arrayList;
        }
        return arrayList;
    }

    protected void print_debug(String string) {
        System.out.println("[ DEBUG n-ary arithm expression ] " + string);
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }
}

