/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.AtomExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.NaryArithmeticExpression;
import translator.expression.RelationalAtomExpression;
import translator.expression.UnaryMinus;
import translator.expression.Variable;
import translator.solver.Gecode;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Multiplication
extends NaryArithmeticExpression {
    private ArrayList<Expression> arguments;
    private boolean isNested = true;
    private boolean willBeReified = false;
    private boolean convertToProductConstraint = false;

    public Multiplication(ArrayList<Expression> arrayList) {
        this.arguments = arrayList;
    }

    public Multiplication(Expression[] expressionArray) {
        this.arguments = new ArrayList();
        for (int i = 0; i < expressionArray.length; ++i) {
            this.arguments.add(expressionArray[i]);
        }
    }

    @Override
    public boolean isQuantified() {
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (!this.arguments.get(i).isQuantified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        ArrayList<Expression> arrayList = this.arguments.get(0).getQuantifyingVariables();
        int n = this.arguments.size();
        for (int i = 1; i < n; ++i) {
            ArrayList<Expression> arrayList2 = this.arguments.get(i).getQuantifyingVariables();
            int n2 = arrayList2.size();
            for (int j = 0; j < n2; ++j) {
                arrayList.add(arrayList2.remove(0));
            }
        }
        return arrayList;
    }

    public ArrayList<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public Expression copy() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        for (int i = 0; i < this.arguments.size(); ++i) {
            arrayList.add(this.arguments.get(i).copy());
        }
        return new Multiplication(arrayList);
    }

    @Override
    public int[] getDomain() {
        int n = 1;
        int n2 = 1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < this.arguments.size(); ++i) {
            int n3 = this.arguments.get(i).getDomain()[0];
            int n4 = this.arguments.get(i).getDomain()[1];
            if (n3 == 0) {
                bl2 = true;
            } else {
                bl = n3 < 0 || bl;
                n *= n3;
            }
            if (n4 == 0) {
                bl3 = true;
                continue;
            }
            bl = n4 < 0 || bl;
            n2 *= n4;
        }
        if (bl) {
            if (n2 < 0) {
                n = n2;
                n2 -= 2 * n2;
            } else {
                n = n2 - 2 * n2;
            }
        } else {
            if (bl2 && n > 0) {
                n = 0;
            }
            if (bl3 && n > 0) {
                n = 0;
            }
        }
        if (n2 < n) {
            n2 = 1073741000;
        }
        return new int[]{n, n2};
    }

    @Override
    public Expression[] getDefinedDomain() {
        boolean bl = true;
        for (int i = 0; i < this.arguments.size(); ++i) {
            bl = bl && this.arguments.get(i).getType() == 3;
        }
        if (bl) {
            int[] nArray = this.getDomain();
            return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(nArray[0]), new ArithmeticAtomExpression(nArray[1])};
        }
        Expression[][] expressionArray = new Expression[this.arguments.size()][2];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Expression expression = new ArithmeticAtomExpression(1);
        Expression expression2 = new ArithmeticAtomExpression(1);
        for (int i = 0; i < this.arguments.size(); ++i) {
            int n5;
            expressionArray[i][0] = this.arguments.get(i).getDefinedDomain()[0];
            expressionArray[i][1] = this.arguments.get(i).getDefinedDomain()[1];
            if (expressionArray[i][0].getType() == 3) {
                n5 = ((ArithmeticAtomExpression)expressionArray[i][0]).getConstant();
                if (n5 == 0) {
                    ++n;
                }
                if (n5 < 0) {
                    ++n3;
                    expression = new Multiplication(new Expression[]{expression.copy(), expressionArray[i][0]});
                } else {
                    expression = new Multiplication(new Expression[]{expression.copy(), expressionArray[i][0]});
                }
            }
            if (expressionArray[i][1].getType() == 3) {
                n5 = ((ArithmeticAtomExpression)expressionArray[i][1]).getConstant();
                if (n5 == 0) {
                    ++n2;
                    continue;
                }
                if (n5 < 0) {
                    ++n4;
                    expression2 = new Multiplication(new Expression[]{expression2.copy(), expressionArray[i][1]});
                    continue;
                }
                expression2 = new Multiplication(new Expression[]{expression2.copy(), expressionArray[i][1]});
                continue;
            }
            expression = new Multiplication(new Expression[]{expression.copy(), expressionArray[i][0]});
            expression2 = new Multiplication(new Expression[]{expression2.copy(), expressionArray[i][1]});
        }
        expression = expression.reduceExpressionTree();
        expression.orderExpression();
        expression = expression.evaluate();
        expression2 = expression2.reduceExpressionTree();
        expression2.orderExpression();
        expression2 = expression2.evaluate();
        if (n == this.arguments.size()) {
            expression = new ArithmeticAtomExpression(0);
        } else if (n3 > 0 && n3 % 2 == 0) {
            expression = new UnaryMinus(expression);
        }
        if (n2 == this.arguments.size()) {
            expression2 = new ArithmeticAtomExpression(0);
        } else if (n4 > 0 && n4 % 2 == 0) {
            expression2 = new UnaryMinus(expression2);
        }
        return new Expression[]{expression, expression2};
    }

    @Override
    public int getType() {
        return 113;
    }

    @Override
    public int getCategory() {
        int n = 0;
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (n >= this.arguments.get(i).getCategory()) continue;
            n = this.arguments.get(i).getCategory();
        }
        return n;
    }

    @Override
    public void orderExpression() {
        this.arguments = this.orderExpressionList(this.arguments);
    }

    @Override
    public String toString() {
        if (this.arguments.size() == 0) {
            return "empty*";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.arguments.get(0) instanceof AtomExpression) {
            stringBuffer.append(((Object)this.arguments.get(0)).toString());
        } else {
            stringBuffer.append("(" + ((Object)this.arguments.get(0)).toString() + ")");
        }
        for (int i = 1; i < this.arguments.size(); ++i) {
            if (this.arguments.get(i) instanceof AtomExpression) {
                stringBuffer.append("*" + this.arguments.get(i));
                continue;
            }
            stringBuffer.append("*(" + this.arguments.get(i) + ")");
        }
        return stringBuffer.toString();
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        Multiplication multiplication = (Multiplication)expression;
        if (this.arguments.size() == multiplication.getArguments().size()) {
            for (int i = 0; i < this.arguments.size(); ++i) {
                Expression expression2 = this.arguments.get(i);
                Expression expression3 = multiplication.arguments.get(i);
                if (expression2.getType() == expression3.getType()) {
                    char c = expression2.isSmallerThanSameType(expression3);
                    if (c == 'e') continue;
                    return c;
                }
                return expression2.getType() < expression3.getType() ? (char)'s' : 'g';
            }
            return 'e';
        }
        return this.arguments.size() < multiplication.getArguments().size() ? (char)'s' : 'g';
    }

    @Override
    public Expression evaluate() {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < this.arguments.size(); ++n) {
            this.arguments.add(n, this.arguments.remove(n).evaluate());
        }
        for (n = this.arguments.size() - 1; n >= 0; --n) {
            Expression expression = this.arguments.get(n);
            if (expression.getType() == 3) {
                arrayList.add(((ArithmeticAtomExpression)this.arguments.remove(n)).getConstant());
                continue;
            }
            if (expression.getType() != 0) continue;
            arrayList.add(((RelationalAtomExpression)this.arguments.remove(n)).toArithmeticExpression().getConstant());
        }
        n = 1;
        for (int i = 0; i < arrayList.size(); ++i) {
            n = (Integer)arrayList.get(i) * n;
        }
        if (n == 0) {
            return new ArithmeticAtomExpression(0);
        }
        if (n == 1) {
            if (this.arguments.size() == 0) {
                return new ArithmeticAtomExpression(1);
            }
            if (this.arguments.size() == 1) {
                return this.arguments.get(0);
            }
            return this;
        }
        if (this.arguments.size() == 0) {
            return new ArithmeticAtomExpression(n);
        }
        this.arguments.add(0, new ArithmeticAtomExpression(n));
        return this;
    }

    @Override
    public Expression reduceExpressionTree() {
        for (int i = this.arguments.size() - 1; i >= 0; --i) {
            this.arguments.add(i, this.arguments.remove(i).reduceExpressionTree());
            if (this.arguments.get(i).getType() != 113) continue;
            Multiplication multiplication = (Multiplication)this.arguments.remove(i);
            for (int j = multiplication.arguments.size() - 1; j >= 0; --j) {
                this.arguments.add(multiplication.arguments.remove(j));
            }
        }
        if (this.arguments.size() == 1) {
            return this.arguments.remove(0);
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        for (int i = 0; i < this.arguments.size(); ++i) {
            this.arguments.add(i, this.arguments.remove(i).insertValueForVariable(n, string));
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        for (int i = 0; i < this.arguments.size(); ++i) {
            this.arguments.add(i, this.arguments.remove(i).insertValueForVariable(bl, string));
        }
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        for (int i = 0; i < this.arguments.size(); ++i) {
            this.arguments.add(i, this.arguments.remove(i).replaceVariableWithExpression(string, expression));
        }
        return this;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public Expression restructure() {
        for (int i = 0; i < this.arguments.size(); ++i) {
            this.arguments.add(i, this.arguments.remove(i).restructure());
        }
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        for (int i = 0; i < this.arguments.size(); ++i) {
            this.arguments.add(i, this.arguments.remove(i).insertDomainForVariable(domain, string));
        }
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        for (int i = 0; i < this.arguments.size(); ++i) {
            this.arguments.add(i, this.arguments.remove(i).replaceVariableWith(variable, variable2));
        }
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return !this.isNonLinearMultiplication();
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        if (targetSolver instanceof Gecode && !this.isNonLinearMultiplication()) {
            if (this.arguments.size() == 0) {
                throw new Exception("Empty multiplication: " + this);
            }
            StringBuffer stringBuffer = new StringBuffer(((Object)this.arguments.get(0)).toString());
            for (int i = 1; i < this.arguments.size(); ++i) {
                stringBuffer.append("*" + this.arguments.get(i));
            }
            return stringBuffer.toString();
        }
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        for (int i = 0; i < this.arguments.size(); ++i) {
            this.arguments.get(i).adaptIndicesForSolver(string, expressionArray);
        }
    }

    public boolean willBeConvertedToProductConstraint() {
        return this.convertToProductConstraint;
    }

    public void setWillBeConverteredToProductConstraint(boolean bl) {
        this.convertToProductConstraint = bl;
    }

    public boolean isNonLinearMultiplication() {
        int n = 0;
        for (int i = 0; i < this.arguments.size(); ++i) {
            Expression expression = this.arguments.get(i);
            if (expression.getType() == 3 || expression.getType() == 0) continue;
            ++n;
        }
        return n > 1;
    }
}

