/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.BasicDomain;
import translator.expression.ConstantDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.IntRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleIntRange
implements ConstantDomain {
    private ArrayList<IntRange> rangeList;

    public MultipleIntRange(ArrayList<IntRange> arrayList) {
        this.rangeList = arrayList;
    }

    @Override
    public int[] getFullDomain() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.rangeList.size(); ++i) {
            int[] nArray = this.rangeList.get(i).getFullDomain();
            for (int j = 0; j < nArray.length; ++j) {
                arrayList.add(nArray[j]);
            }
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            nArray[i] = (Integer)arrayList.remove(i);
        }
        return nArray;
    }

    @Override
    public int[] getRange() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.rangeList.size(); ++i) {
            int[] nArray = this.rangeList.get(i).getRange();
            for (int j = 0; j < nArray.length; ++j) {
                arrayList.add(nArray[j]);
            }
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            nArray[i] = (Integer)arrayList.remove(i);
        }
        return nArray;
    }

    @Override
    public Domain copy() {
        ArrayList<IntRange> arrayList = new ArrayList<IntRange>();
        for (int i = 0; i < this.rangeList.size(); ++i) {
            arrayList.add((IntRange)this.rangeList.get(i).copy());
        }
        return new MultipleIntRange(arrayList);
    }

    @Override
    public Domain evaluate() {
        for (int i = 0; i < this.rangeList.size(); ++i) {
            this.rangeList.add(i, (IntRange)this.rangeList.remove(i).evaluate());
        }
        return this;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public int getCategory() {
        return 0;
    }

    @Override
    public String toString() {
        String string = "(";
        for (int i = 0; i < this.rangeList.size(); ++i) {
            string = string.concat(", " + this.rangeList.get(i).toString());
        }
        return string + ")";
    }

    @Override
    public boolean isConstantDomain() {
        return true;
    }

    @Override
    public Domain insertValueForVariable(int n, String string) {
        return this;
    }

    @Override
    public Domain insertValueForVariable(boolean bl, String string) {
        return this;
    }

    @Override
    public Domain replaceVariableWithDomain(String string, Domain domain) {
        return this;
    }

    @Override
    public Domain replaceVariableWithExpression(String string, Expression expression) {
        return this;
    }

    @Override
    public char isSmallerThanSameType(BasicDomain basicDomain) {
        MultipleIntRange multipleIntRange = (MultipleIntRange)basicDomain;
        if (this.rangeList.size() == multipleIntRange.rangeList.size()) {
            for (int i = 0; i < this.rangeList.size(); ++i) {
                if (this.rangeList.get(i).getType() == multipleIntRange.rangeList.get(i).getType()) {
                    char c = this.rangeList.get(i).isSmallerThanSameType(multipleIntRange.rangeList.get(i));
                    if (c == 'e') continue;
                    return c;
                }
                return this.rangeList.get(i).getType() < multipleIntRange.rangeList.get(i).getType() ? (char)'s' : 'g';
            }
            return 'e';
        }
        return this.rangeList.size() < multipleIntRange.rangeList.size() ? (char)'s' : 'g';
    }
}

