/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.BasicDomain;
import translator.expression.ConstantDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionDomain;
import translator.expression.ExpressionRange;
import translator.expression.IntRange;
import translator.expression.MultipleIntRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleExpressionRange
implements ExpressionDomain {
    ArrayList<ExpressionRange> rangeList;

    public MultipleExpressionRange(ArrayList<ExpressionRange> arrayList) {
        this.rangeList = arrayList;
    }

    @Override
    public Domain copy() {
        ArrayList<ExpressionRange> arrayList = new ArrayList<ExpressionRange>();
        for (int i = 0; i < this.rangeList.size(); ++i) {
            arrayList.add((ExpressionRange)this.rangeList.get(i).copy());
        }
        return new MultipleExpressionRange(arrayList);
    }

    @Override
    public Domain evaluate() {
        boolean bl = true;
        for (int i = 0; i < this.rangeList.size(); ++i) {
            Domain domain = this.rangeList.get(i).evaluate();
            if (domain.getType() == 2 && domain.getType() == 3) continue;
            bl = false;
        }
        if (bl) {
            ArrayList<IntRange> arrayList = new ArrayList<IntRange>();
            for (int i = 0; i < this.rangeList.size(); ++i) {
                arrayList.add((IntRange)this.rangeList.get(i));
            }
            return new MultipleIntRange(arrayList);
        }
        return this;
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    public int getCategory() {
        int n = 0;
        for (int i = 0; i < this.rangeList.size(); ++i) {
            if (n >= this.rangeList.get(i).getCategory()) continue;
            n = this.rangeList.get(i).getCategory();
        }
        return n;
    }

    @Override
    public String toString() {
        String string = "(";
        for (int i = 0; i < this.rangeList.size(); ++i) {
            string = string.concat(", " + this.rangeList.get(i).toString());
        }
        return string + ")";
    }

    @Override
    public boolean isConstantDomain() {
        return false;
    }

    @Override
    public Domain insertValueForVariable(int n, String string) {
        boolean bl = true;
        for (int i = 0; i < this.rangeList.size(); ++i) {
            ExpressionRange expressionRange = (ExpressionRange)this.rangeList.remove(i).insertValueForVariable(n, string);
            this.rangeList.add(i, expressionRange);
            if (expressionRange.isConstantDomain()) continue;
            bl = false;
        }
        if (bl) {
            ArrayList<IntRange> arrayList = new ArrayList<IntRange>();
            for (int i = this.rangeList.size() - 1; i >= 0; ++i) {
                arrayList.add(0, (IntRange)this.rangeList.remove(i));
            }
            return new MultipleIntRange(arrayList);
        }
        return this;
    }

    @Override
    public Domain insertValueForVariable(boolean bl, String string) {
        boolean bl2 = true;
        for (int i = 0; i < this.rangeList.size(); ++i) {
            ExpressionRange expressionRange = (ExpressionRange)this.rangeList.remove(i).insertValueForVariable(bl, string);
            this.rangeList.add(i, expressionRange);
            if (expressionRange.isConstantDomain()) continue;
            bl2 = false;
        }
        if (bl2) {
            ArrayList<IntRange> arrayList = new ArrayList<IntRange>();
            for (int i = this.rangeList.size() - 1; i >= 0; ++i) {
                arrayList.add(0, (IntRange)this.rangeList.remove(i));
            }
            return new MultipleIntRange(arrayList);
        }
        return this;
    }

    @Override
    public Domain replaceVariableWithDomain(String string, Domain domain) {
        boolean bl = true;
        for (int i = this.rangeList.size() - 1; i >= 0; --i) {
            ExpressionRange expressionRange = this.rangeList.remove(i);
            expressionRange = (ExpressionRange)expressionRange.replaceVariableWithDomain(string, domain);
            expressionRange = (ExpressionRange)expressionRange.evaluate();
            bl = bl && expressionRange instanceof ConstantDomain;
            this.rangeList.add(i, expressionRange);
        }
        if (bl) {
            ArrayList<IntRange> arrayList = new ArrayList<IntRange>();
            for (int i = 0; i < this.rangeList.size(); ++i) {
                arrayList.add(i, (IntRange)this.rangeList.get(i));
            }
            return new MultipleIntRange(arrayList);
        }
        return this;
    }

    @Override
    public Domain replaceVariableWithExpression(String string, Expression expression) throws Exception {
        boolean bl = true;
        for (int i = this.rangeList.size() - 1; i >= 0; --i) {
            ExpressionRange expressionRange = this.rangeList.remove(i);
            expressionRange = (ExpressionRange)expressionRange.replaceVariableWithExpression(string, expression);
            expressionRange = (ExpressionRange)expressionRange.evaluate();
            bl = bl && expressionRange instanceof ConstantDomain;
            this.rangeList.add(i, expressionRange);
        }
        if (bl) {
            ArrayList<IntRange> arrayList = new ArrayList<IntRange>();
            for (int i = 0; i < this.rangeList.size(); ++i) {
                arrayList.add(i, (IntRange)this.rangeList.get(i));
            }
            return new MultipleIntRange(arrayList);
        }
        return this;
    }

    @Override
    public char isSmallerThanSameType(BasicDomain basicDomain) {
        MultipleExpressionRange multipleExpressionRange = (MultipleExpressionRange)basicDomain;
        if (this.rangeList.size() == multipleExpressionRange.rangeList.size()) {
            for (int i = 0; i < this.rangeList.size(); ++i) {
                if (this.rangeList.get(i).getType() == multipleExpressionRange.rangeList.get(i).getType()) {
                    char c = this.rangeList.get(i).isSmallerThanSameType(multipleExpressionRange.rangeList.get(i));
                    if (c == 'e') continue;
                    return c;
                }
                return this.rangeList.get(i).getType() < multipleExpressionRange.rangeList.get(i).getType() ? (char)'s' : 'g';
            }
            return 'e';
        }
        return this.rangeList.size() < multipleExpressionRange.rangeList.size() ? (char)'s' : 'g';
    }
}

