/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.Array;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.RelationalExpression;
import translator.expression.Variable;
import translator.expression.VariableArray;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimumConstraint
implements RelationalExpression {
    private Array arguments;
    private Expression result;
    private boolean isMaximum;
    private boolean willBeFlattenedToVar = false;
    private boolean isNested = true;

    public MinimumConstraint(Array array, Expression expression, boolean bl) {
        this.arguments = array;
        this.result = expression;
        this.isMaximum = bl;
    }

    @Override
    public boolean isQuantified() {
        return this.arguments.isQuantified() || this.result.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        ArrayList<Expression> arrayList = this.arguments.getQuantifyingVariables();
        ArrayList<Expression> arrayList2 = this.result.getQuantifyingVariables();
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(arrayList2.remove(0));
        }
        return arrayList;
    }

    @Override
    public Expression copy() {
        return new MinimumConstraint((Array)this.arguments.copy(), this.result.copy(), this.isMaximum);
    }

    @Override
    public Expression evaluate() {
        this.arguments = (Array)this.arguments.evaluate();
        this.result = this.result.evaluate();
        return this;
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public int getType() {
        return this.isMaximum ? 283 : 282;
    }

    @Override
    public int getCategory() {
        return Math.max(this.arguments.getCategory(), this.result.getCategory());
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        this.arguments = (Array)this.arguments.insertDomainForVariable(domain, string);
        this.result = this.arguments.insertDomainForVariable(domain, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        this.arguments = (Array)this.arguments.insertValueForVariable(n, string);
        this.result = this.result.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        this.arguments = (Array)this.arguments.insertValueForVariable(bl, string);
        this.result = this.result.insertValueForVariable(bl, string);
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeFlattenedToVar;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        return 'e';
    }

    @Override
    public void orderExpression() {
        this.arguments.orderExpression();
        this.result.orderExpression();
    }

    @Override
    public Expression reduceExpressionTree() {
        this.arguments = (Array)this.arguments.reduceExpressionTree();
        this.result = this.result.reduceExpressionTree();
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        this.arguments = (Array)this.arguments.replaceVariableWith(variable, variable2);
        this.result = this.result.replaceVariableWith(variable, variable2);
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        this.arguments = (Array)this.arguments.replaceVariableWithExpression(string, expression);
        this.result = this.result.replaceVariableWithExpression(string, expression);
        return this;
    }

    @Override
    public Expression restructure() {
        this.arguments = (Array)this.arguments.restructure();
        this.result = this.result.restructure();
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeFlattenedToVar = bl;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(((Object)this.result).toString());
        stringBuffer.append(" = ");
        stringBuffer.append(this.isMaximum ? "max(" : "min(");
        stringBuffer.append(this.arguments);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        if (this.arguments != null) {
            this.arguments.adaptIndicesForSolver(string, expressionArray);
        }
        if (this.result != null) {
            this.result.adaptIndicesForSolver(string, expressionArray);
        }
    }

    public Array getArguments() {
        return this.arguments;
    }

    public Expression getResult() {
        return this.result;
    }

    public boolean isMaximum() {
        return this.isMaximum;
    }

    public boolean isBinary() {
        if (this.arguments instanceof VariableArray) {
            VariableArray variableArray = (VariableArray)this.arguments;
            return variableArray.getVariables().length == 2;
        }
        return false;
    }
}

