/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.Array;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.UnaryArithmeticExpression;
import translator.expression.Variable;
import translator.expression.VariableArray;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Minimum
implements UnaryArithmeticExpression {
    private boolean isMaximum;
    private Array argument;
    private Expression expression;
    boolean willBeFlattened = false;
    boolean isNested = true;

    public Minimum(Array array, boolean bl) {
        this.argument = array;
        this.isMaximum = bl;
    }

    public Minimum(Expression expression, boolean bl) {
        this.expression = expression;
        this.isMaximum = bl;
    }

    @Override
    public boolean isQuantified() {
        if (this.argument != null) {
            return this.argument.isQuantified();
        }
        return this.expression.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        if (this.argument != null) {
            return this.argument.getQuantifyingVariables();
        }
        return this.expression.getQuantifyingVariables();
    }

    @Override
    public Expression getArgument() {
        if (this.expression == null) {
            return this.argument;
        }
        return this.expression;
    }

    @Override
    public Expression copy() {
        if (this.argument == null) {
            return new Minimum(this.expression.copy(), this.isMaximum);
        }
        return new Minimum(this.argument.copy(), this.isMaximum);
    }

    @Override
    public Expression evaluate() {
        VariableArray variableArray;
        if (this.expression != null) {
            this.expression = this.expression.evaluate();
            if (this.expression instanceof Array) {
                this.argument = (Array)this.expression;
                this.expression = null;
            }
        } else if (this.argument != null) {
            this.argument = (Array)this.argument.evaluate();
        }
        if (this.argument != null && this.argument instanceof VariableArray && (variableArray = (VariableArray)this.argument).getVariables().length == 1) {
            return variableArray.getVariables()[0];
        }
        return this;
    }

    @Override
    public int[] getDomain() {
        if (this.argument != null) {
            return this.argument.getDomain();
        }
        return this.expression.getDomain();
    }

    @Override
    public Expression[] getDefinedDomain() {
        if (this.argument != null) {
            return this.argument.getDefinedDomain();
        }
        return this.expression.getDefinedDomain();
    }

    @Override
    public int getType() {
        return this.isMaximum ? 121 : 120;
    }

    @Override
    public int getCategory() {
        return this.argument == null ? this.expression.getCategory() : this.argument.getCategory();
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        if (this.argument != null) {
            this.argument = (Array)this.argument.insertDomainForVariable(domain, string);
        } else {
            this.expression = this.expression.insertDomainForVariable(domain, string);
        }
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        if (this.argument != null) {
            this.argument = (Array)this.argument.replaceVariableWith(variable, variable2);
        } else {
            this.expression = this.expression.replaceVariableWith(variable, variable2);
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        if (this.argument != null) {
            this.argument = (Array)this.argument.insertValueForVariable(n, string);
        } else {
            this.expression = this.expression.insertValueForVariable(n, string);
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        if (this.argument != null) {
            this.argument = (Array)this.argument.insertValueForVariable(bl, string);
        } else {
            this.expression = this.expression.insertValueForVariable(bl, string);
        }
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        if (this.argument != null) {
            Expression expression2 = this.argument.replaceVariableWithExpression(string, expression);
            if (expression2 instanceof Array) {
                this.argument = (Array)expression2;
            } else {
                try {
                    throw new Exception("Replacing variable '" + string + "' with infeasible expression '" + expression + "' that modifies minimum-array into:" + expression2 + ". Expected array type.");
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                    System.exit(1);
                }
            }
        }
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeFlattened;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        return 'e';
    }

    @Override
    public void orderExpression() {
        if (this.argument != null) {
            this.argument.orderExpression();
        } else {
            this.expression.orderExpression();
        }
    }

    @Override
    public Expression reduceExpressionTree() {
        return this;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeFlattened = bl;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.isMaximum ? "max(" : "min(");
        stringBuffer.append(this.argument + ")");
        return stringBuffer.toString();
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        if (this.argument != null) {
            this.argument.adaptIndicesForSolver(string, expressionArray);
        }
        if (this.expression != null) {
            this.expression.adaptIndicesForSolver(string, expressionArray);
        }
    }

    public boolean isMaximum() {
        return this.isMaximum;
    }
}

