/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.Array;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.RelationalExpression;
import translator.expression.Variable;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexConstraint
implements RelationalExpression {
    Expression leftArray;
    Expression rightArray;
    int operator;
    boolean willBeFlattenedToVariable = false;
    boolean isNested = true;

    public LexConstraint(Array array, int n, Array array2) {
        this.leftArray = array;
        this.rightArray = array2;
        this.operator = n;
    }

    public LexConstraint(Expression expression, int n, Expression expression2) {
        this.leftArray = expression;
        this.rightArray = expression2;
        this.operator = n;
    }

    @Override
    public boolean isQuantified() {
        return this.leftArray.isQuantified() || this.rightArray.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        ArrayList<Expression> arrayList = this.rightArray.getQuantifyingVariables();
        ArrayList<Expression> arrayList2 = this.leftArray.getQuantifyingVariables();
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(arrayList2.remove(0));
        }
        return arrayList;
    }

    @Override
    public Expression copy() {
        return new LexConstraint(this.leftArray.copy(), this.operator, this.rightArray.copy());
    }

    @Override
    public Expression evaluate() {
        return this;
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public int getType() {
        return this.operator;
    }

    @Override
    public int getCategory() {
        return 3;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        this.leftArray = this.leftArray.insertDomainForVariable(domain, string);
        this.rightArray = this.rightArray.insertDomainForVariable(domain, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        this.leftArray = this.leftArray.insertValueForVariable(n, string);
        this.rightArray = this.rightArray.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        this.leftArray = this.leftArray.insertValueForVariable(bl, string);
        this.rightArray = this.rightArray.insertValueForVariable(bl, string);
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        this.leftArray = this.leftArray.replaceVariableWithExpression(string, expression);
        this.rightArray = this.rightArray.replaceVariableWithExpression(string, expression);
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeFlattenedToVariable;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        LexConstraint lexConstraint = (LexConstraint)expression;
        if (this.operator == lexConstraint.getType()) {
            if (this.leftArray.getType() == lexConstraint.leftArray.getType()) {
                char c = this.leftArray.isSmallerThanSameType(lexConstraint.leftArray);
                if (c == 'e') {
                    if (this.rightArray.getType() == lexConstraint.rightArray.getType()) {
                        return this.rightArray.isSmallerThanSameType(lexConstraint.rightArray);
                    }
                    return this.rightArray.getType() < lexConstraint.rightArray.getType() ? (char)'s' : 'g';
                }
                return c;
            }
            return this.leftArray.getType() < lexConstraint.leftArray.getType() ? (char)'s' : 'g';
        }
        return this.operator < lexConstraint.getType() ? (char)'s' : 'g';
    }

    @Override
    public void orderExpression() {
    }

    @Override
    public Expression reduceExpressionTree() {
        return this;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeFlattenedToVariable = bl;
    }

    @Override
    public String toString() {
        String string = "" + this.leftArray;
        String string2 = "";
        switch (this.operator) {
            case 109: {
                string2 = ">=lex";
                break;
            }
            case 105: {
                string2 = "<=lex";
                break;
            }
            case 103: {
                string2 = "<lex";
                break;
            }
            case 107: {
                string2 = ">lex";
            }
        }
        return string + " " + string2 + " " + this.rightArray;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        this.leftArray.adaptIndicesForSolver(string, expressionArray);
        this.rightArray.adaptIndicesForSolver(string, expressionArray);
    }

    public Expression getLeftArray() {
        return this.leftArray;
    }

    public Expression getRightArray() {
        return this.rightArray;
    }

    public int getOperator() {
        return this.operator;
    }
}

