/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.BasicDomain;
import translator.expression.BoundedExpressionRange;
import translator.expression.BoundedIntRange;
import translator.expression.ConstantDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.IdentifierDomain;
import translator.expression.SingleArray;
import translator.expression.SingleRange;
import translator.expression.SparseExpressionRange;
import translator.expression.SparseIntRange;
import translator.expression.Sum;
import translator.expression.Variable;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedArray
implements SingleArray {
    private String arrayName;
    private BasicDomain[] indexRanges;
    private Domain baseDomain;
    private boolean willBeFlattenedToVariable = false;
    private boolean isNested = true;
    private boolean isIndexAdaptedToSolver = false;

    public IndexedArray(String string, BasicDomain[] basicDomainArray, Domain domain) {
        this.arrayName = string;
        this.indexRanges = basicDomainArray;
        this.baseDomain = domain;
    }

    @Override
    public boolean isQuantified() {
        for (int i = 0; i < this.indexRanges.length; ++i) {
            ExpressionRange expressionRange;
            if (!(this.indexRanges[i] instanceof ExpressionRange) || !(expressionRange = (ExpressionRange)this.indexRanges[i]).getLowerAndUpperBound()[0].isQuantified() && !expressionRange.getLowerAndUpperBound()[1].isQuantified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        for (int i = 0; i < this.indexRanges.length; ++i) {
            if (!(this.indexRanges[i] instanceof ExpressionRange)) continue;
            ExpressionRange expressionRange = (ExpressionRange)this.indexRanges[i];
            ArrayList<Expression> arrayList2 = expressionRange.getLowerAndUpperBound()[0].getQuantifyingVariables();
            int n = arrayList2.size();
            for (int j = 0; j < n; ++j) {
                arrayList.add(arrayList2.remove(0));
            }
            ArrayList<Expression> arrayList3 = expressionRange.getLowerAndUpperBound()[1].getQuantifyingVariables();
            n = arrayList3.size();
            for (int j = 0; j < n; ++j) {
                arrayList.add(arrayList3.remove(0));
            }
        }
        return arrayList;
    }

    @Override
    public Expression copy() {
        BasicDomain[] basicDomainArray = new BasicDomain[this.indexRanges.length];
        for (int i = 0; i < this.indexRanges.length; ++i) {
            basicDomainArray[i] = (BasicDomain)this.indexRanges[i].copy();
        }
        return new IndexedArray(new String(this.arrayName), basicDomainArray, this.baseDomain.copy());
    }

    @Override
    public Expression evaluate() {
        for (int i = 0; i < this.indexRanges.length; ++i) {
            this.indexRanges[i] = (BasicDomain)this.indexRanges[i].evaluate();
        }
        this.baseDomain = this.baseDomain.evaluate();
        return this;
    }

    @Override
    public Domain getBaseDomain() {
        return this.baseDomain;
    }

    @Override
    public String getArrayName() {
        return this.arrayName;
    }

    @Override
    public int[] getDomain() {
        if (this.baseDomain instanceof ConstantDomain) {
            return ((ConstantDomain)this.baseDomain).getRange();
        }
        return new int[]{-100000, 100000};
    }

    @Override
    public Expression[] getDefinedDomain() {
        if (this.baseDomain instanceof ConstantDomain) {
            return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(((ConstantDomain)this.baseDomain).getRange()[0]), new ArithmeticAtomExpression(((ConstantDomain)this.baseDomain).getRange()[1])};
        }
        if (this.baseDomain instanceof ExpressionRange) {
            return ((ExpressionRange)this.baseDomain).getLowerAndUpperBound();
        }
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(-100000), new ArithmeticAtomExpression(100000)};
    }

    @Override
    public int getType() {
        return 27;
    }

    @Override
    public int getCategory() {
        int n = 0;
        for (int i = 0; i < this.indexRanges.length; ++i) {
            if (n >= this.indexRanges[i].getCategory()) continue;
            n = this.indexRanges[i].getCategory();
        }
        return n;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        for (int i = 0; i < this.indexRanges.length; ++i) {
            this.indexRanges[i] = (BasicDomain)this.indexRanges[i].insertValueForVariable(n, string);
        }
        this.baseDomain = this.baseDomain.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeFlattenedToVariable;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        IndexedArray indexedArray = (IndexedArray)expression;
        if (this.arrayName.compareTo(indexedArray.arrayName) == 0) {
            if (this.indexRanges.length == indexedArray.indexRanges.length) {
                for (int i = 0; i < this.indexRanges.length; ++i) {
                    if (this.indexRanges[i].getType() == indexedArray.indexRanges[i].getType()) {
                        char c = this.indexRanges[i].isSmallerThanSameType(indexedArray.indexRanges[i]);
                        if (c == 'e') continue;
                        return c;
                    }
                    return this.indexRanges[i].getType() < indexedArray.indexRanges[i].getType() ? (char)'s' : 'g';
                }
                return 'e';
            }
            return this.indexRanges.length < indexedArray.indexRanges.length ? (char)'s' : 'g';
        }
        return this.arrayName.compareTo(indexedArray.arrayName) < 0 ? (char)'s' : 'g';
    }

    @Override
    public void orderExpression() {
    }

    @Override
    public Expression reduceExpressionTree() {
        return this;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeFlattenedToVariable = bl;
    }

    @Override
    public String toString() {
        String string = this.arrayName + "[";
        for (int i = 0; i < this.indexRanges.length; ++i) {
            if (i > 0) {
                string = string.concat(",");
            }
            string = this.indexRanges[i] instanceof BoundedExpressionRange ? string.concat(((BoundedExpressionRange)this.indexRanges[i]).getLowerAndUpperBound()[0] + ".." + ((BoundedExpressionRange)this.indexRanges[i]).getLowerAndUpperBound()[1]) : (this.indexRanges[i] instanceof BoundedIntRange ? string.concat(((BoundedIntRange)this.indexRanges[i]).getLowerAndUpperBound()[0] + ".." + ((BoundedIntRange)this.indexRanges[i]).getLowerAndUpperBound()[1]) : string.concat(this.indexRanges[i].toString()));
        }
        return string + "]";
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        String string2;
        if (this.baseDomain instanceof IdentifierDomain && (string2 = ((IdentifierDomain)this.baseDomain).getDomainName()).equals(string)) {
            this.baseDomain = domain;
        }
        for (int i = 0; i < this.indexRanges.length; ++i) {
            String string3;
            if (!(this.indexRanges[i] instanceof IdentifierDomain) || !(string3 = ((IdentifierDomain)this.indexRanges[i]).getDomainName()).equals(string) || !(domain instanceof BasicDomain)) continue;
            this.indexRanges[i] = (BasicDomain)domain;
        }
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        if (this.arrayName.equals(variable.getVariableName())) {
            return variable2;
        }
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        if (this.arrayName.equals(string) && !this.isIndexAdaptedToSolver) {
            for (int i = 0; i < this.indexRanges.length; ++i) {
                int n;
                Object object;
                ExpressionRange expressionRange;
                if (this.indexRanges[i] instanceof SingleRange) {
                    expressionRange = (SingleRange)this.indexRanges[i];
                    this.indexRanges[i] = expressionRange.setSingleExpressionRange(new Sum(new Expression[]{expressionRange.getSingleExpressionRange().copy()}, new Expression[]{expressionArray[i]}));
                    continue;
                }
                if (this.indexRanges[i] instanceof BoundedExpressionRange) {
                    expressionRange = (BoundedExpressionRange)this.indexRanges[i];
                    ((BoundedExpressionRange)expressionRange).setLowerBound(new Sum(new Expression[]{((BoundedExpressionRange)expressionRange).getLowerBound().copy()}, new Expression[]{expressionArray[i]}));
                    ((BoundedExpressionRange)expressionRange).setUpperBound(new Sum(new Expression[]{((BoundedExpressionRange)expressionRange).getUpperBound().copy()}, new Expression[]{expressionArray[i]}));
                    this.indexRanges[i] = (BasicDomain)((BoundedExpressionRange)expressionRange).evaluate();
                    continue;
                }
                if (this.indexRanges[i] instanceof BoundedIntRange) {
                    expressionRange = (BoundedIntRange)this.indexRanges[i];
                    object = new Sum(new Expression[]{new ArithmeticAtomExpression(((BoundedIntRange)expressionRange).getRange()[0])}, new Expression[]{expressionArray[i]});
                    Expression expression = new Sum(new Expression[]{new ArithmeticAtomExpression(((BoundedIntRange)expressionRange).getRange()[1])}, new Expression[]{expressionArray[i]});
                    object = object.reduceExpressionTree();
                    object.orderExpression();
                    object = object.evaluate();
                    expression = expression.reduceExpressionTree();
                    expression.orderExpression();
                    expression = expression.evaluate();
                    if (object.getType() == 3 && expression.getType() == 3) {
                        ((BoundedIntRange)expressionRange).setLowerBound(((ArithmeticAtomExpression)object).getConstant());
                        ((BoundedIntRange)expressionRange).setUpperBound(((ArithmeticAtomExpression)expression).getConstant());
                        this.indexRanges[i] = expressionRange;
                        continue;
                    }
                    this.indexRanges[i] = new BoundedExpressionRange((Expression)object, expression);
                    continue;
                }
                if (this.indexRanges[i] instanceof SparseIntRange) {
                    expressionRange = (SparseIntRange)this.indexRanges[i];
                    object = ((SparseIntRange)expressionRange).getRange();
                    Expression[] expressionArray2 = new Expression[((int[])object).length];
                    n = 1;
                    for (int j = 0; j < expressionArray2.length; ++j) {
                        expressionArray2[j] = new Sum(new Expression[]{new ArithmeticAtomExpression(object[j])}, new Expression[]{expressionArray[i]});
                        expressionArray2[j] = expressionArray2[j].reduceExpressionTree();
                        expressionArray2[j].orderExpression();
                        expressionArray2[j] = expressionArray2[j].evaluate();
                        if (expressionArray2[j].getType() == 3) continue;
                        n = 0;
                    }
                    if (n != 0) {
                        int[] nArray = new int[expressionArray2.length];
                        for (int j = 0; j < nArray.length; ++j) {
                            nArray[j] = ((ArithmeticAtomExpression)expressionArray2[j]).getConstant();
                        }
                        ((SparseIntRange)expressionRange).setIntRange(nArray);
                        this.indexRanges[i] = expressionRange;
                        continue;
                    }
                    this.indexRanges[i] = new SparseExpressionRange(expressionArray2);
                    continue;
                }
                if (!(this.indexRanges[i] instanceof SparseExpressionRange)) continue;
                expressionRange = (SparseExpressionRange)this.indexRanges[i];
                object = ((SparseExpressionRange)expressionRange).getExpressionRange();
                boolean bl = true;
                for (n = 0; n < ((int[])object).length; ++n) {
                    object[n] = (int)new Sum(new Expression[]{object[n].copy()}, new Expression[]{expressionArray[i]});
                    object[n] = object[n].reduceExpressionTree();
                    object[n].orderExpression();
                    object[n] = object[n].evaluate();
                    if (object[n].getType() == 3) continue;
                    bl = false;
                }
                if (bl) {
                    int[] nArray = new int[((int[])object).length];
                    for (int j = 0; j < nArray.length; ++j) {
                        nArray[j] = ((ArithmeticAtomExpression)object[j]).getConstant();
                    }
                    this.indexRanges[i] = new SparseIntRange(nArray);
                    continue;
                }
                ((SparseExpressionRange)expressionRange).setExpressionRange((Expression[])object);
                this.indexRanges[i] = expressionRange;
            }
        }
    }

    public boolean hasConstantIndices() {
        boolean bl = true;
        for (int i = 0; i < this.indexRanges.length; ++i) {
            bl = bl && this.indexRanges[i] instanceof ConstantDomain;
        }
        return bl;
    }

    public BasicDomain[] getIndexRanges() {
        return this.indexRanges;
    }

    public void setIndexRanges(BasicDomain[] basicDomainArray) {
        if (basicDomainArray.length == this.indexRanges.length) {
            this.indexRanges = basicDomainArray;
        }
    }
}

