/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.ArrayDomain;
import translator.expression.BasicDomain;
import translator.expression.BoolDomain;
import translator.expression.ConstantArrayDomain;
import translator.expression.ConstantDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.GlobalConstraint;
import translator.expression.RelationalAtomExpression;
import translator.expression.SimpleArray;
import translator.expression.SingleVariable;
import translator.expression.Variable;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalCardinality
implements GlobalConstraint {
    private Expression variables;
    private Expression values;
    private Expression capacities;
    private ArrayList<Expression> valuesList = new ArrayList();
    private ArrayList<Expression> capacitiesList = new ArrayList();
    private String valuesArrayName;
    private String capacitiesArrayName;
    private boolean willBeFlattenedToVariable = false;
    private boolean isNested = true;

    public GlobalCardinality(Expression expression, Expression expression2, Expression expression3) {
        this.variables = expression;
        this.values = expression2;
        this.capacities = expression3;
    }

    public GlobalCardinality(Expression expression, ArrayList<Expression> arrayList, ArrayList<Expression> arrayList2) {
        this.variables = expression;
        this.valuesList = arrayList;
        this.capacitiesList = arrayList2;
    }

    public GlobalCardinality(Expression expression, Expression expression2, ArrayList<Expression> arrayList) {
        this.variables = expression;
        this.values = expression2;
        this.capacitiesList = arrayList;
    }

    public GlobalCardinality(Expression expression, ArrayList<Expression> arrayList, Expression expression2) {
        this.variables = expression;
        this.valuesList = arrayList;
        this.capacities = expression2;
    }

    public GlobalCardinality(Expression expression, String string, ArrayList<Expression> arrayList) {
        this.variables = expression;
        this.valuesArrayName = string;
        this.capacitiesList = arrayList;
    }

    public GlobalCardinality(Expression expression, String string, Expression expression2) {
        this.variables = expression;
        this.valuesArrayName = string;
        this.capacities = expression2;
    }

    public GlobalCardinality(Expression expression, ArrayList<Expression> arrayList, String string) {
        this.variables = expression;
        this.valuesList = arrayList;
        this.capacitiesArrayName = string;
    }

    public GlobalCardinality(Expression expression, Expression expression2, String string) {
        this.variables = expression;
        this.values = expression2;
        this.capacitiesArrayName = string;
    }

    public GlobalCardinality(Expression expression, String string, String string2) {
        this.variables = expression;
        this.valuesArrayName = string;
        this.capacitiesArrayName = string2;
    }

    @Override
    public Expression[] getArguments() {
        return new Expression[]{this.variables, this.values, this.capacities};
    }

    @Override
    public Expression copy() {
        if (this.capacities != null && this.values != null) {
            return new GlobalCardinality(this.variables.copy(), this.values.copy(), this.capacities.copy());
        }
        if (this.capacitiesList.size() > 0) {
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            for (int i = 0; i < this.capacitiesList.size(); ++i) {
                arrayList.add(this.capacitiesList.get(i).copy());
            }
            if (this.valuesList.size() > 0) {
                ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
                for (int i = 0; i < this.valuesList.size(); ++i) {
                    arrayList2.add(this.valuesList.get(i).copy());
                }
                return new GlobalCardinality(this.variables.copy(), arrayList2, arrayList);
            }
            return new GlobalCardinality(this.variables.copy(), new String(this.valuesArrayName), arrayList);
        }
        String string = new String(this.capacitiesArrayName);
        if (this.valuesList.size() > 0) {
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            for (int i = 0; i < this.valuesList.size(); ++i) {
                arrayList.add(this.valuesList.get(i).copy());
            }
            return new GlobalCardinality(this.variables.copy(), arrayList, string);
        }
        return new GlobalCardinality(this.variables.copy(), new String(this.valuesArrayName), string);
    }

    @Override
    public boolean isQuantified() {
        int n;
        if (this.variables.isQuantified()) {
            return true;
        }
        if (this.values != null && this.values.isQuantified()) {
            return true;
        }
        if (this.capacities != null && this.capacities.isQuantified()) {
            return true;
        }
        for (n = 0; n < this.capacitiesList.size(); ++n) {
            if (!this.capacitiesList.get(n).isQuantified()) continue;
            return true;
        }
        for (n = 0; n < this.valuesList.size(); ++n) {
            if (!this.valuesList.get(n).isQuantified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        int n;
        int n2;
        int n3;
        ArrayList<Expression> arrayList = this.variables.getQuantifyingVariables();
        if (this.values == null) {
            for (n3 = 0; n3 < this.valuesList.size(); ++n3) {
                ArrayList<Expression> arrayList2 = this.valuesList.get(n3).getQuantifyingVariables();
                n2 = arrayList2.size();
                for (n = 0; n < n2; ++n) {
                    arrayList.add(arrayList2.remove(0));
                }
            }
        } else {
            ArrayList<Expression> arrayList3 = this.values.getQuantifyingVariables();
            int n4 = arrayList3.size();
            for (n2 = 0; n2 < n4; ++n2) {
                arrayList.add(arrayList3.remove(0));
            }
        }
        if (this.capacities == null) {
            for (n3 = 0; n3 < this.capacitiesList.size(); ++n3) {
                ArrayList<Expression> arrayList4 = this.capacitiesList.get(n3).getQuantifyingVariables();
                n2 = arrayList4.size();
                for (n = 0; n < n2; ++n) {
                    arrayList.add(arrayList4.remove(0));
                }
            }
        } else {
            ArrayList<Expression> arrayList5 = this.capacities.getQuantifyingVariables();
            int n5 = arrayList5.size();
            for (n2 = 0; n2 < n5; ++n2) {
                arrayList.add(arrayList5.remove(0));
            }
        }
        return arrayList;
    }

    @Override
    public Expression evaluate() {
        int n;
        this.variables = this.variables.evaluate();
        for (n = 0; n < this.capacitiesList.size(); ++n) {
            this.capacitiesList.add(this.capacitiesList.remove(n).evaluate());
        }
        for (n = 0; n < this.valuesList.size(); ++n) {
            this.valuesList.add(this.valuesList.remove(n).evaluate());
        }
        if (this.capacities != null) {
            this.capacities = this.capacities.evaluate();
        }
        if (this.values != null) {
            this.values = this.values.evaluate();
        }
        return this;
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public int getType() {
        return 226;
    }

    @Override
    public int getCategory() {
        return 3;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        int n;
        for (n = 0; n < this.capacitiesList.size(); ++n) {
            this.capacitiesList.add(this.capacitiesList.remove(n).insertDomainForVariable(domain, string));
        }
        for (n = 0; n < this.valuesList.size(); ++n) {
            this.valuesList.add(this.valuesList.remove(n).insertDomainForVariable(domain, string));
        }
        this.variables = this.variables.insertDomainForVariable(domain, string);
        if (this.capacities != null) {
            this.capacities = this.capacities.insertDomainForVariable(domain, string);
        }
        if (this.values != null) {
            this.values = this.values.insertDomainForVariable(domain, string);
        }
        if (this.capacitiesArrayName != null && this.capacitiesArrayName.equals(string)) {
            this.capacities = this.createNewVariable(string, domain);
        } else if (this.valuesArrayName != null && this.valuesArrayName.equals(string)) {
            this.values = this.createNewVariable(string, domain);
        }
        return this;
    }

    private Expression createNewVariable(String string, Domain domain) {
        if (domain instanceof BoolDomain) {
            return new RelationalAtomExpression(new SingleVariable(string, domain));
        }
        if (domain instanceof ArrayDomain) {
            ArrayDomain arrayDomain = (ArrayDomain)domain;
            Domain[] domainArray = arrayDomain.getIndexDomains();
            BasicDomain[] basicDomainArray = new BasicDomain[arrayDomain.getIndexDomains().length];
            for (int i = 0; i < basicDomainArray.length; ++i) {
                try {
                    if (!(domainArray[i] instanceof BasicDomain)) {
                        throw new Exception("Infeasible array domain: " + domain + ". Cannot use domain '" + domainArray[i] + "' as an index domain. Expected a range or identifier.");
                    }
                    basicDomainArray[i] = (BasicDomain)domainArray[i];
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                    System.exit(1);
                }
            }
            return new SimpleArray(string, basicDomainArray, arrayDomain.getBaseDomain());
        }
        if (domain instanceof ConstantArrayDomain) {
            ConstantArrayDomain constantArrayDomain = (ConstantArrayDomain)domain;
            ConstantDomain[] constantDomainArray = constantArrayDomain.getIndexDomains();
            BasicDomain[] basicDomainArray = new BasicDomain[constantArrayDomain.getIndexDomains().length];
            for (int i = 0; i < basicDomainArray.length; ++i) {
                try {
                    if (!(constantDomainArray[i] instanceof BasicDomain)) {
                        throw new Exception("Infeasible array domain: " + domain + ". Cannot use domain '" + constantDomainArray[i] + "' as an index domain. Expected a range or identifier.");
                    }
                    basicDomainArray[i] = constantDomainArray[i];
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                    System.exit(1);
                }
            }
            return new SimpleArray(string, basicDomainArray, constantArrayDomain.getBaseDomain());
        }
        return new ArithmeticAtomExpression(new SingleVariable(string, domain));
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        int n2;
        for (n2 = 0; n2 < this.capacitiesList.size(); ++n2) {
            this.capacitiesList.add(this.capacitiesList.remove(n2).insertValueForVariable(n, string));
        }
        for (n2 = 0; n2 < this.valuesList.size(); ++n2) {
            this.valuesList.add(this.valuesList.remove(n2).insertValueForVariable(n, string));
        }
        this.variables = this.variables.insertValueForVariable(n, string);
        if (this.capacities != null) {
            this.capacities = this.capacities.insertValueForVariable(n, string);
        }
        if (this.values != null) {
            this.values = this.values.insertValueForVariable(n, string);
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        int n;
        for (n = 0; n < this.capacitiesList.size(); ++n) {
            this.capacitiesList.add(this.capacitiesList.remove(n).insertValueForVariable(bl, string));
        }
        for (n = 0; n < this.valuesList.size(); ++n) {
            this.valuesList.add(this.valuesList.remove(n).insertValueForVariable(bl, string));
        }
        this.variables = this.variables.insertValueForVariable(bl, string);
        if (this.capacities != null) {
            this.capacities = this.capacities.insertValueForVariable(bl, string);
        }
        if (this.values != null) {
            this.values = this.values.insertValueForVariable(bl, string);
        }
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeFlattenedToVariable;
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        return '\u0000';
    }

    @Override
    public void orderExpression() {
        this.variables.orderExpression();
    }

    @Override
    public Expression reduceExpressionTree() {
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        int n;
        this.variables = this.variables.replaceVariableWith(variable, variable2);
        for (n = 0; n < this.capacitiesList.size(); ++n) {
            this.capacitiesList.add(this.capacitiesList.remove(n).replaceVariableWith(variable, variable2));
        }
        for (n = 0; n < this.valuesList.size(); ++n) {
            this.valuesList.add(this.valuesList.remove(n).replaceVariableWith(variable, variable2));
        }
        if (this.capacities != null) {
            this.capacities = this.capacities.replaceVariableWith(variable, variable2);
        }
        if (this.values != null) {
            this.values = this.values.replaceVariableWith(variable, variable2);
        }
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        int n;
        for (n = 0; n < this.capacitiesList.size(); ++n) {
            this.capacitiesList.add(this.capacitiesList.remove(n).replaceVariableWithExpression(string, expression));
        }
        for (n = 0; n < this.valuesList.size(); ++n) {
            this.valuesList.add(this.valuesList.remove(n).replaceVariableWithExpression(string, expression));
        }
        this.variables = this.variables.replaceVariableWithExpression(string, expression);
        if (this.capacitiesArrayName != null && this.capacitiesArrayName.equals(string)) {
            this.capacities = expression;
            this.capacitiesArrayName = null;
        }
        if (this.valuesArrayName != null && this.valuesArrayName.equals(string)) {
            this.values = expression;
            this.valuesArrayName = null;
        }
        return this;
    }

    @Override
    public Expression restructure() {
        int n;
        this.variables = this.variables.restructure();
        for (n = 0; n < this.capacitiesList.size(); ++n) {
            this.capacitiesList.add(this.capacitiesList.remove(n).restructure());
        }
        for (n = 0; n < this.valuesList.size(); ++n) {
            this.valuesList.add(this.valuesList.remove(n).restructure());
        }
        if (this.capacities != null) {
            this.capacities = this.capacities.restructure();
        }
        if (this.values != null) {
            this.values = this.values.restructure();
        }
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeFlattenedToVariable = bl;
    }

    @Override
    public String toString() {
        CharSequence charSequence;
        boolean bl = this.capacities != null;
        boolean bl2 = this.values != null;
        boolean bl3 = this.capacitiesList.size() > 0;
        boolean bl4 = this.valuesList.size() > 0;
        String string = this.valuesArrayName;
        if (bl2) {
            string = ((Object)this.values).toString();
        } else if (bl4) {
            charSequence = new StringBuffer("[" + ((Object)this.valuesList.get(0)).toString());
            for (int i = 1; i < this.valuesList.size(); ++i) {
                ((StringBuffer)charSequence).append(", " + this.valuesList.get(i));
            }
            ((StringBuffer)charSequence).append("]");
            string = ((StringBuffer)charSequence).toString();
        }
        charSequence = this.capacitiesArrayName;
        if (bl) {
            charSequence = ((Object)this.capacities).toString();
        } else if (bl3) {
            StringBuffer stringBuffer = new StringBuffer("[" + ((Object)this.capacitiesList.get(0)).toString());
            for (int i = 1; i < this.capacitiesList.size(); ++i) {
                stringBuffer.append(", " + this.capacitiesList.get(i));
            }
            stringBuffer.append("]");
            charSequence = stringBuffer.toString();
        }
        return "gcc(" + this.variables + ", " + string + ", " + (String)charSequence + ")";
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        int n;
        this.variables.adaptIndicesForSolver(string, expressionArray);
        if (this.capacities != null) {
            this.capacities.adaptIndicesForSolver(string, expressionArray);
        }
        if (this.capacitiesList != null && this.capacitiesList.size() > 0) {
            for (n = 0; n < this.capacitiesList.size(); ++n) {
                this.capacitiesList.get(n).adaptIndicesForSolver(string, expressionArray);
            }
        }
        if (this.values != null) {
            this.values.adaptIndicesForSolver(string, expressionArray);
        }
        if (this.valuesList != null && this.valuesList.size() > 0) {
            for (n = 0; n < this.valuesList.size(); ++n) {
                this.valuesList.get(n).adaptIndicesForSolver(string, expressionArray);
            }
        }
    }

    public Expression getVariables() {
        return this.variables;
    }

    public Expression getValues() {
        return this.values;
    }

    public Expression getCapacities() {
        return this.capacities;
    }

    public void setVariables(Expression expression) {
        this.variables = expression;
    }

    public void setCapacities(Expression expression) {
        this.capacities = expression;
    }

    public void setValues(Expression expression) {
        this.values = expression;
    }
}

