/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.Domain;
import translator.expression.Variable;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Expression {
    public static final boolean DEBUG = true;
    public static final String VARIABLE_ARRAY_NAME = "variableArray";
    public static final int UPPER_BOUND = 100000;
    public static final int LOWER_BOUND = -100000;
    public static final int UPPER_BOUND_MAX = 1073741000;
    public static final int LOWER_BOUND_MAX = -1073741000;
    public static final char CONSTANT = '\u0000';
    public static final char PARAMETER = '\u0001';
    public static final char QUANTIFIED = '\u0002';
    public static final char DECISION = '\u0003';
    public static final int FALSE = -1;
    public static final int BOOL = 0;
    public static final int BOOL_VAR = 5;
    public static final int BOOL_ARRAY_VAR = 6;
    public static final int INT = 3;
    public static final int INT_VAR = 21;
    public static final int INT_ARRAY_VAR = 22;
    public static final int CONSTANT_VECTOR = 24;
    public static final int CONSTANT_MATRIX = 25;
    public static final int SIMPLE_ARRAY = 26;
    public static final int INDEXED_ARRAY = 27;
    public static final int COMPOSED_ARRAY = 28;
    public static final int VARIABLE_ARRAY = 29;
    public static final int SINGLE_VARIABLE = 11;
    public static final int SIMPLE_VARIABLE = 12;
    public static final int ARRAY_VARIABLE = 14;
    public static final int SIMPLE_ARRAY_VARIABLE = 15;
    public static final int NEGATION = 41;
    public static final int ALLDIFFERENT = 220;
    public static final int U_MINUS = 40;
    public static final int ABS = 42;
    public static final int LESS = 102;
    public static final int LEQ = 104;
    public static final int GREATER = 106;
    public static final int GEQ = 108;
    public static final int LEX_LESS = 103;
    public static final int LEX_LEQ = 105;
    public static final int LEX_GREATER = 107;
    public static final int LEX_GEQ = 109;
    public static final int IF = 116;
    public static final int EQ = 101;
    public static final int NEQ = 100;
    public static final int IFF = 115;
    public static final int OR = 117;
    public static final int AND = 118;
    public static final int XOR = 119;
    public static final int PLUS = 110;
    public static final int MINUS = 111;
    public static final int MIN = 120;
    public static final int MAX = 121;
    public static final int MIN_BIN = 123;
    public static final int MAX_BIN = 124;
    public static final int DIV = 112;
    public static final int MULT = 113;
    public static final int POWER = 114;
    public static final int MOD = 122;
    public static final int SUM = 200;
    public static final int Q_SUM = 201;
    public static final int FORALL = 202;
    public static final int EXISTS = 203;
    public static final int TABLE_CONSTRAINT = 221;
    public static final int ELEMENT_CONSTRAINT = 222;
    public static final int ATMOST_CONSTRAINT = 223;
    public static final int ATLEAST_CONSTRAINT = 224;
    public static final int OCCURRENCE = 225;
    public static final int GLOBAL_CARDINALITY = 226;
    public static final int REIFICATION = 250;
    public static final int REIFY_IMPLY = 777;
    public static final int NARY_SUMEQ_CONSTRAINT = 251;
    public static final int NARY_SUMLEQ_CONSTRAINT = 254;
    public static final int NARY_SUMGEQ_CONSTRAINT = 257;
    public static final int NARY_SUMNEQ_CONSTRAINT = 252;
    public static final int NARY_SUMLESS_CONSTRAINT = 253;
    public static final int NARY_SUMGREATER_CONSTRAINT = 255;
    public static final int NARY_PRODUCT_CONSTRAINT = 290;
    public static final int NARY_DISJUNCTION = 291;
    public static final int NARY_CONJUNCTION = 292;
    public static final int BINARY_SUMEQ_CONSTRAINT = 270;
    public static final int BINARY_SUMNEQ_CONSTRAINT = 271;
    public static final int BINARY_SUMLESS_CONSTRAINT = 272;
    public static final int BINARY_SUMLEQ_CONSTRAINT = 273;
    public static final int BINARY_SUMGREATER_CONSTRAINT = 274;
    public static final int BINARY_SUMGEQ_CONSTRAINT = 275;
    public static final int BINARY_PRODUCT_CONSTRAINT = 280;
    public static final int ABSOLUTE_CONSTRAINT = 281;
    public static final int MIN_CONSTRAINT = 282;
    public static final int MAX_CONSTRAINT = 283;
    public static final int ARRAY_INDEXING = 300;
    public static final int OBJECTIVE = 500;
    public static final char SMALLER = 's';
    public static final char BIGGER = 'g';
    public static final char EQUAL = 'e';

    public void orderExpression();

    public int getType();

    public int getCategory();

    public Expression copy();

    public String toString();

    public int[] getDomain();

    public Expression[] getDefinedDomain();

    public char isSmallerThanSameType(Expression var1);

    public Expression evaluate();

    public Expression reduceExpressionTree();

    public Expression insertValueForVariable(int var1, String var2);

    public Expression insertValueForVariable(boolean var1, String var2);

    public Expression insertDomainForVariable(Domain var1, String var2) throws Exception;

    public boolean isNested();

    public void setIsNotNested();

    public boolean isQuantified();

    public ArrayList<Expression> getQuantifyingVariables();

    public boolean isGonnaBeFlattenedToVariable();

    public void willBeFlattenedToVariable(boolean var1);

    public Expression restructure();

    public Expression replaceVariableWith(Variable var1, Variable var2);

    public Expression replaceVariableWithExpression(String var1, Expression var2) throws Exception;

    public boolean isLinearExpression();

    public String toSolverExpression(TargetSolver var1) throws Exception;

    public void adaptIndicesForSolver(String var1, Expression[] var2);
}

