/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.GlobalConstraint;
import translator.expression.Sum;
import translator.expression.Variable;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementConstraint
implements GlobalConstraint {
    private Expression variableArray;
    private Expression index;
    private Expression value;
    private boolean willBeReified = false;
    private boolean isNested = true;
    private boolean isIndexAdaptedToSolver = false;

    public ElementConstraint(Expression expression, Expression expression2, Expression expression3) {
        this.variableArray = expression;
        this.index = expression2;
        this.value = expression3;
    }

    public ElementConstraint(Expression expression, Expression expression2) {
        this.variableArray = expression;
        this.index = expression2;
    }

    @Override
    public boolean isQuantified() {
        if (this.variableArray.isQuantified()) {
            return true;
        }
        if (this.index.isQuantified()) {
            return true;
        }
        return this.value.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        ArrayList<Expression> arrayList = this.variableArray.getQuantifyingVariables();
        ArrayList<Expression> arrayList2 = this.index.getQuantifyingVariables();
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(arrayList2.remove(0));
        }
        ArrayList<Expression> arrayList3 = this.value.getQuantifyingVariables();
        n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(arrayList3.remove(0));
        }
        return arrayList;
    }

    @Override
    public Expression[] getArguments() {
        return new Expression[]{this.variableArray, this.index, this.value};
    }

    @Override
    public Expression copy() {
        return new ElementConstraint(this.variableArray.copy(), this.index.copy(), this.value.copy());
    }

    @Override
    public Expression evaluate() {
        this.variableArray = this.variableArray.evaluate();
        this.value = this.value.evaluate();
        this.index = this.index.evaluate();
        return this;
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public int getType() {
        return 222;
    }

    @Override
    public int getCategory() {
        return 3;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        this.variableArray = this.variableArray.insertValueForVariable(n, string);
        this.index = this.index.insertValueForVariable(n, string);
        this.value = this.value.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        this.variableArray = this.variableArray.insertValueForVariable(bl, string);
        this.index = this.index.insertValueForVariable(bl, string);
        this.value = this.value.insertValueForVariable(bl, string);
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        this.variableArray = this.variableArray.replaceVariableWithExpression(string, expression);
        this.index = this.index.replaceVariableWithExpression(string, expression);
        this.value = this.value.replaceVariableWithExpression(string, expression);
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        ElementConstraint elementConstraint = (ElementConstraint)expression;
        if (this.variableArray.getType() == elementConstraint.variableArray.getType()) {
            char c = this.variableArray.isSmallerThanSameType(elementConstraint.variableArray);
            if (c == 'e') {
                if (this.index.getType() == elementConstraint.index.getType()) {
                    c = this.index.isSmallerThanSameType(elementConstraint.index);
                    if (c == 'e') {
                        if (this.value.getType() == elementConstraint.value.getType()) {
                            return this.value.isSmallerThanSameType(elementConstraint.value);
                        }
                        return this.value.getType() < elementConstraint.value.getType() ? (char)'s' : 'g';
                    }
                    return c;
                }
                return this.index.getType() < elementConstraint.index.getType() ? (char)'s' : 'g';
            }
            return c;
        }
        return this.variableArray.getType() < elementConstraint.variableArray.getType() ? (char)'s' : 'g';
    }

    @Override
    public void orderExpression() {
        this.variableArray.orderExpression();
        this.index.orderExpression();
        this.value.orderExpression();
    }

    @Override
    public Expression reduceExpressionTree() {
        this.variableArray = this.variableArray.reduceExpressionTree();
        this.index = this.index.reduceExpressionTree();
        this.value = this.value.reduceExpressionTree();
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public String toString() {
        String string = "element(" + this.variableArray + ", " + this.index + ", " + this.value + ")";
        return string;
    }

    @Override
    public Expression restructure() {
        this.index = this.index.restructure();
        this.variableArray = this.variableArray.restructure();
        this.value = this.value.restructure();
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        this.index = this.index.insertDomainForVariable(domain, string);
        this.value = this.value.insertDomainForVariable(domain, string);
        this.variableArray = this.variableArray.insertDomainForVariable(domain, string);
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        this.index = this.index.replaceVariableWith(variable, variable2);
        this.value = this.value.replaceVariableWith(variable, variable2);
        this.variableArray = this.variableArray.replaceVariableWith(variable, variable2);
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        this.variableArray.adaptIndicesForSolver(string, expressionArray);
        this.index.adaptIndicesForSolver(string, expressionArray);
        if (((Object)this.variableArray).toString().equals(string) && !this.isIndexAdaptedToSolver) {
            this.index = new Sum(new Expression[]{this.index.copy()}, new Expression[]{expressionArray[0]});
            this.isIndexAdaptedToSolver = true;
        }
        this.value.adaptIndicesForSolver(string, expressionArray);
    }

    public void setResultExpression(Expression expression) {
        this.value = expression;
    }

    public Expression getValueExpression() {
        return this.value;
    }

    public Expression getIndexExpression() {
        return this.index;
    }

    public Expression getArray() {
        return this.variableArray;
    }
}

