/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.AtomExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.NaryRelationalExpression;
import translator.expression.RelationalAtomExpression;
import translator.expression.Variable;
import translator.solver.Gecode;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Disjunction
extends NaryRelationalExpression {
    private ArrayList<Expression> disjointExpressions;
    private boolean isNested = true;
    private boolean isNestedInDisjunction = false;

    public Disjunction(ArrayList<Expression> arrayList) {
        this.disjointExpressions = arrayList;
    }

    public Disjunction(Expression[] expressionArray) {
        this.disjointExpressions = new ArrayList();
        for (int i = 0; i < expressionArray.length; ++i) {
            this.disjointExpressions.add(expressionArray[i]);
        }
    }

    @Override
    public boolean isQuantified() {
        for (int i = 0; i < this.disjointExpressions.size(); ++i) {
            if (!this.disjointExpressions.get(i).isQuantified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        if (this.disjointExpressions.size() == 0) {
            return new ArrayList<Expression>();
        }
        ArrayList<Expression> arrayList = this.disjointExpressions.get(0).getQuantifyingVariables();
        for (int i = 1; i < this.disjointExpressions.size(); ++i) {
            ArrayList<Expression> arrayList2 = this.disjointExpressions.get(i).getQuantifyingVariables();
            int n = arrayList2.size();
            for (int j = 0; j < n; ++j) {
                arrayList.add(arrayList2.remove(0));
            }
        }
        return arrayList;
    }

    @Override
    public ArrayList<Expression> getArguments() {
        return this.disjointExpressions;
    }

    @Override
    public Expression copy() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        for (int i = 0; i < this.disjointExpressions.size(); ++i) {
            arrayList.add(i, this.disjointExpressions.get(i).copy());
        }
        return new Disjunction(arrayList);
    }

    @Override
    public int getType() {
        return 117;
    }

    @Override
    public int getCategory() {
        int n = 0;
        for (int i = 0; i < this.disjointExpressions.size(); ++i) {
            if (n >= this.disjointExpressions.get(i).getCategory()) continue;
            n = this.disjointExpressions.get(i).getCategory();
        }
        return n;
    }

    @Override
    public void orderExpression() {
        this.disjointExpressions = this.orderExpressionList(this.disjointExpressions);
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public String toString() {
        if (this.disjointExpressions.size() == 0) {
            return "false";
        }
        if (this.disjointExpressions.size() == 1) {
            return ((Object)this.disjointExpressions.get(0)).toString();
        }
        StringBuffer stringBuffer = new StringBuffer("( (" + ((Object)this.disjointExpressions.get(0)).toString() + ")");
        for (int i = 1; i < this.disjointExpressions.size(); ++i) {
            stringBuffer.append(" \\/ (" + ((Object)this.disjointExpressions.get(i)).toString() + ")");
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        Disjunction disjunction = (Disjunction)expression;
        if (this.disjointExpressions.size() == disjunction.getArguments().size()) {
            for (int i = 0; i < this.disjointExpressions.size(); ++i) {
                Expression expression2 = this.disjointExpressions.get(i);
                Expression expression3 = disjunction.disjointExpressions.get(i);
                if (expression2.getType() == expression3.getType()) {
                    char c = expression2.isSmallerThanSameType(expression3);
                    if (c == 'e') continue;
                    return c;
                }
                return expression2.getType() < expression3.getType() ? (char)'s' : 'g';
            }
            return 'e';
        }
        return this.disjointExpressions.size() < disjunction.getArguments().size() ? (char)'s' : 'g';
    }

    @Override
    public Expression evaluate() {
        int n;
        int n2;
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        for (n2 = 0; n2 < this.disjointExpressions.size(); ++n2) {
            this.disjointExpressions.add(n2, this.disjointExpressions.remove(n2).evaluate());
        }
        for (n2 = this.disjointExpressions.size() - 1; n2 >= 0; --n2) {
            if (this.disjointExpressions.get(n2).getType() == 0) {
                arrayList.add(((RelationalAtomExpression)this.disjointExpressions.remove(n2)).getBool());
                continue;
            }
            if (this.disjointExpressions.get(n2).getType() != 3) continue;
            n = ((ArithmeticAtomExpression)this.disjointExpressions.remove(n2)).getConstant();
            if (n == 0) {
                arrayList.add(new Boolean(false));
                continue;
            }
            if (n == 1) {
                arrayList.add(new Boolean(true));
                continue;
            }
            this.disjointExpressions.add(n2, new ArithmeticAtomExpression(n));
        }
        n2 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            n2 = (Boolean)arrayList.get(n) != false || n2 != 0 ? 1 : 0;
        }
        if (n2 == 1) {
            return new RelationalAtomExpression(true);
        }
        if (this.disjointExpressions.size() == 0) {
            return new RelationalAtomExpression(n2 != 0);
        }
        return this;
    }

    @Override
    public Expression reduceExpressionTree() {
        for (int i = this.disjointExpressions.size() - 1; i >= 0; --i) {
            this.disjointExpressions.add(i, this.disjointExpressions.remove(i).reduceExpressionTree());
            if (this.disjointExpressions.get(i).getType() != 117) continue;
            Disjunction disjunction = (Disjunction)this.disjointExpressions.remove(i);
            for (int j = disjunction.disjointExpressions.size() - 1; j >= 0; --j) {
                this.disjointExpressions.add(disjunction.disjointExpressions.remove(j));
            }
        }
        if (this.disjointExpressions.size() == 1) {
            return this.disjointExpressions.remove(0);
        }
        return this;
    }

    @Override
    protected void print_debug(String string) {
        System.out.println("[ DEBUG disjunction ] " + string);
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        for (int i = 0; i < this.disjointExpressions.size(); ++i) {
            this.disjointExpressions.add(i, this.disjointExpressions.remove(i).insertValueForVariable(n, string));
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        for (int i = 0; i < this.disjointExpressions.size(); ++i) {
            this.disjointExpressions.add(i, this.disjointExpressions.remove(i).insertValueForVariable(bl, string));
        }
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        for (int i = 0; i < this.disjointExpressions.size(); ++i) {
            this.disjointExpressions.add(i, this.disjointExpressions.remove(i).replaceVariableWithExpression(string, expression));
        }
        return this;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public Expression restructure() {
        for (int i = 0; i < this.disjointExpressions.size(); ++i) {
            this.disjointExpressions.add(i, this.disjointExpressions.remove(i).restructure());
        }
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        for (int i = 0; i < this.disjointExpressions.size(); ++i) {
            this.disjointExpressions.add(i, this.disjointExpressions.remove(i).insertDomainForVariable(domain, string));
        }
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        for (int i = 0; i < this.disjointExpressions.size(); ++i) {
            this.disjointExpressions.add(i, this.disjointExpressions.remove(i).replaceVariableWith(variable, variable2));
        }
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        if (targetSolver instanceof Gecode) {
            StringBuffer stringBuffer = new StringBuffer("");
            for (int i = 0; i < this.disjointExpressions.size(); ++i) {
                Expression expression = this.disjointExpressions.get(i);
                if (expression instanceof AtomExpression) {
                    stringBuffer.append(expression.toSolverExpression(targetSolver));
                } else {
                    stringBuffer.append("(" + expression.toSolverExpression(targetSolver) + ")");
                }
                if (i >= this.disjointExpressions.size() - 1) continue;
                stringBuffer.append(" || ");
            }
            return stringBuffer.toString();
        }
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    public boolean isNestedInDisjunction() {
        return this.isNestedInDisjunction;
    }

    public void setIsNestedInDisjunction(boolean bl) {
        this.isNestedInDisjunction = bl;
    }

    public void setArguments(ArrayList<Expression> arrayList) {
        this.disjointExpressions = arrayList;
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        for (int i = 0; i < this.disjointExpressions.size(); ++i) {
            this.disjointExpressions.get(i).adaptIndicesForSolver(string, expressionArray);
        }
    }
}

