/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.ArrayDomain;
import translator.expression.ConstantArray;
import translator.expression.ConstantArrayDomain;
import translator.expression.ConstantDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.Variable;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantVector
implements ConstantArray {
    private String arrayName;
    private int[] elements;
    private Domain domain;
    private boolean willBeFlattenedToVariable = false;
    private boolean isNested = true;

    public ConstantVector(String string, int[] nArray) {
        this.arrayName = string;
        this.elements = nArray;
    }

    public ConstantVector(String string, Integer[] integerArray) {
        this.arrayName = string;
        this.elements = new int[integerArray.length];
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = integerArray[i];
        }
    }

    public ConstantVector(String string, Integer[] integerArray, Domain domain) {
        this.arrayName = string;
        this.elements = new int[integerArray.length];
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = integerArray[i];
        }
        this.domain = domain;
    }

    @Override
    public boolean isQuantified() {
        return false;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        return null;
    }

    public void setQuantifiedRange(ExpressionRange expressionRange) {
    }

    @Override
    public String getArrayName() {
        return this.arrayName;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public Expression copy() {
        int[] nArray = new int[this.elements.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.elements[i];
        }
        return new ConstantVector(new String(this.arrayName), nArray);
    }

    @Override
    public Expression evaluate() {
        return this;
    }

    @Override
    public int[] getDomain() {
        return new int[]{-100000, 100000};
    }

    @Override
    public Expression[] getDefinedDomain() {
        if (this.domain instanceof ConstantDomain) {
            return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(((ConstantDomain)this.domain).getRange()[0]), new ArithmeticAtomExpression(((ConstantDomain)this.domain).getRange()[1])};
        }
        if (this.domain instanceof ExpressionRange) {
            return ((ExpressionRange)this.domain).getLowerAndUpperBound();
        }
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(-100000), new ArithmeticAtomExpression(100000)};
    }

    @Override
    public int getType() {
        return 24;
    }

    @Override
    public int getCategory() {
        return 0;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeFlattenedToVariable;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        ConstantVector constantVector = (ConstantVector)expression;
        if (this.elements.length == constantVector.elements.length) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (this.elements[i] == constantVector.elements[i]) continue;
                return this.elements[i] == constantVector.elements[i] ? (char)'s' : 'g';
            }
            return 'e';
        }
        return this.elements.length < constantVector.elements.length ? (char)'s' : 'g';
    }

    @Override
    public void orderExpression() {
    }

    @Override
    public Expression reduceExpressionTree() {
        return this;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeFlattenedToVariable = bl;
    }

    @Override
    public String toString() {
        String string = this.arrayName + " be [";
        for (int i = 0; i < this.elements.length; ++i) {
            if (i > 0) {
                string = string.concat(",");
            }
            string = string.concat(this.elements[i] + "");
        }
        return string + "]";
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        if (this.domain != null) {
            this.domain = this.domain.replaceVariableWithDomain(string, domain);
        }
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    public int[] getElements() {
        return this.elements;
    }

    public int getElementAt(int n) throws Exception {
        if (n < this.elements.length && n >= 0) {
            return this.elements[n];
        }
        throw new Exception("Index '" + n + "' for constant array '" + this + "' is out of bounds.");
    }

    @Override
    public Domain getArrayDomain() {
        return this.domain;
    }

    @Override
    public void setArrayDomain(ArrayDomain arrayDomain) {
        this.domain = arrayDomain;
    }

    @Override
    public int[] getIndexOffsets() {
        if (this.domain != null) {
            this.domain = this.domain.evaluate();
            if (this.domain instanceof ConstantArrayDomain) {
                ConstantArrayDomain constantArrayDomain = (ConstantArrayDomain)this.domain;
                int[] nArray = new int[constantArrayDomain.getIndexDomains().length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = constantArrayDomain.getIndexDomains()[i].getRange()[0];
                }
                return nArray;
            }
        }
        return new int[0];
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
    }
}

