/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.ArrayDomain;
import translator.expression.ConstantArray;
import translator.expression.ConstantArrayDomain;
import translator.expression.ConstantDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.Variable;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantMatrix
implements ConstantArray {
    private String arrayName;
    private int[][] elements;
    private Domain domain;
    private boolean willBeFlattenedToVariable = false;
    private boolean isNested = true;

    public ConstantMatrix(String string, int[][] nArray) {
        this.arrayName = string;
        this.elements = nArray;
    }

    public ConstantMatrix(String string, Integer[][] integerArray) {
        this.arrayName = string;
        this.elements = new int[integerArray.length][integerArray[0].length];
        for (int i = 0; i < integerArray.length; ++i) {
            for (int j = 0; j < integerArray[0].length; ++j) {
                this.elements[i][j] = integerArray[i][j];
            }
        }
    }

    public ConstantMatrix(String string, Integer[][] integerArray, Domain domain) {
        this.arrayName = string;
        this.elements = new int[integerArray.length][integerArray[0].length];
        for (int i = 0; i < integerArray.length; ++i) {
            for (int j = 0; j < integerArray[0].length; ++j) {
                this.elements[i][j] = integerArray[i][j];
            }
        }
        this.domain = domain;
    }

    @Override
    public boolean isQuantified() {
        return false;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        return null;
    }

    public void setQuantifiedRange(ExpressionRange expressionRange) {
    }

    @Override
    public String getArrayName() {
        return this.arrayName;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Expression copy() {
        int[][] nArray = new int[this.elements.length][this.elements[0].length];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                nArray[i][j] = this.elements[i][j];
            }
        }
        return new ConstantMatrix(new String(this.arrayName), nArray);
    }

    @Override
    public Expression evaluate() {
        return this;
    }

    @Override
    public int[] getDomain() {
        return new int[]{-100000, 100000};
    }

    @Override
    public Expression[] getDefinedDomain() {
        if (this.domain instanceof ConstantDomain) {
            return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(((ConstantDomain)this.domain).getRange()[0]), new ArithmeticAtomExpression(((ConstantDomain)this.domain).getRange()[1])};
        }
        if (this.domain instanceof ExpressionRange) {
            return ((ExpressionRange)this.domain).getLowerAndUpperBound();
        }
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(-100000), new ArithmeticAtomExpression(100000)};
    }

    @Override
    public int getType() {
        return 25;
    }

    @Override
    public int getCategory() {
        return 0;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeFlattenedToVariable;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        ConstantMatrix constantMatrix = (ConstantMatrix)expression;
        if (this.elements.length == constantMatrix.elements.length) {
            if (this.elements[0].length == constantMatrix.elements[0].length) {
                for (int i = 0; i < this.elements.length; ++i) {
                    for (int j = 0; j < this.elements[0].length; ++j) {
                        if (this.elements[i][j] == constantMatrix.elements[i][j]) continue;
                        return this.elements[i][j] < constantMatrix.elements[i][j] ? (char)'s' : 'g';
                    }
                }
                return 'e';
            }
            return this.elements[0].length < constantMatrix.elements[0].length ? (char)'s' : 'g';
        }
        return this.elements.length < constantMatrix.elements.length ? (char)'s' : 'g';
    }

    @Override
    public void orderExpression() {
    }

    @Override
    public Expression reduceExpressionTree() {
        return this;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeFlattenedToVariable = bl;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        return this;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.arrayName + " be [\n");
        for (int i = 0; i < this.elements.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",\n[");
            } else {
                stringBuffer.append("[");
            }
            for (int j = 0; j < this.elements[i].length; ++j) {
                if (j > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.elements[i][j] + "");
            }
            stringBuffer.append("]");
        }
        return stringBuffer + "]";
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    public int[][] getElements() {
        return this.elements;
    }

    public int getElementAt(int n, int n2) throws Exception {
        if (n < this.elements.length && n >= 0) {
            if (n2 < this.elements[0].length && n2 >= 0) {
                return this.elements[n][n2];
            }
            int[] nArray = this.getIndexOffsets();
            if (nArray.length == 0) {
                throw new Exception("The column-Index '" + n2 + "' for constant array '" + this.arrayName + "' is out of bounds.\n" + "Feasible bounds are: rows: 0.." + (this.elements.length - 1) + ", cols: 0.." + (this.elements[0].length - 1));
            }
            throw new Exception("The column-Index '" + (n2 + nArray[1]) + "' for constant array '" + this.arrayName + "' is out of bounds.\n" + "Feasible bounds are: rows: " + nArray[0] + ".." + (this.elements.length - 1 + nArray[0]) + ", cols: " + nArray[1] + ".." + (this.elements[0].length - 1 + nArray[1]));
        }
        int[] nArray = this.getIndexOffsets();
        if (nArray.length == 0) {
            throw new Exception("The row-Index '" + n + "' for constant array '" + this.arrayName + "' is out of bounds.\n" + "Feasible bounds are: rows: 0.." + (this.elements.length - 1) + ", cols: 0.." + (this.elements[0].length - 1));
        }
        throw new Exception("The row-Index '" + (n + nArray[0]) + "' for constant array '" + this.arrayName + "' is out of bounds.\n" + "Feasible bounds are: rows: " + nArray[0] + ".." + (this.elements.length - 1 + nArray[0]) + ", cols: " + nArray[1] + ".." + (this.elements[0].length - 1 + nArray[1]));
    }

    @Override
    public Domain getArrayDomain() {
        return this.domain;
    }

    @Override
    public void setArrayDomain(ArrayDomain arrayDomain) {
        this.domain = arrayDomain;
    }

    @Override
    public int[] getIndexOffsets() {
        if (this.domain != null) {
            this.domain = this.domain.evaluate();
            if (this.domain instanceof ConstantArrayDomain) {
                ConstantArrayDomain constantArrayDomain = (ConstantArrayDomain)this.domain;
                int[] nArray = new int[constantArrayDomain.getIndexDomains().length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = constantArrayDomain.getIndexDomains()[i].getRange()[0];
                }
                return nArray;
            }
        }
        return new int[0];
    }

    public void setArrayName(String string) {
        this.arrayName = string;
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
    }
}

