/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import translator.expression.BasicDomain;
import translator.expression.ConstantDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.MatrixDomain;

public class ConstantArrayDomain
implements ConstantDomain,
MatrixDomain {
    ConstantDomain baseDomain;
    ConstantDomain[] indexDomains;

    public ConstantArrayDomain(ConstantDomain[] constantDomainArray, ConstantDomain constantDomain) {
        this.indexDomains = constantDomainArray;
        this.baseDomain = constantDomain;
    }

    public int[] getFullDomain() {
        return this.baseDomain.getFullDomain();
    }

    public int[] getRange() {
        return this.baseDomain.getRange();
    }

    public Domain copy() {
        ConstantDomain[] constantDomainArray = new ConstantDomain[this.indexDomains.length];
        for (int i = 0; i < this.indexDomains.length; ++i) {
            constantDomainArray[i] = (ConstantDomain)this.indexDomains[i].copy();
        }
        return new ConstantArrayDomain(constantDomainArray, (ConstantDomain)this.baseDomain.copy());
    }

    public Domain evaluate() {
        return this;
    }

    public int getType() {
        return 10;
    }

    public int getCategory() {
        return 0;
    }

    public Domain insertValueForVariable(int n, String string) {
        return this;
    }

    public Domain insertValueForVariable(boolean bl, String string) {
        return this;
    }

    public boolean isConstantDomain() {
        return true;
    }

    public Domain replaceVariableWithDomain(String string, Domain domain) {
        return this;
    }

    public Domain replaceVariableWithExpression(String string, Expression expression) {
        return this;
    }

    public char isSmallerThanSameType(BasicDomain basicDomain) {
        return 'e';
    }

    public ConstantDomain getBaseDomain() {
        return this.baseDomain;
    }

    public ConstantDomain[] getIndexDomains() {
        return this.indexDomains;
    }

    public String toString() {
        String string = "matrix indexed by [";
        for (int i = 0; i < this.indexDomains.length; ++i) {
            if (i > 0) {
                string = string.concat(",");
            }
            string = string.concat(this.indexDomains[i].toString());
        }
        string = string + "] of " + this.baseDomain.toString();
        return string;
    }

    public int getOffsetFromZeroAt(int n) throws Exception {
        if (n >= this.indexDomains.length || n < 0) {
            throw new Exception("Index '" + n + "' out of bounds:" + this);
        }
        return this.indexDomains[n].getRange()[0];
    }

    public void setIndexDomains(ConstantDomain[] constantDomainArray) {
        if (this.indexDomains.length == constantDomainArray.length) {
            this.indexDomains = constantDomainArray;
        }
    }
}

