/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.AtomExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.NaryRelationalExpression;
import translator.expression.RelationalAtomExpression;
import translator.expression.Variable;
import translator.solver.Gecode;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conjunction
extends NaryRelationalExpression {
    private ArrayList<Expression> conjointExpressions;
    private boolean isNested = true;
    private boolean willBeReified = false;
    private boolean isNestedInConjunction = false;

    public Conjunction(ArrayList<Expression> arrayList) {
        this.conjointExpressions = arrayList;
    }

    public Conjunction(Expression[] expressionArray) {
        this.conjointExpressions = new ArrayList();
        for (int i = 0; i < expressionArray.length; ++i) {
            this.conjointExpressions.add(expressionArray[i]);
        }
    }

    @Override
    public boolean isQuantified() {
        for (int i = 0; i < this.conjointExpressions.size(); ++i) {
            if (!this.conjointExpressions.get(i).isQuantified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        ArrayList<Expression> arrayList = this.conjointExpressions.get(0).getQuantifyingVariables();
        int n = this.conjointExpressions.size();
        for (int i = 1; i < n; ++i) {
            ArrayList<Expression> arrayList2 = this.conjointExpressions.get(i).getQuantifyingVariables();
            int n2 = arrayList2.size();
            for (int j = 0; j < n2; ++j) {
                arrayList.add(arrayList2.remove(0));
            }
        }
        return arrayList;
    }

    @Override
    public ArrayList<Expression> getArguments() {
        return this.conjointExpressions;
    }

    @Override
    public Expression copy() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        for (int i = 0; i < this.conjointExpressions.size(); ++i) {
            arrayList.add(i, this.conjointExpressions.get(i).copy());
        }
        return new Conjunction(arrayList);
    }

    @Override
    public int getType() {
        return 118;
    }

    @Override
    public int getCategory() {
        int n = 0;
        for (int i = 0; i < this.conjointExpressions.size(); ++i) {
            if (n >= this.conjointExpressions.get(i).getCategory()) continue;
            n = this.conjointExpressions.get(i).getCategory();
        }
        return n;
    }

    @Override
    public void orderExpression() {
        this.conjointExpressions = this.orderExpressionList(this.conjointExpressions);
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public String toString() {
        if (this.conjointExpressions.size() == 0) {
            return "true";
        }
        if (this.conjointExpressions.size() == 1) {
            return ((Object)this.conjointExpressions.get(0)).toString();
        }
        StringBuffer stringBuffer = new StringBuffer("(" + ((Object)this.conjointExpressions.get(0)).toString() + ")");
        if (this.getCategory() <= 2) {
            for (int i = 1; i < this.conjointExpressions.size(); ++i) {
                stringBuffer.append(" ");
                stringBuffer.append("/\\ (" + ((Object)this.conjointExpressions.get(i)).toString() + ")");
            }
        } else {
            for (int i = 1; i < this.conjointExpressions.size(); ++i) {
                if (!(this.conjointExpressions.get(i) instanceof AtomExpression)) {
                    stringBuffer.append("\n\t");
                } else {
                    stringBuffer.append(" ");
                }
                stringBuffer.append("/\\ (" + ((Object)this.conjointExpressions.get(i)).toString() + ")");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        Conjunction conjunction = (Conjunction)expression;
        if (this.conjointExpressions.size() == conjunction.getArguments().size()) {
            for (int i = 0; i < this.conjointExpressions.size(); ++i) {
                Expression expression2 = this.conjointExpressions.get(i);
                Expression expression3 = conjunction.conjointExpressions.get(i);
                if (expression2.getType() == expression3.getType()) {
                    char c = expression2.isSmallerThanSameType(expression3);
                    if (c == 'e') continue;
                    return c;
                }
                return expression2.getType() < expression3.getType() ? (char)'s' : 'g';
            }
            return 'e';
        }
        return this.conjointExpressions.size() < conjunction.getArguments().size() ? (char)'s' : 'g';
    }

    @Override
    public Expression evaluate() {
        int n;
        int n2;
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        for (n2 = 0; n2 < this.conjointExpressions.size(); ++n2) {
            this.conjointExpressions.add(n2, this.conjointExpressions.remove(n2).evaluate());
        }
        for (n2 = this.conjointExpressions.size() - 1; n2 >= 0; --n2) {
            if (this.conjointExpressions.get(n2).getType() == 0) {
                arrayList.add(((RelationalAtomExpression)this.conjointExpressions.remove(n2)).getBool());
                continue;
            }
            if (this.conjointExpressions.get(n2).getType() != 3) continue;
            n = ((ArithmeticAtomExpression)this.conjointExpressions.remove(n2)).getConstant();
            if (n == 0) {
                arrayList.add(new Boolean(false));
                continue;
            }
            if (n == 1) {
                arrayList.add(new Boolean(true));
                continue;
            }
            this.conjointExpressions.add(n2, new ArithmeticAtomExpression(n));
        }
        n2 = 1;
        for (n = 0; n < arrayList.size(); ++n) {
            n2 = (Boolean)arrayList.get(n) != false && n2 != 0 ? 1 : 0;
        }
        if (n2 == 0) {
            return new RelationalAtomExpression(false);
        }
        if (this.conjointExpressions.size() == 0) {
            return new RelationalAtomExpression(n2 != 0);
        }
        return this;
    }

    @Override
    public Expression reduceExpressionTree() {
        for (int i = this.conjointExpressions.size() - 1; i >= 0; --i) {
            this.conjointExpressions.add(i, this.conjointExpressions.remove(i).reduceExpressionTree());
            if (this.conjointExpressions.get(i).getType() != 118) continue;
            Conjunction conjunction = (Conjunction)this.conjointExpressions.remove(i);
            boolean bl = conjunction.isGonnaBeFlattenedToVariable();
            for (int j = conjunction.conjointExpressions.size() - 1; j >= 0; --j) {
                Expression expression = conjunction.conjointExpressions.remove(j);
                expression.willBeFlattenedToVariable(bl);
                this.conjointExpressions.add(expression);
            }
        }
        if (this.conjointExpressions.size() == 1) {
            Expression expression = this.conjointExpressions.remove(0);
            if (!this.isNested) {
                expression.setIsNotNested();
            }
            return expression;
        }
        return this;
    }

    @Override
    protected void print_debug(String string) {
        System.out.println("[ DEBUG conjunction ] " + string);
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        for (int i = 0; i < this.conjointExpressions.size(); ++i) {
            this.conjointExpressions.add(i, this.conjointExpressions.remove(i).insertValueForVariable(n, string));
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        for (int i = 0; i < this.conjointExpressions.size(); ++i) {
            this.conjointExpressions.add(i, this.conjointExpressions.remove(i).insertValueForVariable(bl, string));
        }
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        for (int i = 0; i < this.conjointExpressions.size(); ++i) {
            this.conjointExpressions.add(i, this.conjointExpressions.remove(i).replaceVariableWithExpression(string, expression));
        }
        return this;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public Expression restructure() {
        for (int i = 0; i < this.conjointExpressions.size(); ++i) {
            this.conjointExpressions.add(i, this.conjointExpressions.remove(i).restructure());
        }
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        for (int i = 0; i < this.conjointExpressions.size(); ++i) {
            this.conjointExpressions.add(i, this.conjointExpressions.remove(i).insertDomainForVariable(domain, string));
        }
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        for (int i = 0; i < this.conjointExpressions.size(); ++i) {
            this.conjointExpressions.add(i, this.conjointExpressions.remove(i).replaceVariableWith(variable, variable2));
        }
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        if (targetSolver instanceof Gecode) {
            StringBuffer stringBuffer = new StringBuffer("");
            for (int i = 0; i < this.conjointExpressions.size(); ++i) {
                Expression expression = this.conjointExpressions.get(i);
                if (expression instanceof AtomExpression) {
                    stringBuffer.append(expression.toSolverExpression(targetSolver));
                } else {
                    stringBuffer.append("(" + expression.toSolverExpression(targetSolver) + ")");
                }
                if (i >= this.conjointExpressions.size() - 1) continue;
                stringBuffer.append(" && ");
            }
            return stringBuffer.toString();
        }
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    public boolean isNestedInConjunction() {
        return this.isNestedInConjunction;
    }

    public void setIsNestedInConjunction(boolean bl) {
        this.isNestedInConjunction = bl;
    }

    public void setArguments(ArrayList<Expression> arrayList) {
        this.conjointExpressions = arrayList;
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        for (int i = 0; i < this.conjointExpressions.size(); ++i) {
            this.conjointExpressions.get(i).adaptIndicesForSolver(string, expressionArray);
        }
    }
}

