/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.Array;
import translator.expression.ConstantDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.SingleArray;
import translator.expression.Variable;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComposedArray
implements Array {
    private Domain baseDomain;
    private SingleArray[] arrayList;
    private boolean willBeFlattenedToVariable = false;
    private boolean isNested = true;

    public ComposedArray(Domain domain, SingleArray[] singleArrayArray) {
        this.baseDomain = domain;
        this.arrayList = singleArrayArray;
    }

    @Override
    public boolean isQuantified() {
        for (int i = 0; i < this.arrayList.length; ++i) {
            if (!this.arrayList[i].isQuantified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        for (int i = 0; i < this.arrayList.length; ++i) {
            ArrayList<Expression> arrayList2 = this.arrayList[i].getQuantifyingVariables();
            int n = arrayList2.size();
            for (int j = 0; j < n; ++j) {
                arrayList.add(arrayList2.remove(0));
            }
        }
        return arrayList;
    }

    @Override
    public Domain getBaseDomain() {
        return this.baseDomain;
    }

    @Override
    public Expression copy() {
        SingleArray[] singleArrayArray = new SingleArray[this.arrayList.length];
        for (int i = 0; i < this.arrayList.length; ++i) {
            singleArrayArray[i] = (SingleArray)this.arrayList[i].copy();
        }
        return new ComposedArray(this.baseDomain.copy(), singleArrayArray);
    }

    @Override
    public Expression evaluate() {
        for (int i = 0; i < this.arrayList.length; ++i) {
            this.arrayList[i] = (SingleArray)this.arrayList[i].evaluate();
        }
        return this;
    }

    @Override
    public int[] getDomain() {
        if (this.baseDomain instanceof ConstantDomain) {
            return ((ConstantDomain)this.baseDomain).getRange();
        }
        return new int[]{-100000, 100000};
    }

    @Override
    public Expression[] getDefinedDomain() {
        if (this.baseDomain instanceof ConstantDomain) {
            return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(((ConstantDomain)this.baseDomain).getRange()[0]), new ArithmeticAtomExpression(((ConstantDomain)this.baseDomain).getRange()[1])};
        }
        if (this.baseDomain instanceof ExpressionRange) {
            return ((ExpressionRange)this.baseDomain).getLowerAndUpperBound();
        }
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(-100000), new ArithmeticAtomExpression(100000)};
    }

    @Override
    public int getType() {
        return 28;
    }

    @Override
    public int getCategory() {
        int n = 0;
        for (int i = 0; i < this.arrayList.length; ++i) {
            if (n >= this.arrayList[i].getCategory()) continue;
            n = this.arrayList[i].getCategory();
        }
        return n;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        for (int i = 0; i < this.arrayList.length; ++i) {
            this.arrayList[i] = (SingleArray)this.arrayList[i].insertValueForVariable(n, string);
        }
        this.baseDomain = this.baseDomain.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        for (int i = 0; i < this.arrayList.length; ++i) {
            this.arrayList[i] = (SingleArray)this.arrayList[i].insertValueForVariable(bl, string);
        }
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        for (int i = 0; i < this.arrayList.length; ++i) {
            try {
                Expression expression2 = this.arrayList[i].replaceVariableWithExpression(string, expression);
                if (!(expression2 instanceof SingleArray)) {
                    throw new Exception("Replacing variable '" + string + "' with infeasible expression '" + expression + "' that changes index to become " + expression2 + ". Expected a single array type.");
                }
                this.arrayList[i] = (SingleArray)expression2;
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                System.exit(1);
            }
        }
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeFlattenedToVariable;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        ComposedArray composedArray = (ComposedArray)expression;
        if (this.arrayList.length == composedArray.arrayList.length) {
            for (int i = 0; i < this.arrayList.length; ++i) {
                if (this.arrayList[i].getType() == composedArray.arrayList[i].getType()) {
                    char c = this.arrayList[i].isSmallerThanSameType(composedArray.arrayList[i]);
                    if (c == 'e') continue;
                    return c;
                }
                return this.arrayList[i].getType() < composedArray.arrayList[i].getType() ? (char)'s' : 'g';
            }
            return 'e';
        }
        return this.arrayList.length < composedArray.arrayList.length ? (char)'s' : 'g';
    }

    @Override
    public void orderExpression() {
    }

    @Override
    public Expression reduceExpressionTree() {
        return this;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeFlattenedToVariable = bl;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        if (this.arrayList != null) {
            for (int i = 0; i < this.arrayList.length; ++i) {
                this.arrayList[i].adaptIndicesForSolver(string, expressionArray);
            }
        }
    }
}

