/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.AtomExpression;
import translator.expression.BinaryRelationalExpression;
import translator.expression.Conjunction;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.Negation;
import translator.expression.QuantifiedSum;
import translator.expression.RelationalAtomExpression;
import translator.expression.Sum;
import translator.expression.UnaryMinus;
import translator.expression.Variable;
import translator.solver.Gecode;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommutativeBinaryRelationalExpression
implements BinaryRelationalExpression {
    private Expression leftArgument;
    private Expression rightArgument;
    private int type;
    private boolean isNested = true;
    private boolean willBeReified = false;

    public CommutativeBinaryRelationalExpression(Expression expression, int n, Expression expression2) {
        this.leftArgument = expression;
        this.rightArgument = expression2;
        this.type = n;
    }

    @Override
    public void setRightExpression(Expression expression) {
        this.rightArgument = expression;
    }

    @Override
    public void setLeftExpression(Expression expression) {
        this.leftArgument = expression;
    }

    @Override
    public boolean isQuantified() {
        return this.leftArgument.isQuantified() || this.rightArgument.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        ArrayList<Expression> arrayList = this.rightArgument.getQuantifyingVariables();
        ArrayList<Expression> arrayList2 = this.leftArgument.getQuantifyingVariables();
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(arrayList2.remove(0));
        }
        return arrayList;
    }

    @Override
    public Expression getLeftArgument() {
        return this.leftArgument;
    }

    @Override
    public int getOperator() {
        return this.type;
    }

    @Override
    public Expression getRightArgument() {
        return this.rightArgument;
    }

    @Override
    public Expression copy() {
        return new CommutativeBinaryRelationalExpression(this.leftArgument.copy(), this.type, this.rightArgument.copy());
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getCategory() {
        return Math.max(this.leftArgument.getCategory(), this.rightArgument.getCategory());
    }

    @Override
    public void orderExpression() {
        char c;
        this.leftArgument.orderExpression();
        this.rightArgument.orderExpression();
        if (this.leftArgument.getType() > this.rightArgument.getType()) {
            Expression expression = this.leftArgument;
            this.leftArgument = this.rightArgument;
            this.rightArgument = expression;
        } else if (this.leftArgument.getType() == this.rightArgument.getType() && (c = this.leftArgument.isSmallerThanSameType(this.rightArgument)) == 'g') {
            Expression expression = this.leftArgument;
            this.leftArgument = this.rightArgument;
            this.rightArgument = expression;
        }
    }

    @Override
    public String toString() {
        String string = "";
        switch (this.type) {
            case 115: {
                string = "<=>";
                break;
            }
            case 101: {
                string = "=";
                break;
            }
            case 100: {
                string = "!=";
                break;
            }
            case 118: {
                string = "/\\";
                break;
            }
            case 117: {
                string = "\\/";
            }
        }
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.leftArgument instanceof AtomExpression) {
            stringBuffer.append(this.leftArgument);
        } else {
            stringBuffer.append("(" + this.leftArgument + ")");
        }
        stringBuffer.append(string);
        if (this.rightArgument instanceof AtomExpression) {
            stringBuffer.append(this.rightArgument);
        } else {
            stringBuffer.append("(" + this.rightArgument + ")");
        }
        return stringBuffer.toString();
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        CommutativeBinaryRelationalExpression commutativeBinaryRelationalExpression = (CommutativeBinaryRelationalExpression)expression;
        if (this.leftArgument.getType() == commutativeBinaryRelationalExpression.leftArgument.getType()) {
            char c = this.leftArgument.isSmallerThanSameType(commutativeBinaryRelationalExpression.leftArgument);
            if (c == 'e') {
                if (this.rightArgument.getType() == commutativeBinaryRelationalExpression.rightArgument.getType()) {
                    return this.rightArgument.isSmallerThanSameType(commutativeBinaryRelationalExpression.rightArgument);
                }
                return this.rightArgument.getType() < commutativeBinaryRelationalExpression.rightArgument.getType() ? (char)'s' : 'g';
            }
            return c;
        }
        return this.leftArgument.getType() < commutativeBinaryRelationalExpression.leftArgument.getType() ? (char)'s' : 'g';
    }

    @Override
    public Expression evaluate() {
        this.leftArgument = this.leftArgument.evaluate();
        this.rightArgument = this.rightArgument.evaluate();
        if (this.type == 115) {
            if (this.leftArgument.getType() == 0 && this.rightArgument.getType() == 0) {
                boolean bl = ((RelationalAtomExpression)this.leftArgument).getBool();
                boolean bl2 = ((RelationalAtomExpression)this.leftArgument).getBool();
                return new RelationalAtomExpression(bl || bl2);
            }
        } else if (this.type == 118) {
            if (this.leftArgument.getType() == 0) {
                boolean bl = ((RelationalAtomExpression)this.leftArgument).getBool();
                return bl ? this.rightArgument : new RelationalAtomExpression(false);
            }
            if (this.rightArgument.getType() == 0) {
                boolean bl = ((RelationalAtomExpression)this.rightArgument).getBool();
                return bl ? this.leftArgument : new RelationalAtomExpression(false);
            }
        } else if (this.type == 117) {
            if (this.leftArgument.getType() == 0) {
                boolean bl = ((RelationalAtomExpression)this.leftArgument).getBool();
                return bl ? new RelationalAtomExpression(true) : this.rightArgument;
            }
            if (this.rightArgument.getType() == 0) {
                boolean bl = ((RelationalAtomExpression)this.rightArgument).getBool();
                return bl ? new RelationalAtomExpression(true) : this.leftArgument;
            }
        }
        int n = -11111;
        int n2 = -11111;
        if (this.leftArgument.getType() == 0) {
            n = ((RelationalAtomExpression)this.leftArgument).toArithmeticExpression().getConstant();
        }
        if (this.rightArgument.getType() == 0) {
            n2 = ((RelationalAtomExpression)this.rightArgument).toArithmeticExpression().getConstant();
        }
        if (this.leftArgument.getType() == 3) {
            n = ((ArithmeticAtomExpression)this.leftArgument).getConstant();
        }
        if (this.rightArgument.getType() == 3) {
            n2 = ((ArithmeticAtomExpression)this.rightArgument).getConstant();
        }
        if (n != -11111 && n2 != -11111) {
            switch (this.type) {
                case 101: {
                    return new RelationalAtomExpression(n == n2);
                }
                case 100: {
                    return new RelationalAtomExpression(n != n2);
                }
                case 115: {
                    return new RelationalAtomExpression(n == 1 && n2 == 1);
                }
                case 118: {
                    return new RelationalAtomExpression(n == 1 && n2 == 1);
                }
                case 117: {
                    return new RelationalAtomExpression(n == 1 || n2 == 1);
                }
            }
        } else if (n != -11111) {
            if (this.type == 101) {
                if (this.rightArgument.getDomain()[0] > n || n > this.rightArgument.getDomain()[1]) {
                    return new RelationalAtomExpression(false);
                }
            } else if (this.type == 100 && (this.rightArgument.getDomain()[0] > n || n > this.rightArgument.getDomain()[1])) {
                return new RelationalAtomExpression(true);
            }
        }
        return this;
    }

    @Override
    public Expression reduceExpressionTree() {
        this.leftArgument = this.leftArgument.reduceExpressionTree();
        this.rightArgument = this.rightArgument.reduceExpressionTree();
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        this.leftArgument = this.leftArgument.insertValueForVariable(n, string);
        this.rightArgument = this.rightArgument.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        this.leftArgument = this.leftArgument.insertValueForVariable(bl, string);
        this.rightArgument = this.rightArgument.insertValueForVariable(bl, string);
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        this.leftArgument = this.leftArgument.replaceVariableWithExpression(string, expression);
        this.rightArgument = this.rightArgument.replaceVariableWithExpression(string, expression);
        return this;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public Expression restructure() {
        if (this.type == 101) {
            if (this.rightArgument instanceof Sum) {
                ArrayList<Expression> arrayList;
                Sum sum = (Sum)this.rightArgument;
                if (this.leftArgument instanceof UnaryMinus) {
                    arrayList = sum.getPositiveArguments();
                    arrayList.add(((UnaryMinus)this.leftArgument).getArgument());
                    this.leftArgument = new ArithmeticAtomExpression(0);
                } else if (!(this.leftArgument instanceof ArithmeticAtomExpression) && !(this.leftArgument instanceof RelationalAtomExpression)) {
                    arrayList = sum.getNegativeArguments();
                    arrayList.add(this.leftArgument.copy());
                    this.leftArgument = new ArithmeticAtomExpression(0);
                    this.rightArgument = sum.reduceExpressionTree();
                }
                this.rightArgument = this.rightArgument.reduceExpressionTree();
                this.rightArgument = this.rightArgument.restructure();
                this.rightArgument.orderExpression();
                this.rightArgument = this.rightArgument.evaluate();
                if (this.rightArgument instanceof Sum && (arrayList = ((Sum)this.rightArgument).getNegativeArguments()).size() > 0 && arrayList.get(0).getType() == 3) {
                    this.leftArgument = new Sum(new Expression[]{this.leftArgument, arrayList.remove(0)}, new Expression[0]);
                    if (sum.getNegativeArguments().size() == 0 && sum.getPositiveArguments().size() == 1) {
                        Expression expression = this.leftArgument;
                        this.leftArgument = sum.getPositiveArguments().get(0);
                        this.rightArgument = expression;
                    }
                }
            } else if (this.leftArgument instanceof Sum) {
                ArrayList<Expression> arrayList;
                Sum sum = (Sum)this.leftArgument;
                if (this.rightArgument instanceof UnaryMinus) {
                    arrayList = sum.getPositiveArguments();
                    arrayList.add(((UnaryMinus)this.rightArgument).getArgument());
                    this.rightArgument = new ArithmeticAtomExpression(0);
                } else if (!(this.rightArgument instanceof ArithmeticAtomExpression || this.rightArgument instanceof RelationalAtomExpression || this.rightArgument instanceof QuantifiedSum)) {
                    arrayList = sum.getNegativeArguments();
                    arrayList.add(this.rightArgument.copy());
                    this.rightArgument = new ArithmeticAtomExpression(0);
                }
                this.leftArgument = this.leftArgument.reduceExpressionTree();
                this.leftArgument = this.leftArgument.restructure();
                this.leftArgument.orderExpression();
                this.leftArgument = this.leftArgument.evaluate();
                if (this.leftArgument instanceof Sum && (arrayList = ((Sum)this.leftArgument).getNegativeArguments()).size() > 0 && arrayList.get(0).getType() == 3) {
                    this.rightArgument = new Sum(new Expression[]{this.rightArgument, arrayList.remove(0)}, new Expression[0]);
                    this.rightArgument = this.rightArgument.reduceExpressionTree();
                    if (sum.getNegativeArguments().size() == 0 && sum.getPositiveArguments().size() == 1) {
                        this.leftArgument = sum.getPositiveArguments().get(0);
                    }
                }
            }
        }
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        this.leftArgument = this.leftArgument.insertDomainForVariable(domain, string);
        this.rightArgument = this.rightArgument.insertDomainForVariable(domain, string);
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        this.leftArgument = this.leftArgument.replaceVariableWith(variable, variable2);
        this.rightArgument = this.rightArgument.replaceVariableWith(variable, variable2);
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        boolean bl = this.leftArgument.isLinearExpression();
        bl = this.rightArgument.isLinearExpression() && bl;
        return bl;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        if (targetSolver instanceof Gecode && this.isLinearExpression()) {
            String string = "";
            switch (this.type) {
                case 101: {
                    string = " == ";
                    break;
                }
                case 100: {
                    string = " != ";
                    break;
                }
                default: {
                    throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
                }
            }
            StringBuffer stringBuffer = new StringBuffer("");
            if (this.leftArgument instanceof AtomExpression) {
                stringBuffer.append(this.leftArgument);
            } else {
                stringBuffer.append("(" + this.leftArgument + ")");
            }
            stringBuffer.append(string);
            if (this.rightArgument instanceof AtomExpression) {
                stringBuffer.append(this.rightArgument);
            } else {
                stringBuffer.append("(" + this.rightArgument + ")");
            }
            return stringBuffer.toString();
        }
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public Expression invertExpression() {
        switch (this.type) {
            case 115: {
                this.setType(100);
                return this;
            }
            case 101: {
                this.setType(100);
                return this;
            }
            case 100: {
                this.setType(101);
                return this;
            }
            case 118: {
                return new Negation(this);
            }
            case 117: {
                return new Conjunction(new Expression[]{new Negation(this.leftArgument), new Negation(this.rightArgument)});
            }
        }
        return new Negation(this);
    }

    private void setType(int n) {
        this.type = n;
    }

    @Override
    public boolean isEasyNegatable() {
        return this.type == 101 || this.type == 100;
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        this.leftArgument.adaptIndicesForSolver(string, expressionArray);
        this.rightArgument.adaptIndicesForSolver(string, expressionArray);
    }
}

