/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import translator.expression.ArithmeticAtomExpression;
import translator.expression.BasicDomain;
import translator.expression.BoundedExpressionRange;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.IntRange;
import translator.expression.SingleIntRange;

public class BoundedIntRange
implements IntRange {
    private int lowerBound;
    private int upperBound;

    public BoundedIntRange(int n, int n2) {
        this.lowerBound = n;
        this.upperBound = n2;
    }

    public int[] getFullDomain() {
        if (this.upperBound < this.lowerBound) {
            return new int[0];
        }
        int[] nArray = new int[this.upperBound - this.lowerBound + 1];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.lowerBound + i;
        }
        return nArray;
    }

    public int[] getRange() {
        return new int[]{this.lowerBound, this.upperBound};
    }

    public Domain copy() {
        return new BoundedIntRange(this.lowerBound, this.upperBound);
    }

    public Expression[] getLowerAndUpperBound() {
        return new Expression[]{new ArithmeticAtomExpression(this.lowerBound), new ArithmeticAtomExpression(this.upperBound)};
    }

    public Domain evaluate() {
        if (this.lowerBound == this.upperBound) {
            return new SingleIntRange(this.lowerBound);
        }
        return this;
    }

    public int getType() {
        return 2;
    }

    public int getCategory() {
        return 0;
    }

    public String toString() {
        return "int(" + this.lowerBound + ".." + this.upperBound + ")";
    }

    public boolean isConstantDomain() {
        return true;
    }

    public ExpressionRange toExpressionRange() {
        return new BoundedExpressionRange(new ArithmeticAtomExpression(this.lowerBound), new ArithmeticAtomExpression(this.upperBound));
    }

    public Domain insertValueForVariable(int n, String string) {
        return this;
    }

    public Domain insertValueForVariable(boolean bl, String string) {
        return this;
    }

    public Domain replaceVariableWithDomain(String string, Domain domain) {
        return this;
    }

    public Domain replaceVariableWithExpression(String string, Expression expression) {
        return this;
    }

    public char isSmallerThanSameType(BasicDomain basicDomain) {
        BoundedIntRange boundedIntRange = (BoundedIntRange)basicDomain;
        if (this.lowerBound == boundedIntRange.lowerBound) {
            if (this.upperBound == boundedIntRange.upperBound) {
                return 'e';
            }
            return this.upperBound < boundedIntRange.upperBound ? (char)'s' : 'g';
        }
        return this.lowerBound < boundedIntRange.lowerBound ? (char)'s' : 'g';
    }

    public void setLowerBound(int n) {
        this.lowerBound = n;
    }

    public void setUpperBound(int n) {
        this.upperBound = n;
    }
}

