/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import translator.expression.ArithmeticAtomExpression;
import translator.expression.BasicDomain;
import translator.expression.BoolDomain;
import translator.expression.BoundedIntRange;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.RelationalAtomExpression;
import translator.expression.SparseIntRange;

public class BoundedExpressionRange
implements ExpressionRange {
    private Expression lowerBound;
    private Expression upperBound;

    public BoundedExpressionRange(Expression expression, Expression expression2) {
        this.lowerBound = expression;
        this.upperBound = expression2;
    }

    public Domain copy() {
        return new BoundedExpressionRange(this.lowerBound.copy(), this.upperBound.copy());
    }

    public Expression[] getLowerAndUpperBound() {
        return new Expression[]{this.lowerBound, this.upperBound};
    }

    public Domain evaluate() {
        this.lowerBound = this.lowerBound.reduceExpressionTree().evaluate();
        this.upperBound = this.upperBound.reduceExpressionTree().evaluate();
        if (this.lowerBound.getType() == 3 && this.upperBound.getType() == 3) {
            return new BoundedIntRange(((ArithmeticAtomExpression)this.lowerBound).getConstant(), ((ArithmeticAtomExpression)this.upperBound).getConstant());
        }
        if (this.lowerBound.getType() == 0 && this.upperBound.getType() == 0) {
            boolean bl = ((RelationalAtomExpression)this.lowerBound).getBool();
            boolean bl2 = ((RelationalAtomExpression)this.lowerBound).getBool();
            if (!bl && bl2) {
                return new BoolDomain();
            }
            if (bl == bl2) {
                return bl ? new SparseIntRange(new int[]{1}) : new SparseIntRange(new int[]{0});
            }
        }
        return this;
    }

    public int getType() {
        return 6;
    }

    public int getCategory() {
        return this.lowerBound.getCategory() > this.upperBound.getCategory() ? this.lowerBound.getCategory() : this.upperBound.getCategory();
    }

    public String toString() {
        return "int(" + ((Object)this.lowerBound).toString() + ".." + ((Object)this.upperBound).toString() + ")";
    }

    public boolean isConstantDomain() {
        return false;
    }

    public Domain insertValueForVariable(int n, String string) {
        this.lowerBound = this.lowerBound.insertValueForVariable(n, string);
        this.upperBound = this.upperBound.insertValueForVariable(n, string);
        if (this.lowerBound.getType() == 3 && this.upperBound.getType() == 3) {
            return new BoundedIntRange(((ArithmeticAtomExpression)this.lowerBound).getConstant(), ((ArithmeticAtomExpression)this.upperBound).getConstant());
        }
        return this;
    }

    public Domain insertValueForVariable(boolean bl, String string) {
        this.lowerBound = this.lowerBound.insertValueForVariable(bl, string);
        this.upperBound = this.upperBound.insertValueForVariable(bl, string);
        if (this.lowerBound.getType() == 3 && this.upperBound.getType() == 3) {
            return new BoundedIntRange(((ArithmeticAtomExpression)this.lowerBound).getConstant(), ((ArithmeticAtomExpression)this.upperBound).getConstant());
        }
        return this;
    }

    public Domain replaceVariableWithDomain(String string, Domain domain) {
        return this;
    }

    public Domain replaceVariableWithExpression(String string, Expression expression) throws Exception {
        this.lowerBound = this.lowerBound.replaceVariableWithExpression(string, expression);
        this.upperBound = this.upperBound.replaceVariableWithExpression(string, expression);
        return this;
    }

    public char isSmallerThanSameType(BasicDomain basicDomain) {
        BoundedExpressionRange boundedExpressionRange = (BoundedExpressionRange)basicDomain;
        if (this.lowerBound.getType() == this.upperBound.getType()) {
            char c = this.lowerBound.isSmallerThanSameType(boundedExpressionRange.lowerBound);
            if (c == 'e') {
                if (this.upperBound.getType() == boundedExpressionRange.upperBound.getType()) {
                    return this.upperBound.isSmallerThanSameType(boundedExpressionRange.upperBound);
                }
                return this.upperBound.getType() < boundedExpressionRange.upperBound.getType() ? (char)'s' : 'g';
            }
            return c;
        }
        return this.lowerBound.getType() < this.upperBound.getType() ? (char)'s' : 'g';
    }

    public Expression getLowerBound() {
        return this.lowerBound;
    }

    public Expression getUpperBound() {
        return this.upperBound;
    }

    public void setLowerBound(Expression expression) {
        this.lowerBound = expression;
    }

    public void setUpperBound(Expression expression) {
        this.upperBound = expression;
    }
}

