/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.CommutativeBinaryRelationalExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.RelationalAtomExpression;
import translator.expression.RelationalExpression;
import translator.expression.Variable;
import translator.solver.Gecode;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryNonLinearConstraint
implements RelationalExpression {
    private int operator;
    private Expression leftArgument;
    private Expression rightArgument;
    private Expression result;
    private boolean willBeFlattenedToVariable = false;
    private boolean isNested = true;

    public BinaryNonLinearConstraint(Expression expression, int n, Expression expression2, Expression expression3) {
        this.leftArgument = expression;
        this.operator = n;
        this.rightArgument = expression2;
        this.result = expression3;
    }

    @Override
    public boolean isQuantified() {
        return this.leftArgument.isQuantified() || this.rightArgument.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        ArrayList<Expression> arrayList = this.rightArgument.getQuantifyingVariables();
        ArrayList<Expression> arrayList2 = this.leftArgument.getQuantifyingVariables();
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(arrayList2.remove(0));
        }
        return arrayList;
    }

    public Expression getLeftArgument() {
        return this.leftArgument;
    }

    public Expression getRightArgument() {
        return this.rightArgument;
    }

    public Expression getResult() {
        return this.result;
    }

    @Override
    public Expression copy() {
        int n = this.operator;
        return new BinaryNonLinearConstraint(this.leftArgument.copy(), n, this.rightArgument.copy(), this.result.copy());
    }

    @Override
    public Expression evaluate() {
        this.leftArgument = this.leftArgument.evaluate();
        this.rightArgument = this.rightArgument.evaluate();
        this.result = this.result.evaluate();
        if (this.leftArgument.getType() == 3 && this.rightArgument.getType() == 3) {
            int n;
            int n2 = ((ArithmeticAtomExpression)this.leftArgument).getConstant();
            int n3 = ((ArithmeticAtomExpression)this.rightArgument).getConstant();
            if (this.operator == 122) {
                n = n2 % n3;
            } else if (this.operator == 114) {
                n = 1;
                for (int i = 1; i <= n3; ++i) {
                    n *= n2;
                }
            } else if (this.operator == 112) {
                n = n2 / n3;
            } else {
                return this;
            }
            if (this.result.getType() == 3) {
                return new RelationalAtomExpression(n == ((ArithmeticAtomExpression)this.result).getConstant());
            }
            return new CommutativeBinaryRelationalExpression(new ArithmeticAtomExpression(n), 101, this.result);
        }
        return this;
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public int getType() {
        return this.operator;
    }

    @Override
    public int getCategory() {
        return Math.max(this.leftArgument.getCategory(), this.rightArgument.getCategory());
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        this.leftArgument = this.leftArgument.insertDomainForVariable(domain, string);
        this.rightArgument = this.rightArgument.insertDomainForVariable(domain, string);
        this.result = this.result.insertDomainForVariable(domain, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        this.leftArgument = this.leftArgument.insertValueForVariable(n, string);
        this.rightArgument = this.rightArgument.insertValueForVariable(n, string);
        this.result = this.result.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        this.leftArgument = this.leftArgument.insertValueForVariable(bl, string);
        this.rightArgument = this.rightArgument.insertValueForVariable(bl, string);
        this.result = this.result.insertValueForVariable(bl, string);
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeFlattenedToVariable;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        return 'e';
    }

    @Override
    public void orderExpression() {
        this.leftArgument.orderExpression();
        this.rightArgument.orderExpression();
        this.result.orderExpression();
    }

    @Override
    public Expression reduceExpressionTree() {
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        this.leftArgument = this.leftArgument.replaceVariableWith(variable, variable2);
        this.rightArgument = this.rightArgument.replaceVariableWith(variable, variable2);
        this.result = this.result.replaceVariableWith(variable, variable2);
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        this.leftArgument = this.leftArgument.replaceVariableWithExpression(string, expression);
        this.rightArgument = this.rightArgument.replaceVariableWithExpression(string, expression);
        this.result = this.result.replaceVariableWithExpression(string, expression);
        return this;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeFlattenedToVariable = bl;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(((Object)this.leftArgument).toString());
        if (this.operator == 114) {
            stringBuffer.append("**");
        } else if (this.operator == 122) {
            stringBuffer.append("%");
        } else if (this.operator == 112) {
            stringBuffer.append("/");
        }
        stringBuffer.append(this.rightArgument + " = " + this.result);
        return stringBuffer.toString();
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        if (targetSolver instanceof Gecode) {
            return this.toString();
        }
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        this.leftArgument.adaptIndicesForSolver(string, expressionArray);
        this.rightArgument.adaptIndicesForSolver(string, expressionArray);
    }
}

