/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.BinaryArithmeticExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.Variable;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryMinimum
implements BinaryArithmeticExpression {
    private Expression leftArgument;
    private Expression rightArgument;
    private boolean isMaximum;
    boolean willBeFlattened = false;
    boolean isNested = true;

    public BinaryMinimum(Expression expression, Expression expression2, boolean bl) {
        this.leftArgument = expression;
        this.rightArgument = expression2;
        this.isMaximum = bl;
    }

    @Override
    public boolean isQuantified() {
        return this.leftArgument.isQuantified() || this.rightArgument.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        ArrayList<Expression> arrayList = this.rightArgument.getQuantifyingVariables();
        ArrayList<Expression> arrayList2 = this.leftArgument.getQuantifyingVariables();
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(arrayList2.remove(0));
        }
        return arrayList;
    }

    @Override
    public Expression getLeftArgument() {
        return this.leftArgument;
    }

    @Override
    public Expression getRightArgument() {
        return this.rightArgument;
    }

    @Override
    public Expression copy() {
        boolean bl = this.isMaximum;
        return new BinaryMinimum(this.leftArgument.copy(), this.rightArgument.copy(), bl);
    }

    @Override
    public Expression evaluate() {
        this.leftArgument = this.leftArgument.evaluate();
        this.rightArgument = this.rightArgument.evaluate();
        if (this.leftArgument.getType() == 3 && this.rightArgument.getType() == 3) {
            int n = ((ArithmeticAtomExpression)this.leftArgument).getConstant();
            int n2 = ((ArithmeticAtomExpression)this.rightArgument).getConstant();
            if (this.isMaximum) {
                return n2 > n ? this.rightArgument : this.leftArgument;
            }
            return n2 < n ? this.rightArgument : this.leftArgument;
        }
        return this;
    }

    @Override
    public int[] getDomain() {
        int[] nArray = new int[2];
        int n = this.leftArgument.getDomain()[0];
        int n2 = this.rightArgument.getDomain()[0];
        nArray[0] = !this.isMaximum ? (n < n2 ? n : n2) : (n > n2 ? n : n2);
        int n3 = this.leftArgument.getDomain()[1];
        int n4 = this.rightArgument.getDomain()[1];
        nArray[1] = !this.isMaximum ? (n3 < n4 ? n3 : n4) : (n3 > n4 ? n3 : n4);
        return nArray;
    }

    @Override
    public Expression[] getDefinedDomain() {
        Expression[] expressionArray = this.leftArgument.getDefinedDomain();
        Expression expression = expressionArray[0];
        Expression expression2 = expressionArray[1];
        Expression[] expressionArray2 = this.rightArgument.getDefinedDomain();
        Expression expression3 = expressionArray2[0];
        Expression expression4 = expressionArray2[1];
        if (expression.getType() == 3 && expression2.getType() == 3 && expression3.getType() == 3 && expression4.getType() == 3) {
            int n = 0;
            int n2 = ((ArithmeticAtomExpression)expression).getConstant();
            int n3 = ((ArithmeticAtomExpression)expression3).getConstant();
            int n4 = !this.isMaximum ? (n2 < n3 ? n2 : n3) : (n2 > n3 ? n2 : n3);
            int n5 = ((ArithmeticAtomExpression)expression2).getConstant();
            int n6 = ((ArithmeticAtomExpression)expression4).getConstant();
            n = !this.isMaximum ? (n5 < n6 ? n5 : n6) : (n5 > n6 ? n5 : n6);
            return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(n4), new ArithmeticAtomExpression(n)};
        }
        return new Expression[]{new BinaryMinimum(expression, expression3, this.isMaximum).evaluate(), new BinaryMinimum(expression2, expression4, this.isMaximum).evaluate()};
    }

    @Override
    public int getType() {
        return this.isMaximum ? 124 : 123;
    }

    @Override
    public int getCategory() {
        return Math.max(this.leftArgument.getCategory(), this.rightArgument.getCategory());
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        this.leftArgument = this.leftArgument.insertDomainForVariable(domain, string);
        this.rightArgument = this.rightArgument.insertDomainForVariable(domain, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        this.leftArgument = this.leftArgument.insertValueForVariable(n, string);
        this.rightArgument = this.rightArgument.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        this.leftArgument = this.leftArgument.insertValueForVariable(bl, string);
        this.rightArgument = this.rightArgument.insertValueForVariable(bl, string);
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeFlattened;
    }

    @Override
    public boolean isLinearExpression() {
        return this.leftArgument.isLinearExpression() && this.rightArgument.isLinearExpression();
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        return '\u0000';
    }

    @Override
    public void orderExpression() {
        this.leftArgument.orderExpression();
        this.rightArgument.orderExpression();
    }

    @Override
    public Expression reduceExpressionTree() {
        this.leftArgument = this.leftArgument.reduceExpressionTree();
        this.rightArgument = this.rightArgument.reduceExpressionTree();
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        this.leftArgument = this.leftArgument.replaceVariableWith(variable, variable2);
        this.rightArgument = this.rightArgument.replaceVariableWith(variable, variable2);
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        this.leftArgument = this.leftArgument.replaceVariableWithExpression(string, expression);
        this.rightArgument = this.rightArgument.replaceVariableWithExpression(string, expression);
        return this;
    }

    @Override
    public Expression restructure() {
        this.leftArgument = this.leftArgument.restructure();
        this.rightArgument = this.rightArgument.restructure();
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("No solver expression for " + this + " yet.");
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeFlattened = bl;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.isMaximum) {
            stringBuffer.append("max(");
        } else {
            stringBuffer.append("min(");
        }
        stringBuffer.append(this.leftArgument + ", ");
        stringBuffer.append(this.rightArgument + ")");
        return stringBuffer.toString();
    }

    public boolean isMaximum() {
        return this.isMaximum;
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        this.leftArgument.adaptIndicesForSolver(string, expressionArray);
        this.rightArgument.adaptIndicesForSolver(string, expressionArray);
    }
}

