/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.Array;
import translator.expression.ConstantVector;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.GlobalConstraint;
import translator.expression.Variable;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Atmost
implements GlobalConstraint {
    private Array array;
    private Expression arrayExpression;
    private int[] occurrenceOfVariables;
    private int[] values;
    private boolean isAtmost;
    private ArrayList<Expression> occurrenceList = new ArrayList();
    private ArrayList<Expression> valuesList = new ArrayList();
    private String occurrencesVectorName;
    private String valuesVectorName;
    boolean willBeFlattenedToVariable = false;
    boolean isNested = true;

    public Atmost(Array array, int[] nArray, int[] nArray2, boolean bl) {
        this.array = array;
        this.occurrenceOfVariables = nArray;
        this.values = nArray2;
        this.isAtmost = bl;
    }

    public Atmost(Expression expression, int[] nArray, int[] nArray2, boolean bl) {
        this.arrayExpression = expression;
        this.occurrenceOfVariables = nArray;
        this.values = nArray2;
        this.isAtmost = bl;
    }

    public Atmost(Expression expression, String string, String string2, boolean bl) {
        this.arrayExpression = expression;
        this.occurrencesVectorName = string;
        this.valuesVectorName = string2;
        this.isAtmost = bl;
        this.occurrenceOfVariables = new int[0];
        this.values = new int[0];
    }

    public Atmost(Expression expression, int[] nArray, String string, boolean bl) {
        this.arrayExpression = expression;
        this.valuesVectorName = string;
        this.isAtmost = bl;
        this.occurrenceOfVariables = nArray;
        this.values = new int[0];
    }

    public Atmost(Expression expression, String string, int[] nArray, boolean bl) {
        this.arrayExpression = expression;
        this.occurrencesVectorName = string;
        this.isAtmost = bl;
        this.occurrenceOfVariables = new int[0];
        this.values = nArray;
    }

    public Atmost(Expression expression, ArrayList<Expression> arrayList, ArrayList<Expression> arrayList2, boolean bl) {
        this.arrayExpression = expression;
        this.occurrenceList = arrayList;
        this.valuesList = arrayList2;
        this.isAtmost = bl;
        this.occurrenceOfVariables = new int[0];
        this.values = new int[0];
    }

    public Atmost(Expression expression, ArrayList<Expression> arrayList, int[] nArray, boolean bl) {
        this.arrayExpression = expression;
        this.occurrenceList = arrayList;
        this.values = nArray;
        this.isAtmost = bl;
        this.occurrenceOfVariables = new int[0];
    }

    public Atmost(Expression expression, int[] nArray, ArrayList<Expression> arrayList, boolean bl) {
        this.arrayExpression = expression;
        this.occurrenceOfVariables = nArray;
        this.valuesList = arrayList;
        this.isAtmost = bl;
        this.values = new int[0];
    }

    @Override
    public boolean isQuantified() {
        int n;
        if (this.arrayExpression != null && this.arrayExpression.isQuantified()) {
            return true;
        }
        if (this.array.isQuantified()) {
            return true;
        }
        for (n = 0; n < this.occurrenceList.size(); ++n) {
            if (!this.occurrenceList.get(n).isQuantified()) continue;
            return true;
        }
        for (n = 0; n < this.valuesList.size(); ++n) {
            if (!this.valuesList.get(n).isQuantified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        int n;
        int n2;
        ArrayList<Expression> arrayList;
        int n3;
        ArrayList<Expression> arrayList2 = this.array != null ? this.array.getQuantifyingVariables() : this.arrayExpression.getQuantifyingVariables();
        if (this.values == null) {
            for (n3 = 0; n3 < this.valuesList.size(); ++n3) {
                arrayList = this.valuesList.get(n3).getQuantifyingVariables();
                n2 = arrayList.size();
                for (n = 0; n < n2; ++n) {
                    arrayList2.add(arrayList.remove(0));
                }
            }
        }
        if (this.occurrenceOfVariables == null) {
            for (n3 = 0; n3 < this.occurrenceList.size(); ++n3) {
                arrayList = this.occurrenceList.get(n3).getQuantifyingVariables();
                n2 = arrayList.size();
                for (n = 0; n < n2; ++n) {
                    arrayList2.add(arrayList.remove(0));
                }
            }
        }
        return arrayList2;
    }

    @Override
    public Expression[] getArguments() {
        int n;
        Expression[] expressionArray = new Expression[1 + this.occurrenceOfVariables.length + this.values.length];
        expressionArray[0] = this.array;
        for (n = 0; n < this.occurrenceOfVariables.length; ++n) {
            expressionArray[n + 1] = new ArithmeticAtomExpression(this.occurrenceOfVariables[n]);
        }
        for (n = 0; n < this.values.length; ++n) {
            expressionArray[1 + this.occurrenceOfVariables.length + n] = new ArithmeticAtomExpression(this.values[n]);
        }
        return expressionArray;
    }

    @Override
    public Expression copy() {
        int n;
        int[] nArray = null;
        ArrayList<Expression> arrayList = null;
        if (this.occurrenceOfVariables != null && this.occurrenceOfVariables.length > 0) {
            nArray = new int[this.occurrenceOfVariables.length];
            for (n = 0; n < this.occurrenceOfVariables.length; ++n) {
                nArray[n] = this.occurrenceOfVariables[n];
            }
        } else {
            arrayList = new ArrayList<Expression>();
            for (n = 0; n < this.occurrenceList.size(); ++n) {
                arrayList.add(this.occurrenceList.get(n).copy());
            }
        }
        int[] nArray2 = null;
        ArrayList<Expression> arrayList2 = null;
        if (this.values != null && this.values.length > 0) {
            nArray2 = new int[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                nArray2[i] = this.values[i];
            }
        } else {
            arrayList2 = new ArrayList<Expression>();
            for (int i = 0; i < this.valuesList.size(); ++i) {
                arrayList2.add(this.valuesList.get(i).copy());
            }
        }
        if (this.array != null && nArray != null && nArray2 != null) {
            return new Atmost((Array)this.array.copy(), nArray, nArray2, this.isAtmost);
        }
        if (nArray != null && nArray2 != null) {
            return new Atmost(this.arrayExpression.copy(), nArray, nArray2, this.isAtmost);
        }
        if (nArray == null && nArray2 == null) {
            return new Atmost(this.array == null ? this.arrayExpression.copy() : (Array)this.array.copy(), arrayList, arrayList2, this.isAtmost);
        }
        if (nArray == null && nArray2 != null) {
            return new Atmost(this.array == null ? this.arrayExpression.copy() : (Array)this.array.copy(), arrayList, nArray2, this.isAtmost);
        }
        if (nArray != null && nArray2 == null) {
            return new Atmost(this.array == null ? this.arrayExpression.copy() : (Array)this.array.copy(), nArray, arrayList2, this.isAtmost);
        }
        return new Atmost(this.arrayExpression.copy(), nArray, nArray2, this.isAtmost);
    }

    @Override
    public Expression evaluate() {
        Expression expression;
        int n;
        boolean bl;
        if (this.array != null) {
            this.array = (Array)this.array.evaluate();
        } else {
            this.arrayExpression = this.arrayExpression.evaluate();
            if (this.arrayExpression instanceof Array) {
                this.array = (Array)this.arrayExpression;
            }
        }
        if (this.occurrenceList.size() > 0) {
            bl = true;
            for (n = this.occurrenceList.size() - 1; n >= 0; --n) {
                expression = this.occurrenceList.remove(n);
                expression = expression.evaluate();
                this.occurrenceList.add(n, expression);
                if (expression.getType() == 3) continue;
                bl = false;
            }
            if (bl) {
                this.occurrenceOfVariables = new int[this.occurrenceList.size()];
                for (n = 0; n < this.occurrenceList.size(); ++n) {
                    this.occurrenceOfVariables[n] = ((ArithmeticAtomExpression)this.occurrenceList.get(n)).getConstant();
                }
            }
        }
        if (this.valuesList.size() > 0) {
            bl = true;
            for (n = this.valuesList.size() - 1; n >= 0; --n) {
                expression = this.valuesList.remove(n);
                expression = expression.evaluate();
                this.valuesList.add(n, expression);
                if (expression.getType() == 3) continue;
                bl = false;
            }
            if (bl) {
                this.values = new int[this.valuesList.size()];
                for (n = 0; n < this.valuesList.size(); ++n) {
                    this.values[n] = ((ArithmeticAtomExpression)this.valuesList.get(n)).getConstant();
                }
            }
        }
        return this;
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public int getType() {
        return this.isAtmost ? 223 : 224;
    }

    @Override
    public int getCategory() {
        return 3;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        if (this.array != null) {
            this.array = (Array)this.array.insertDomainForVariable(domain, string);
        } else {
            this.arrayExpression = this.arrayExpression.insertDomainForVariable(domain, string);
            if (this.arrayExpression instanceof Array) {
                this.array = this.array;
            }
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        Expression expression;
        int n2;
        if (this.array != null) {
            this.array = (Array)this.array.insertValueForVariable(n, string);
        } else {
            this.arrayExpression = this.arrayExpression.insertValueForVariable(n, string);
        }
        if (this.occurrenceList.size() > 0) {
            for (n2 = this.occurrenceList.size() - 1; n2 >= 0; --n2) {
                expression = this.occurrenceList.remove(n2);
                expression = expression.insertValueForVariable(n, string);
                this.occurrenceList.add(n2, expression);
            }
        }
        if (this.valuesList.size() > 0) {
            for (n2 = this.valuesList.size() - 1; n2 >= 0; --n2) {
                expression = this.valuesList.remove(n2);
                expression = expression.insertValueForVariable(n, string);
                this.valuesList.add(n2, expression);
            }
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        Expression expression;
        int n;
        if (this.array != null) {
            this.array = (Array)this.array.insertValueForVariable(bl, string);
        } else {
            this.arrayExpression = this.arrayExpression.insertValueForVariable(bl, string);
        }
        if (this.occurrenceList.size() > 0) {
            for (n = this.occurrenceList.size() - 1; n >= 0; --n) {
                expression = this.occurrenceList.get(n);
                expression = expression.insertValueForVariable(bl, string);
            }
        }
        if (this.valuesList.size() > 0) {
            for (n = this.valuesList.size() - 1; n >= 0; --n) {
                expression = this.valuesList.get(n);
                expression = expression.insertValueForVariable(bl, string);
            }
        }
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        if (this.array != null) {
            Expression expression2 = this.array.replaceVariableWithExpression(string, expression);
            try {
                if (!(expression2 instanceof Array)) {
                    throw new Exception("Replacing variable '" + string + "' with infeasible expression '" + expression + "' that modifies atmost-array into:" + expression2 + ". Expected array type.");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                System.exit(1);
            }
            this.array = (Array)expression2;
        } else {
            try {
                Expression expression3;
                int n;
                if (this.arrayExpression != null) {
                    this.arrayExpression = this.arrayExpression.replaceVariableWithExpression(string, expression);
                }
                if (this.occurrencesVectorName != null && this.occurrencesVectorName.equals(string) && expression instanceof ConstantVector) {
                    this.occurrenceOfVariables = ((ConstantVector)expression).getElements();
                }
                if (this.occurrencesVectorName != null && this.occurrencesVectorName.equals(string)) {
                    if (expression instanceof ConstantVector) {
                        this.occurrenceOfVariables = ((ConstantVector)expression).getElements();
                    } else {
                        throw new Exception("Cannot insert '" + expression + "' for '" + this.occurrencesVectorName + " in atleast/atmost constraint because of type mismatch. Expected a constant vector instead of " + expression.getClass());
                    }
                }
                if (this.valuesVectorName != null && this.valuesVectorName.equals(string)) {
                    if (expression instanceof ConstantVector) {
                        this.values = ((ConstantVector)expression).getElements();
                    } else {
                        throw new Exception("Cannot insert '" + expression + "' for '" + this.valuesVectorName + " in atleast/atmost constraint because of type mismatch. Expected a constant vector instead of " + expression.getClass());
                    }
                }
                if (this.occurrenceList.size() > 0) {
                    for (n = this.occurrenceList.size() - 1; n >= 0; --n) {
                        expression3 = this.occurrenceList.remove(n);
                        expression3 = expression3.replaceVariableWithExpression(string, expression);
                        this.occurrenceList.add(n, expression3);
                    }
                }
                if (this.valuesList.size() > 0) {
                    for (n = this.valuesList.size() - 1; n >= 0; --n) {
                        expression3 = this.valuesList.remove(n);
                        expression3 = expression3.replaceVariableWithExpression(string, expression);
                        this.valuesList.add(n, expression3);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                System.exit(1);
            }
        }
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeFlattenedToVariable;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        Atmost atmost = (Atmost)expression;
        if (this.getType() == atmost.getType()) {
            if (this.array.getType() == atmost.array.getType()) {
                char c = this.array.isSmallerThanSameType(atmost.array);
                if (c == 'e') {
                    if (this.occurrenceOfVariables.length == atmost.occurrenceOfVariables.length) {
                        int n;
                        for (n = 0; n < this.occurrenceOfVariables.length; ++n) {
                            if (this.occurrenceOfVariables[n] == atmost.occurrenceOfVariables[n]) continue;
                            return this.occurrenceOfVariables[n] < atmost.occurrenceOfVariables[n] ? (char)'s' : 'g';
                        }
                        for (n = 0; n < this.values.length; ++n) {
                            if (this.values[n] == atmost.values[n]) continue;
                            return this.values[n] < atmost.values[n] ? (char)'s' : 'g';
                        }
                        return 'e';
                    }
                    return this.occurrenceOfVariables.length < atmost.occurrenceOfVariables.length ? (char)'s' : 'g';
                }
                return c;
            }
            return this.array.getType() < atmost.array.getType() ? (char)'s' : 'g';
        }
        return this.getType() < atmost.getType() ? (char)'s' : 'g';
    }

    @Override
    public void orderExpression() {
    }

    @Override
    public Expression reduceExpressionTree() {
        return this;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeFlattenedToVariable = bl;
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer = this.isAtmost ? new StringBuffer("atmost(") : new StringBuffer("atleast(");
        if (this.array != null) {
            stringBuffer.append(this.array.toString() + ",[");
        } else {
            stringBuffer.append(this.arrayExpression + ", [");
        }
        for (n = 0; n < this.occurrenceOfVariables.length; ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.occurrenceOfVariables[n] + "");
        }
        if (this.occurrenceOfVariables.length == 0) {
            if (this.occurrenceList.size() > 0) {
                for (n = 0; n < this.occurrenceList.size() - 1; ++n) {
                    stringBuffer.append(this.occurrenceList.get(n) + ",");
                }
                stringBuffer.append(this.occurrenceList.get(this.occurrenceList.size() - 1));
            }
            if (this.occurrencesVectorName != null) {
                stringBuffer.append(this.occurrencesVectorName);
            }
        }
        stringBuffer.append("], [");
        for (n = 0; n < this.values.length; ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.values[n] + "");
        }
        if (this.values.length == 0) {
            if (this.valuesVectorName != null) {
                stringBuffer.append(this.valuesVectorName);
            } else if (this.valuesList.size() > 0) {
                for (n = 0; n < this.valuesList.size() - 1; ++n) {
                    stringBuffer.append(this.valuesList.get(n));
                }
                stringBuffer.append(this.valuesList.get(this.valuesList.size() - 1));
            }
        }
        return stringBuffer + "])";
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        return this;
    }

    public boolean isAtmost() {
        return this.isAtmost;
    }

    public int[] getOccurrences() {
        return this.occurrenceOfVariables;
    }

    public int[] getValues() {
        return this.values;
    }

    public Array getArray() {
        return this.array;
    }

    public ArrayList<Expression> getOccurrenceExpressions() {
        return this.occurrenceList;
    }

    public ArrayList<Expression> getValueExpressions() {
        return this.valuesList;
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    public void setOccurrences(int[] nArray) {
        this.occurrenceOfVariables = nArray;
        this.occurrenceList = new ArrayList();
    }

    public void setValues(int[] nArray) {
        this.values = nArray;
        this.valuesList = new ArrayList();
    }

    public void setArray(Array array) {
        this.array = array;
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        if (this.array != null) {
            this.array.adaptIndicesForSolver(string, expressionArray);
        }
        if (this.arrayExpression != null) {
            this.arrayExpression.adaptIndicesForSolver(string, expressionArray);
        }
    }
}

