/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.ArrayDomain;
import translator.expression.ConstantArrayDomain;
import translator.expression.ConstantDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.ExpressionRange;
import translator.expression.Sum;
import translator.expression.Variable;
import translator.solver.Gecode;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayVariable
implements Variable {
    private String arrayName;
    private int[] intIndices;
    private Expression[] exprIndices;
    private Domain domain;
    private boolean isSearchVariable;
    private boolean isNested = true;
    private boolean willBeReified = false;
    private boolean willBeFlattenedToPartwiseElementConstraint = false;
    private boolean isIndexAdaptedToSolver = false;

    public ArrayVariable(String string, int[] nArray, Domain domain) {
        this.arrayName = string;
        this.intIndices = nArray;
        this.domain = domain;
        this.isSearchVariable = true;
        this.isNested = true;
    }

    public ArrayVariable(String string, Expression[] expressionArray, Domain domain) {
        this.arrayName = string;
        this.exprIndices = expressionArray;
        this.domain = domain;
        this.isSearchVariable = true;
        this.isNested = true;
    }

    @Override
    public boolean isQuantified() {
        if (this.intIndices != null) {
            return false;
        }
        for (int i = 0; i < this.exprIndices.length; ++i) {
            if (!this.exprIndices[i].isQuantified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        if (this.exprIndices == null) {
            return new ArrayList<Expression>();
        }
        ArrayList<Expression> arrayList = this.exprIndices[0].getQuantifyingVariables();
        for (int i = 1; i < this.exprIndices.length; ++i) {
            ArrayList<Expression> arrayList2 = this.exprIndices[i].getQuantifyingVariables();
            int n = arrayList2.size();
            for (int j = 0; j < n; ++j) {
                arrayList.add(arrayList2.remove(0));
            }
        }
        return arrayList;
    }

    @Override
    public boolean isSearchVariable() {
        return this.isSearchVariable;
    }

    @Override
    public void setIsSearchVariable(boolean bl) {
        this.isSearchVariable = bl;
    }

    @Override
    public Expression copy() {
        String string = new String(this.arrayName);
        Domain domain = this.domain.copy();
        if (this.exprIndices == null) {
            int[] nArray = new int[this.intIndices.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.intIndices[i];
            }
            ArrayVariable arrayVariable = new ArrayVariable(string, nArray, domain);
            arrayVariable.setIndexIsAdaptedToSolver(this.isIndexAdaptedToSolver);
            return arrayVariable;
        }
        Expression[] expressionArray = new Expression[this.exprIndices.length];
        for (int i = 0; i < expressionArray.length; ++i) {
            expressionArray[i] = this.exprIndices[i].copy();
        }
        ArrayVariable arrayVariable = new ArrayVariable(string, expressionArray, domain);
        arrayVariable.setIndexIsAdaptedToSolver(this.isIndexAdaptedToSolver);
        return arrayVariable;
    }

    @Override
    public Variable evaluate() {
        this.domain = this.domain.evaluate();
        if (this.exprIndices != null) {
            boolean bl = true;
            for (int i = 0; i < this.exprIndices.length; ++i) {
                this.exprIndices[i] = this.exprIndices[i].evaluate();
                if (this.exprIndices[i].getType() == 3) continue;
                bl = false;
            }
            if (bl) {
                int[] nArray = new int[this.exprIndices.length];
                for (int i = 0; i < this.exprIndices.length; ++i) {
                    nArray[i] = ((ArithmeticAtomExpression)this.exprIndices[i]).getConstant();
                }
                return new ArrayVariable(this.arrayName, nArray, this.domain);
            }
        }
        return this;
    }

    public Domain getBaseDomain() {
        return this.domain;
    }

    @Override
    public int[] getDomain() {
        if (this.domain instanceof ConstantArrayDomain) {
            return ((ConstantArrayDomain)this.domain).getBaseDomain().getRange();
        }
        if (this.domain.isConstantDomain()) {
            return ((ConstantDomain)this.domain).getRange();
        }
        return new int[]{-100000, 100000};
    }

    @Override
    public Expression[] getDefinedDomain() {
        if (this.domain instanceof ConstantDomain) {
            return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(((ConstantDomain)this.domain).getRange()[0]), new ArithmeticAtomExpression(((ConstantDomain)this.domain).getRange()[1])};
        }
        if (this.domain instanceof ExpressionRange) {
            return ((ExpressionRange)this.domain).getLowerAndUpperBound();
        }
        if (this.domain instanceof ArrayDomain) {
            Domain domain = ((ArrayDomain)this.domain).getBaseDomain();
            if (domain instanceof ConstantDomain) {
                int[] nArray = ((ConstantDomain)domain).getRange();
                return new Expression[]{new ArithmeticAtomExpression(nArray[0]), new ArithmeticAtomExpression(nArray[1])};
            }
            if (domain instanceof ExpressionRange) {
                return ((ExpressionRange)domain).getLowerAndUpperBound();
            }
        }
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(-100000), new ArithmeticAtomExpression(100000)};
    }

    @Override
    public int getType() {
        return 14;
    }

    @Override
    public int getCategory() {
        return 3;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        ArrayVariable arrayVariable = (ArrayVariable)expression;
        if (this.arrayName.compareTo(arrayVariable.arrayName) != 0) {
            return this.arrayName.compareTo(arrayVariable.arrayName) < 0 ? (char)'s' : 'g';
        }
        if (this.intIndices != null) {
            if (arrayVariable.intIndices == null) {
                if (arrayVariable.exprIndices.length < this.intIndices.length) {
                    return 'g';
                }
                return 's';
            }
            if (arrayVariable.intIndices.length == this.intIndices.length) {
                for (int i = 0; i < this.intIndices.length; ++i) {
                    int n = this.intIndices[i] - arrayVariable.intIndices[i];
                    if (n < 0) {
                        return 's';
                    }
                    if (n <= 0) continue;
                    return 'g';
                }
                return 'e';
            }
            return arrayVariable.intIndices.length > this.intIndices.length ? (char)'s' : 'g';
        }
        if (arrayVariable.exprIndices == null) {
            if (this.exprIndices.length < arrayVariable.intIndices.length) {
                return 's';
            }
            return 'g';
        }
        if (arrayVariable.exprIndices.length == this.exprIndices.length) {
            for (int i = 0; i < this.exprIndices.length; ++i) {
                if (this.exprIndices[i].getType() == arrayVariable.exprIndices[i].getType()) {
                    char c = this.exprIndices[i].isSmallerThanSameType(arrayVariable.exprIndices[i]);
                    if (c == 'e') continue;
                    return c;
                }
                return this.exprIndices[i].getType() < arrayVariable.exprIndices[i].getType() ? (char)'s' : 'g';
            }
            return 'e';
        }
        return arrayVariable.exprIndices.length > this.exprIndices.length ? (char)'s' : 'g';
    }

    @Override
    public void orderExpression() {
    }

    @Override
    public Expression reduceExpressionTree() {
        return this;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.arrayName + "[");
        if (this.intIndices != null) {
            stringBuffer.append(this.intIndices[0] + "");
            for (int i = 1; i < this.intIndices.length; ++i) {
                stringBuffer.append("," + this.intIndices[i]);
            }
        } else {
            stringBuffer.append(((Object)this.exprIndices[0]).toString());
            for (int i = 1; i < this.exprIndices.length; ++i) {
                stringBuffer.append("," + ((Object)this.exprIndices[i]).toString());
            }
        }
        return stringBuffer + "]";
    }

    @Override
    public String getVariableName() {
        String string = this.arrayName + "[";
        if (this.intIndices != null) {
            string = string.concat(this.intIndices[0] + "");
            for (int i = 1; i < this.intIndices.length; ++i) {
                string = string.concat("," + this.intIndices[i]);
            }
        } else {
            string = string.concat(((Object)this.exprIndices[0]).toString());
            for (int i = 1; i < this.exprIndices.length; ++i) {
                string = string.concat("," + ((Object)this.exprIndices[i]).toString());
            }
        }
        return string + "]";
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        if (this.exprIndices != null) {
            boolean bl = true;
            for (int i = 0; i < this.exprIndices.length; ++i) {
                this.exprIndices[i] = this.exprIndices[i].insertValueForVariable(n, string);
                if (this.exprIndices[i].getType() == 3) continue;
                bl = false;
            }
            if (bl) {
                int[] nArray = new int[this.exprIndices.length];
                for (int i = 0; i < this.exprIndices.length; ++i) {
                    nArray[i] = ((ArithmeticAtomExpression)this.exprIndices[i]).getConstant();
                }
                return new ArrayVariable(this.arrayName, nArray, this.domain);
            }
        }
        this.domain = this.domain.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        if (this.exprIndices != null) {
            boolean bl2 = true;
            for (int i = 0; i < this.exprIndices.length; ++i) {
                this.exprIndices[i] = this.exprIndices[i].insertValueForVariable(bl, string);
                if (this.exprIndices[i].getType() == 3) continue;
                bl2 = false;
            }
            if (bl2) {
                int[] nArray = new int[this.exprIndices.length];
                for (int i = 0; i < this.exprIndices.length; ++i) {
                    nArray[i] = ((ArithmeticAtomExpression)this.exprIndices[i]).getConstant();
                }
                return new ArrayVariable(this.arrayName, nArray, this.domain);
            }
        }
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        if (this.exprIndices != null) {
            boolean bl = true;
            for (int i = 0; i < this.exprIndices.length; ++i) {
                this.exprIndices[i] = this.exprIndices[i].replaceVariableWithExpression(string, expression).evaluate();
                if (this.exprIndices[i].getType() == 3) continue;
                bl = false;
            }
            if (bl) {
                int[] nArray = new int[this.exprIndices.length];
                for (int i = 0; i < this.exprIndices.length; ++i) {
                    nArray[i] = ((ArithmeticAtomExpression)this.exprIndices[i]).getConstant();
                }
                return new ArrayVariable(this.arrayName, nArray, this.domain);
            }
        }
        return this;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    public int[] getIntegerIndices() {
        return this.intIndices;
    }

    public String getArrayNameOnly() {
        return this.arrayName;
    }

    public Expression[] getExpressionIndices() {
        return this.exprIndices;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        if (((Object)this.domain).toString().equals(string)) {
            this.domain = domain;
        }
        if (this.exprIndices != null) {
            for (int i = 0; i < this.exprIndices.length; ++i) {
                this.exprIndices[i] = this.exprIndices[i].insertDomainForVariable(domain, string);
            }
        }
        return this;
    }

    public boolean isIndexedBySomethingNotConstant() {
        return this.exprIndices != null;
    }

    public boolean isGonnaBeFlattenedToPartwiseElementConstraint() {
        return this.willBeFlattenedToPartwiseElementConstraint;
    }

    public void setWillBeFlattenedToPartwiseElementConstraint(boolean bl) {
        this.willBeFlattenedToPartwiseElementConstraint = bl;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        if (this.arrayName.equals(variable.getVariableName())) {
            return variable2;
        }
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        if (targetSolver instanceof Gecode) {
            return this.toString();
        }
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    public boolean isIndexAdaptedToSolver() {
        return this.isIndexAdaptedToSolver;
    }

    public void setIndexIsAdaptedToSolver(boolean bl) {
        this.isIndexAdaptedToSolver = bl;
    }

    public ArrayVariable adaptOffsetToIndices(int[] nArray) throws Exception {
        if (this.isIndexAdaptedToSolver) {
            return this;
        }
        if (nArray.length != this.intIndices.length) {
            throw new Exception("Internal error. Trying to adapt unequal amount of offsets to integer indices of:" + this);
        }
        for (int i = 0; i < this.intIndices.length; ++i) {
            int n = i;
            this.intIndices[n] = this.intIndices[n] + nArray[i];
        }
        this.isIndexAdaptedToSolver = true;
        return this;
    }

    public int getDimension() {
        if (this.intIndices != null) {
            return this.intIndices.length;
        }
        return this.exprIndices.length;
    }

    public void setIntIndices(int[] nArray) {
        this.intIndices = nArray;
        this.exprIndices = null;
    }

    public void setExpressionIndices(Expression[] expressionArray) {
        this.exprIndices = expressionArray;
        this.intIndices = null;
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        if (this.arrayName.equals(string) && !this.isIndexAdaptedToSolver) {
            if (this.intIndices != null) {
                this.exprIndices = new Expression[this.intIndices.length];
                for (int i = 0; i < this.intIndices.length; ++i) {
                    this.exprIndices[i] = new Sum(new Expression[]{new ArithmeticAtomExpression(this.intIndices[i])}, new Expression[]{expressionArray[i]});
                }
                this.intIndices = null;
            } else {
                for (int i = 0; i < this.exprIndices.length; ++i) {
                    this.exprIndices[i] = new Sum(new Expression[]{this.exprIndices[i].copy()}, new Expression[]{expressionArray[i]});
                }
            }
            this.isIndexAdaptedToSolver = true;
        }
    }
}

