/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.BoolDomain;
import translator.expression.ConstantArrayDomain;
import translator.expression.ConstantDomain;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.IntRange;
import translator.expression.MatrixDomain;
import translator.expression.MultipleIntRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayDomain
implements MatrixDomain {
    private Domain baseDomain;
    private Domain[] indexDomains;

    public ArrayDomain(Domain domain, Domain[] domainArray) {
        this.baseDomain = domain;
        this.indexDomains = domainArray;
    }

    public ArrayDomain(Domain domain, ArrayList<Domain> arrayList) {
        this.baseDomain = domain;
        this.indexDomains = new Domain[arrayList.size()];
        for (int i = this.indexDomains.length - 1; i >= 0; --i) {
            this.indexDomains[i] = arrayList.remove(i);
        }
    }

    @Override
    public Domain copy() {
        Domain[] domainArray = new Domain[this.indexDomains.length];
        for (int i = 0; i < this.indexDomains.length; ++i) {
            domainArray[i] = this.indexDomains[i].copy();
        }
        return new ArrayDomain(this.baseDomain.copy(), domainArray);
    }

    @Override
    public Domain evaluate() {
        boolean bl = true;
        this.baseDomain = this.baseDomain.evaluate();
        bl = bl && this.baseDomain instanceof ConstantDomain;
        for (int i = 0; i < this.indexDomains.length; ++i) {
            this.indexDomains[i] = this.indexDomains[i].evaluate();
            bl = bl && this.indexDomains[i] instanceof ConstantDomain;
        }
        if (bl) {
            ConstantDomain[] constantDomainArray = new ConstantDomain[this.indexDomains.length];
            for (int i = 0; i < this.indexDomains.length; ++i) {
                constantDomainArray[i] = (ConstantDomain)this.indexDomains[i];
            }
            return new ConstantArrayDomain(constantDomainArray, (ConstantDomain)this.baseDomain);
        }
        return this;
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public int getCategory() {
        int n = 0;
        for (int i = 0; i < this.indexDomains.length; ++i) {
            if (n >= this.indexDomains[i].getCategory()) continue;
            n = this.indexDomains[i].getCategory();
        }
        return this.baseDomain.getCategory() > n ? this.baseDomain.getCategory() : n;
    }

    @Override
    public Domain insertValueForVariable(int n, String string) {
        this.baseDomain = this.baseDomain.insertValueForVariable(n, string);
        for (int i = 0; i < this.indexDomains.length; ++i) {
            this.indexDomains[i] = this.indexDomains[i].insertValueForVariable(n, string);
        }
        return this;
    }

    @Override
    public Domain insertValueForVariable(boolean bl, String string) {
        this.baseDomain = this.baseDomain.insertValueForVariable(bl, string);
        for (int i = 0; i < this.indexDomains.length; ++i) {
            this.indexDomains[i] = this.indexDomains[i].insertValueForVariable(bl, string);
        }
        return this;
    }

    @Override
    public boolean isConstantDomain() {
        boolean bl = this.baseDomain.isConstantDomain();
        for (int i = 0; i < this.indexDomains.length; ++i) {
            bl = this.indexDomains[i].isConstantDomain() && bl;
        }
        return bl;
    }

    @Override
    public Domain replaceVariableWithDomain(String string, Domain domain) {
        this.baseDomain = this.baseDomain.replaceVariableWithDomain(string, domain);
        this.baseDomain = this.baseDomain.evaluate();
        boolean bl = this.baseDomain instanceof ConstantDomain;
        for (int i = 0; i < this.indexDomains.length; ++i) {
            this.indexDomains[i] = this.indexDomains[i].replaceVariableWithDomain(string, domain);
            this.indexDomains[i] = this.indexDomains[i].evaluate();
            bl = bl && this.indexDomains[i] instanceof ConstantDomain;
        }
        if (bl) {
            ConstantDomain[] constantDomainArray = new ConstantDomain[this.indexDomains.length];
            for (int i = 0; i < constantDomainArray.length; ++i) {
                constantDomainArray[i] = (ConstantDomain)this.indexDomains[i];
            }
            return new ConstantArrayDomain(constantDomainArray, (ConstantDomain)this.baseDomain);
        }
        return this;
    }

    @Override
    public Domain replaceVariableWithExpression(String string, Expression expression) throws Exception {
        this.baseDomain = this.baseDomain.replaceVariableWithExpression(string, expression);
        this.baseDomain = this.baseDomain.evaluate();
        boolean bl = this.baseDomain instanceof ConstantDomain;
        for (int i = 0; i < this.indexDomains.length; ++i) {
            this.indexDomains[i] = this.indexDomains[i].replaceVariableWithExpression(string, expression);
            this.indexDomains[i] = this.indexDomains[i].evaluate();
            bl = bl && this.indexDomains[i] instanceof ConstantDomain;
        }
        if (bl) {
            ConstantDomain[] constantDomainArray = new ConstantDomain[this.indexDomains.length];
            for (int i = 0; i < constantDomainArray.length; ++i) {
                constantDomainArray[i] = (ConstantDomain)this.indexDomains[i];
            }
            return new ConstantArrayDomain(constantDomainArray, (ConstantDomain)this.baseDomain);
        }
        return this;
    }

    @Override
    public String toString() {
        String string = "matrix indexed by  [ " + this.indexDomains[0];
        for (int i = 1; i < this.indexDomains.length; ++i) {
            string = string.concat("," + ((Object)this.indexDomains[i]).toString());
        }
        return string + " ] of " + ((Object)this.baseDomain).toString();
    }

    @Override
    public Domain getBaseDomain() {
        return this.baseDomain;
    }

    @Override
    public Domain[] getIndexDomains() {
        return this.indexDomains;
    }

    public int[] getIndexOffsetsFromZero() {
        int[] nArray = new int[this.indexDomains.length];
        for (int i = 0; i < this.indexDomains.length; ++i) {
            Domain domain = this.indexDomains[i];
            if (domain.isConstantDomain()) {
                if (domain instanceof BoolDomain) {
                    nArray[i] = 0;
                    continue;
                }
                if (domain instanceof IntRange) {
                    nArray[i] = ((IntRange)domain).getRange()[0];
                    continue;
                }
                if (!(domain instanceof MultipleIntRange)) continue;
                nArray[i] = ((MultipleIntRange)domain).getRange()[0];
                continue;
            }
            return null;
        }
        return nArray;
    }

    public void setBaseDomain(Domain domain) throws Exception {
        if (domain instanceof ArrayDomain) {
            throw new Exception("Cannot have matrix domain as a base domain for matrix domain :" + this);
        }
        this.baseDomain = domain;
    }

    public void setIndexDomainAt(Domain domain, int n) throws Exception {
        if (n < this.indexDomains.length && n >= 0) {
            if (domain instanceof ArrayDomain) {
                throw new Exception("Cannot have matrix domain as a base domain for matrix domain :" + this);
            }
        } else {
            throw new Exception("Index '" + n + "' for index-domain of array domain '" + this + "' is out of bounds.");
        }
        this.indexDomains[n] = domain;
    }

    public void setIndexDomains(Domain[] domainArray) {
        this.indexDomains = domainArray;
    }
}

