/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticExpression;
import translator.expression.ArrayVariable;
import translator.expression.AtomExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.RelationalAtomExpression;
import translator.expression.SimpleVariable;
import translator.expression.SingleVariable;
import translator.expression.Variable;
import translator.solver.Gecode;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArithmeticAtomExpression
implements ArithmeticExpression,
AtomExpression {
    private int constantValue;
    private Variable variable;
    private int type;
    private boolean isParameter;
    private boolean isQuantifiedVariable = false;
    private boolean isNested;
    private boolean willBeReified = false;
    private boolean isNegated = false;

    public ArithmeticAtomExpression(int n) {
        this.constantValue = n;
        this.type = 3;
        this.isParameter = false;
        this.isNested = true;
    }

    public ArithmeticAtomExpression(Variable variable, boolean bl) {
        this.variable = variable;
        this.type = this.variable.getType() == 14 || this.variable.getType() == 15 ? 22 : 21;
        this.isParameter = bl;
    }

    public ArithmeticAtomExpression(Variable variable) {
        this.variable = variable;
        this.type = this.variable.getType() == 14 || this.variable.getType() == 15 ? 22 : 21;
        this.isParameter = false;
    }

    public ArithmeticAtomExpression(boolean bl, Variable variable) {
        this.variable = variable;
        this.type = this.variable.getType() == 14 || this.variable.getType() == 15 ? 22 : 21;
        this.isParameter = false;
        this.isNegated = bl;
    }

    @Override
    public boolean isQuantified() {
        if (this.variable == null) {
            return false;
        }
        return this.isQuantifiedVariable || this.variable.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        if (this.variable == null) {
            return new ArrayList<Expression>();
        }
        if (this.isQuantifiedVariable) {
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            arrayList.add(this);
            return arrayList;
        }
        return this.variable.getQuantifyingVariables();
    }

    @Override
    public ArithmeticAtomExpression copy() {
        ArithmeticAtomExpression arithmeticAtomExpression = this.variable == null ? new ArithmeticAtomExpression(this.constantValue) : new ArithmeticAtomExpression((Variable)this.variable.copy());
        arithmeticAtomExpression.setIsParameter(this.isParameter);
        arithmeticAtomExpression.setIsQuantifiedVariable(this.isQuantifiedVariable);
        return arithmeticAtomExpression;
    }

    @Override
    public int[] getDomain() {
        if (this.variable == null) {
            return new int[]{this.constantValue, this.constantValue};
        }
        return this.variable.getDomain();
    }

    @Override
    public Expression[] getDefinedDomain() {
        if (this.variable == null) {
            return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(this.constantValue), new ArithmeticAtomExpression(this.constantValue)};
        }
        if (this.isParameter) {
            return new Expression[]{this, this};
        }
        return this.variable.getDefinedDomain();
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getCategory() {
        if (this.type == 3) {
            return 0;
        }
        if (this.isParameter) {
            return 1;
        }
        if (this.isQuantifiedVariable) {
            return 2;
        }
        return this.variable.getCategory();
    }

    @Override
    public void orderExpression() {
    }

    @Override
    public String toString() {
        return this.variable == null ? this.constantValue + "" : this.variable.toString();
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        ArithmeticAtomExpression arithmeticAtomExpression = (ArithmeticAtomExpression)expression;
        if (this.type == 3) {
            if (this.constantValue == arithmeticAtomExpression.constantValue) {
                return 'e';
            }
            return this.constantValue < arithmeticAtomExpression.constantValue ? (char)'s' : 'g';
        }
        if (this.variable.getType() == arithmeticAtomExpression.variable.getType()) {
            return this.variable.isSmallerThanSameType(arithmeticAtomExpression.variable);
        }
        return this.variable.getType() < arithmeticAtomExpression.variable.getType() ? (char)'s' : 'g';
    }

    @Override
    public ArithmeticAtomExpression evaluate() {
        if (this.variable != null) {
            this.variable = (Variable)this.variable.evaluate();
        }
        return this;
    }

    public int getConstant() {
        return this.constantValue;
    }

    @Override
    public Variable getVariable() {
        return this.variable;
    }

    @Override
    public boolean isParameter() {
        return this.isParameter;
    }

    @Override
    public void setIsParameter(boolean bl) {
        this.isParameter = bl;
    }

    @Override
    public boolean isQuantifiedVariable() {
        return this.isQuantifiedVariable;
    }

    @Override
    public void setIsQuantifiedVariable(boolean bl) {
        this.isQuantifiedVariable = bl;
    }

    public RelationalAtomExpression toRelationalAtomExpression() {
        RelationalAtomExpression relationalAtomExpression = this.variable == null ? (this.constantValue > 0 ? new RelationalAtomExpression(true) : new RelationalAtomExpression(false)) : new RelationalAtomExpression(this.variable);
        relationalAtomExpression.setIsParameter(this.isParameter);
        relationalAtomExpression.setIsQuantifiedVariable(this.isQuantifiedVariable);
        return relationalAtomExpression;
    }

    @Override
    public Expression reduceExpressionTree() {
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        if (this.variable != null) {
            if (this.variable instanceof SingleVariable || this.variable instanceof SimpleVariable) {
                Expression expression = this.variable.insertValueForVariable(n, string);
                if (expression.getType() == 3) {
                    return (ArithmeticAtomExpression)expression;
                }
                return this;
            }
            this.variable = (Variable)this.variable.insertValueForVariable(n, string);
            this.variable.evaluate();
            return this;
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        if (this.variable != null) {
            if (this.variable instanceof SingleVariable) {
                return this;
            }
            this.variable = (Variable)this.variable.insertValueForVariable(bl, string);
        }
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        if (this.variable != null) {
            Expression expression2 = this.variable.replaceVariableWithExpression(string, expression);
            if (!(expression2 instanceof Variable)) {
                return expression2;
            }
            this.variable = (Variable)expression2;
        }
        return this;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        Expression expression;
        if (this.variable != null && (expression = this.variable.insertDomainForVariable(domain, string)) instanceof Variable) {
            this.variable = (Variable)expression;
        }
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        if (this.variable != null && this.variable.getVariableName().equals(variable.getVariableName())) {
            this.variable = variable2;
        }
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return true;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        if (targetSolver instanceof Gecode && targetSolver instanceof Gecode) {
            if (this.variable instanceof ArrayVariable && ((ArrayVariable)this.variable).isIndexedBySomethingNotConstant()) {
                throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
            }
            return this.toString();
        }
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void setVariable(Variable variable) {
        if (this.variable != null) {
            this.variable = variable;
        }
    }

    @Override
    public void setIsNegated(boolean bl) {
        this.isNegated = bl;
    }

    @Override
    public boolean isNegated() {
        return this.isNegated;
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        if (this.variable != null) {
            this.variable.adaptIndicesForSolver(string, expressionArray);
        }
    }
}

