/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.Array;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.UnaryRelationalExpression;
import translator.expression.Variable;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllDifferent
implements UnaryRelationalExpression {
    private Array argument;
    private Expression expression;
    private boolean isNested;
    private boolean willBeReified = false;

    public AllDifferent(Array array) {
        this.argument = array;
        this.isNested = true;
    }

    public AllDifferent(Expression expression) {
        this.expression = expression;
    }

    @Override
    public void setArgument(Expression expression) {
        if (expression instanceof Array) {
            this.argument = (Array)expression;
        } else {
            this.expression = expression;
        }
    }

    @Override
    public boolean isQuantified() {
        if (this.expression == null) {
            return this.argument.isQuantified();
        }
        return this.expression.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        if (this.argument != null) {
            return this.argument.getQuantifyingVariables();
        }
        return this.expression.getQuantifyingVariables();
    }

    @Override
    public Expression getArgument() {
        if (this.expression == null) {
            return this.argument;
        }
        return this.expression;
    }

    @Override
    public Expression copy() {
        if (this.argument != null) {
            return new AllDifferent((Array)this.argument.copy());
        }
        return new AllDifferent(this.expression.copy());
    }

    @Override
    public int getType() {
        return 220;
    }

    @Override
    public int getCategory() {
        return 3;
    }

    @Override
    public void orderExpression() {
        if (this.argument != null) {
            this.argument.orderExpression();
        }
    }

    @Override
    public String toString() {
        if (this.expression != null) {
            return "alldifferent(" + ((Object)this.expression).toString() + ")";
        }
        return "alldifferent(" + this.argument.toString() + ")";
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        AllDifferent allDifferent = (AllDifferent)expression;
        if (this.argument != null) {
            if (this.argument.getType() < allDifferent.getArgument().getType()) {
                return 's';
            }
            if (this.argument.getType() == allDifferent.getArgument().getType()) {
                return this.argument.isSmallerThanSameType(allDifferent.getArgument());
            }
            return 'g';
        }
        return 'e';
    }

    @Override
    public Expression evaluate() {
        if (this.expression == null) {
            this.argument = (Array)this.argument.evaluate();
        } else {
            this.expression = this.expression.evaluate();
        }
        return this;
    }

    @Override
    public Expression reduceExpressionTree() {
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        if (this.argument != null) {
            this.argument = (Array)this.argument.insertValueForVariable(n, string);
        } else {
            this.expression = this.expression.insertValueForVariable(n, string);
        }
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        if (this.argument != null) {
            this.argument = (Array)this.argument.insertValueForVariable(bl, string);
        } else {
            this.expression = this.expression.insertValueForVariable(bl, string);
        }
        return this;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        if (this.argument != null) {
            this.argument = (Array)this.argument.insertDomainForVariable(domain, string);
        } else {
            this.expression = this.expression.insertDomainForVariable(domain, string);
        }
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        if (this.argument != null) {
            this.argument = (Array)this.argument.replaceVariableWith(variable, variable2);
        } else {
            this.expression = this.expression.replaceVariableWith(variable, variable2);
        }
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        if (this.argument != null) {
            this.argument = (Array)this.argument.replaceVariableWithExpression(string, expression);
        } else {
            this.expression = this.expression.replaceVariableWithExpression(string, expression);
            if (expression instanceof Array) {
                this.argument = (Array)expression;
            }
        }
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return false;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        if (this.argument != null) {
            this.argument.adaptIndicesForSolver(string, expressionArray);
        } else {
            this.expression.adaptIndicesForSolver(string, expressionArray);
        }
    }
}

