/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.BinaryMinimum;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.UnaryArithmeticExpression;
import translator.expression.UnaryMinus;
import translator.expression.Variable;
import translator.solver.Gecode;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbsoluteValue
implements UnaryArithmeticExpression {
    private Expression argument;
    boolean isNested;
    boolean willBeReified = false;

    public AbsoluteValue(Expression expression) {
        this.argument = expression;
        this.isNested = true;
    }

    @Override
    public Expression getArgument() {
        return this.argument;
    }

    @Override
    public Expression copy() {
        return new AbsoluteValue(this.argument.copy());
    }

    @Override
    public boolean isQuantified() {
        return this.argument.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        return this.argument.getQuantifyingVariables();
    }

    @Override
    public int[] getDomain() {
        int[] nArray = this.argument.getDomain();
        int n = 0;
        int n2 = 0;
        if (nArray[0] < 0) {
            n = 0;
            n2 = -nArray[0] > nArray[1] ? -nArray[0] : nArray[1];
            return new int[]{n, n2};
        }
        n = nArray[0];
        n2 = nArray[1];
        return new int[]{n, n2};
    }

    @Override
    public Expression[] getDefinedDomain() {
        Expression[] expressionArray = this.argument.getDefinedDomain();
        Expression expression = expressionArray[0];
        Expression expression2 = expressionArray[1];
        if (expression.getType() == 3 && expression2.getType() == 3) {
            int n = ((ArithmeticAtomExpression)expression).getConstant();
            int n2 = ((ArithmeticAtomExpression)expression2).getConstant();
            int n3 = 0;
            int n4 = 0;
            if (n < 0 && n2 > 0) {
                n3 = 0;
                n4 = -n > n2 ? -n : n2;
                return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(n3), new ArithmeticAtomExpression(n4)};
            }
            n3 = n;
            n4 = n2;
            return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(n3), new ArithmeticAtomExpression(n4)};
        }
        if (expression instanceof UnaryMinus && !(expression2 instanceof UnaryMinus)) {
            ArithmeticAtomExpression arithmeticAtomExpression = new ArithmeticAtomExpression(0);
            Expression expression3 = null;
            Expression expression4 = ((UnaryMinus)expression).getArgument();
            if (((Object)expression4).toString().equals(((Object)expression2).toString())) {
                expression3 = expression2;
            } else {
                boolean bl = true;
                expression3 = new BinaryMinimum(((UnaryMinus)expression).getArgument(), expression2, bl);
            }
            return new Expression[]{arithmeticAtomExpression, expression3};
        }
        return new Expression[]{new AbsoluteValue(expression).evaluate(), new AbsoluteValue(expression2).evaluate()};
    }

    @Override
    public int getType() {
        return 42;
    }

    @Override
    public int getCategory() {
        return this.argument.getCategory();
    }

    @Override
    public void orderExpression() {
        this.argument.orderExpression();
    }

    @Override
    public String toString() {
        return "|" + this.argument + "|";
    }

    @Override
    public Expression evaluate() {
        this.argument = this.argument.evaluate();
        if (this.argument.getType() == 3) {
            int n = ((ArithmeticAtomExpression)this.argument).getConstant();
            return n < 0 ? new ArithmeticAtomExpression(-n) : new ArithmeticAtomExpression(n);
        }
        return this;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        AbsoluteValue absoluteValue = (AbsoluteValue)expression;
        if (this.argument.getType() == absoluteValue.argument.getType()) {
            return this.argument.isSmallerThanSameType(absoluteValue.argument);
        }
        return this.argument.getType() < absoluteValue.argument.getType() ? (char)'s' : 'g';
    }

    @Override
    public Expression reduceExpressionTree() {
        this.argument = this.argument.reduceExpressionTree();
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        this.argument = this.argument.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        this.argument = this.argument.insertValueForVariable(bl, string);
        return this;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public Expression restructure() {
        this.argument = this.argument.restructure();
        return this;
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        this.argument = this.argument.insertDomainForVariable(domain, string);
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        this.argument = this.argument.replaceVariableWithExpression(string, expression);
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        this.argument = this.argument.replaceVariableWith(variable, variable2);
        return this;
    }

    @Override
    public boolean isLinearExpression() {
        return this.argument.isLinearExpression();
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        if (targetSolver instanceof Gecode) {
            if (this.argument.getCategory() != 3) {
                return "abs(" + this.argument.toSolverExpression(targetSolver) + ")";
            }
            return "abs(this, " + this.argument.toSolverExpression(targetSolver) + ")";
        }
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        this.argument.adaptIndicesForSolver(string, expressionArray);
    }
}

