/*
 * Decompiled with CFR 0.152.
 */
package translator.expression;

import java.util.ArrayList;
import translator.expression.ArithmeticAtomExpression;
import translator.expression.CommutativeBinaryRelationalExpression;
import translator.expression.Domain;
import translator.expression.Expression;
import translator.expression.GlobalConstraint;
import translator.expression.RelationalAtomExpression;
import translator.expression.Variable;
import translator.solver.TargetSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbsoluteConstraint
implements GlobalConstraint {
    private Expression argument;
    private Expression result;
    private boolean isNested = true;
    private boolean willBeReified = false;

    public AbsoluteConstraint(Expression expression, Expression expression2) {
        this.argument = expression;
        this.result = expression2;
    }

    @Override
    public boolean isQuantified() {
        return this.argument.isQuantified() || this.result.isQuantified();
    }

    @Override
    public ArrayList<Expression> getQuantifyingVariables() {
        ArrayList<Expression> arrayList = this.argument.getQuantifyingVariables();
        ArrayList<Expression> arrayList2 = this.result.getQuantifyingVariables();
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(arrayList2.remove(0));
        }
        return arrayList;
    }

    @Override
    public Expression[] getArguments() {
        return new Expression[]{this.argument};
    }

    @Override
    public Expression copy() {
        AbsoluteConstraint absoluteConstraint = new AbsoluteConstraint(this.argument.copy(), this.result.copy());
        absoluteConstraint.willBeReified = this.willBeReified;
        return absoluteConstraint;
    }

    @Override
    public Expression evaluate() {
        int n;
        this.argument = this.argument.evaluate();
        this.result = this.result.evaluate();
        if (this.argument.getType() == 3 && this.result.getType() == 3) {
            int n2 = ((ArithmeticAtomExpression)this.argument).getConstant();
            int n3 = ((ArithmeticAtomExpression)this.result).getConstant();
            if (n2 < 0) {
                n2 = -n2;
            }
            return new RelationalAtomExpression(n2 == n3);
        }
        if (this.argument.getType() == 3 && (n = ((ArithmeticAtomExpression)this.argument).getConstant()) >= 0) {
            return new CommutativeBinaryRelationalExpression(new ArithmeticAtomExpression(n), 101, this.result);
        }
        return this;
    }

    @Override
    public int[] getDomain() {
        return new int[]{0, 1};
    }

    @Override
    public Expression[] getDefinedDomain() {
        return new ArithmeticAtomExpression[]{new ArithmeticAtomExpression(0), new ArithmeticAtomExpression(1)};
    }

    @Override
    public int getType() {
        return 281;
    }

    @Override
    public int getCategory() {
        return Math.max(this.argument.getCategory(), this.result.getCategory());
    }

    @Override
    public Expression insertDomainForVariable(Domain domain, String string) throws Exception {
        this.argument = this.argument.insertDomainForVariable(domain, string);
        this.result = this.result.insertDomainForVariable(domain, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(int n, String string) {
        this.argument = this.argument.insertValueForVariable(n, string);
        this.result = this.result.insertValueForVariable(n, string);
        return this;
    }

    @Override
    public Expression insertValueForVariable(boolean bl, String string) {
        this.argument = this.argument.insertValueForVariable(bl, string);
        this.result = this.result.insertValueForVariable(bl, string);
        return this;
    }

    @Override
    public boolean isGonnaBeFlattenedToVariable() {
        return this.willBeReified;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public char isSmallerThanSameType(Expression expression) {
        return 'e';
    }

    @Override
    public void orderExpression() {
        this.argument.orderExpression();
        this.result.orderExpression();
    }

    @Override
    public Expression reduceExpressionTree() {
        return this;
    }

    @Override
    public Expression replaceVariableWith(Variable variable, Variable variable2) {
        this.argument = this.argument.replaceVariableWith(variable, variable2);
        this.result = this.result.replaceVariableWith(variable, variable2);
        return this;
    }

    @Override
    public Expression replaceVariableWithExpression(String string, Expression expression) throws Exception {
        this.argument = this.argument.replaceVariableWithExpression(string, expression);
        this.result = this.result.replaceVariableWithExpression(string, expression);
        return this;
    }

    @Override
    public Expression restructure() {
        return this;
    }

    @Override
    public void setIsNotNested() {
        this.isNested = false;
    }

    @Override
    public void willBeFlattenedToVariable(boolean bl) {
        this.willBeReified = bl;
    }

    @Override
    public boolean isLinearExpression() {
        boolean bl = this.result.isLinearExpression();
        return this.argument.isLinearExpression() && bl;
    }

    @Override
    public String toString() {
        return "|" + this.argument + "| = " + this.result;
    }

    @Override
    public String toSolverExpression(TargetSolver targetSolver) throws Exception {
        throw new Exception("Internal error. Cannot give direct solver representation of expression '" + this + "' for solver " + targetSolver.getSolverName());
    }

    @Override
    public void adaptIndicesForSolver(String string, Expression[] expressionArray) {
        this.argument.adaptIndicesForSolver(string, expressionArray);
    }

    public Expression getArgument() {
        return this.argument;
    }

    public Expression getResult() {
        return this.result;
    }
}

