/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.StringReader;
import java.util.ArrayList;
import translator.TranslationSettings;
import translator.essencePrimeParser.EssencePrimeLexer;
import translator.essencePrimeParser.EssencePrimeParser;
import translator.expression.EssencePrimeModel;
import translator.expression.Expression;
import translator.normaliser.NormalisedModel;
import translator.normaliser.Normaliser;
import translator.solver.TargetSolver;
import translator.tailor.Tailor;

public class Translator {
    EssencePrimeParser parser;
    Tailor tailor;
    EssencePrimeModel problemSpecification;
    EssencePrimeModel parameterSpecification;
    NormalisedModel normalisedModel;
    String targetSolverInstance;
    String errorMessage;
    String debug;
    String cseInfo;
    TranslationSettings settings;
    boolean normalisedModelHasBeenFlattened;

    public Translator(TranslationSettings translationSettings) {
        this.settings = translationSettings;
        this.errorMessage = new String("");
        this.debug = "";
        this.normalisedModelHasBeenFlattened = false;
    }

    public boolean parse(String string, String string2) {
        try {
            this.parser = new EssencePrimeParser(new EssencePrimeLexer(new StringReader(string)));
            this.problemSpecification = (EssencePrimeModel)this.parser.parse().value;
            if (this.parser.hadErrorRecovery) {
                this.errorMessage = this.errorMessage.concat("\n" + this.parser.errorMessage);
                return this.settings.allowParseErrorRecovery;
            }
            this.parser = new EssencePrimeParser(new EssencePrimeLexer(new StringReader(string2)));
            this.parameterSpecification = (EssencePrimeModel)this.parser.parse().value;
            if (this.parser.hadErrorRecovery) {
                this.errorMessage = this.errorMessage.concat("\n" + this.parser.errorMessage);
                return this.settings.allowParseErrorRecovery;
            }
        }
        catch (Exception exception) {
            if (this.settings.debugMode) {
                exception.printStackTrace(System.out);
            }
            this.errorMessage = this.errorMessage.concat("\n" + this.parser.errorMessage);
            return false;
        }
        return true;
    }

    public boolean parse(String string) {
        try {
            this.parser = new EssencePrimeParser(new EssencePrimeLexer(new StringReader(string)));
            this.problemSpecification = (EssencePrimeModel)this.parser.parse().value;
            if (this.parser.hadErrorRecovery) {
                this.errorMessage = this.errorMessage.concat("\n" + this.parser.errorMessage);
                return this.settings.allowParseErrorRecovery;
            }
            this.normalisedModelHasBeenFlattened = false;
            this.parameterSpecification = new EssencePrimeModel();
        }
        catch (Exception exception) {
            if (this.settings.debugMode) {
                exception.printStackTrace(System.out);
            }
            this.errorMessage = exception.getMessage();
            this.errorMessage = this.errorMessage.concat("\n" + this.parser.errorMessage);
            return false;
        }
        return true;
    }

    public boolean normalise(char c) {
        if (this.problemSpecification == null) {
            this.errorMessage = this.errorMessage.concat("Please parse problem file before normalisation.");
            return false;
        }
        try {
            long l = System.currentTimeMillis();
            Normaliser normaliser = new Normaliser(this.settings);
            this.normalisedModel = normaliser.normalise(this.problemSpecification, this.parameterSpecification, c);
            this.normalisedModelHasBeenFlattened = false;
            if (this.settings.giveTranslationTimeInfo) {
                long l2 = System.currentTimeMillis();
                this.writeTimeInfo("Normalisation Time: " + (double)(l2 - l) / 1000.0 + "sec");
            }
        }
        catch (Exception exception) {
            if (this.settings.debugMode) {
                exception.printStackTrace(System.out);
            }
            this.errorMessage = this.errorMessage.concat(exception.getMessage() + "\n");
            return false;
        }
        return true;
    }

    public boolean flatten(TargetSolver targetSolver) {
        if (this.normalisedModel == null) {
            this.errorMessage = this.errorMessage.concat("Please normalise problem model before flattening");
            return false;
        }
        try {
            long l = System.currentTimeMillis();
            this.settings.setTargetSolver(targetSolver);
            this.tailor = new Tailor(this.normalisedModel, this.settings);
            this.normalisedModel = this.tailor.flattenModel();
            this.normalisedModelHasBeenFlattened = true;
            if (this.settings.giveTranslationTimeInfo) {
                long l2 = System.currentTimeMillis();
                this.writeTimeInfo("Flattening Time: " + (double)(l2 - l) / 1000.0 + "sec");
            }
        }
        catch (Exception exception) {
            if (this.settings.debugMode) {
                exception.printStackTrace(System.out);
            }
            this.errorMessage = this.errorMessage.concat(exception.getMessage() + "\n");
            return false;
        }
        return true;
    }

    public boolean tailorTo(NormalisedModel normalisedModel, TargetSolver targetSolver) {
        this.normalisedModel = normalisedModel;
        if (this.settings.getPropagateSingleIntRanges()) {
            this.normalisedModel.propagateSingleRangeDecisionVariables();
        }
        try {
            long l;
            long l2 = System.currentTimeMillis();
            this.settings.setTargetSolver(targetSolver);
            this.tailor = new Tailor(this.normalisedModel, this.settings);
            this.normalisedModel = this.tailor.flattenModel();
            this.normalisedModelHasBeenFlattened = true;
            if (this.settings.giveTranslationTimeInfo) {
                l = System.currentTimeMillis();
                this.writeTimeInfo("Flattening Time: " + (double)(l - l2) / 1000.0 + "sec");
            }
            if (this.settings.flattenProblemClassOnly) {
                if (this.settings.getCseDetails()) {
                    this.cseInfo = this.tailor.getCseInfo();
                }
                return true;
            }
            this.targetSolverInstance = this.tailor.tailor(this.normalisedModel, this.settings.targetSolver);
            if (this.settings.giveTranslationTimeInfo) {
                l = System.currentTimeMillis();
                this.writeTimeInfo("Tailoring Time: " + (double)(l - l2) / 1000.0 + "sec");
            }
            if (this.settings.getCseDetails()) {
                this.cseInfo = this.tailor.getCseInfo();
            }
        }
        catch (Exception exception) {
            if (this.settings.debugMode) {
                exception.printStackTrace(System.out);
            }
            this.errorMessage = this.errorMessage.concat(exception.getMessage() + "\n");
            return false;
        }
        return true;
    }

    public boolean tailorTo(TargetSolver targetSolver) {
        if (this.normalisedModel == null) {
            this.errorMessage = this.errorMessage.concat("Please normalise problem model before flattening");
            return false;
        }
        if (this.normalisedModelHasBeenFlattened) {
            try {
                if (this.settings.flattenProblemClassOnly) {
                    return true;
                }
                long l = System.currentTimeMillis();
                this.targetSolverInstance = this.tailor.tailor(this.normalisedModel, this.settings.targetSolver);
                if (this.settings.giveTranslationTimeInfo) {
                    long l2 = System.currentTimeMillis();
                    this.writeTimeInfo("Tailoring Time: " + (double)(l2 - l) / 1000.0 + "sec");
                }
                if (this.settings.getCseDetails()) {
                    this.cseInfo = this.tailor.getCseInfo();
                }
                return true;
            }
            catch (Exception exception) {
                if (this.settings.debugMode) {
                    exception.printStackTrace(System.out);
                }
                this.errorMessage = this.errorMessage.concat(exception.getMessage() + "\n");
                return false;
            }
        }
        this.errorMessage = this.errorMessage.concat("Please flatten the model before tailoring it to a target solver");
        return false;
    }

    public boolean tailorTo(String string, String string2, TargetSolver targetSolver) {
        try {
            long l;
            long l2 = System.currentTimeMillis();
            this.parser = new EssencePrimeParser(new EssencePrimeLexer(new StringReader(string)));
            this.problemSpecification = (EssencePrimeModel)this.parser.parse().value;
            if (this.parser.hadErrorRecovery) {
                this.errorMessage = this.errorMessage.concat("\n" + this.parser.errorMessage);
                return false;
            }
            this.parser = new EssencePrimeParser(new EssencePrimeLexer(new StringReader(string2)));
            this.parameterSpecification = (EssencePrimeModel)this.parser.parse().value;
            if (this.parser.hadErrorRecovery) {
                this.errorMessage = this.errorMessage.concat("\n" + this.parser.errorMessage);
                return false;
            }
            if (this.settings.giveTranslationTimeInfo) {
                long l3 = System.currentTimeMillis();
                this.writeTimeInfo("Parse Time: " + (double)(l3 - l2) / 1000.0 + "sec");
            }
            l2 = System.currentTimeMillis();
            Normaliser normaliser = new Normaliser(this.settings);
            this.normalisedModel = normaliser.normalise(this.problemSpecification, this.parameterSpecification, '\u0004');
            if (this.settings.getPropagateSingleIntRanges()) {
                this.normalisedModel.propagateSingleRangeDecisionVariables();
            }
            if (this.settings.giveTranslationTimeInfo) {
                l = System.currentTimeMillis();
                this.writeTimeInfo("Normalisation Time: " + (double)(l - l2) / 1000.0 + "sec");
            }
            if (this.settings.normaliseProblemOnly) {
                return true;
            }
            l2 = System.currentTimeMillis();
            this.settings.setTargetSolver(targetSolver);
            this.tailor = new Tailor(this.normalisedModel, this.settings);
            this.normalisedModel = this.tailor.flattenModel();
            if (this.settings.giveTranslationTimeInfo) {
                l = System.currentTimeMillis();
                this.writeTimeInfo("Flattening Time: " + (double)(l - l2) / 1000.0 + "sec");
            }
            if (this.settings.flattenProblemClassOnly) {
                if (this.settings.getCseDetails()) {
                    this.cseInfo = this.tailor.getCseInfo();
                }
                return true;
            }
            l2 = System.currentTimeMillis();
            this.targetSolverInstance = this.tailor.tailor(this.normalisedModel, this.settings.targetSolver);
            if (this.settings.giveTranslationTimeInfo) {
                l = System.currentTimeMillis();
                this.writeTimeInfo("Tailoring Time: " + (double)(l - l2) / 1000.0 + "sec");
            }
            if (this.settings.getCseDetails()) {
                this.cseInfo = this.tailor.getCseInfo();
            }
            return true;
        }
        catch (Exception exception) {
            if (this.settings.debugMode) {
                exception.printStackTrace(System.out);
            }
            this.errorMessage = exception.getMessage();
            this.errorMessage = this.errorMessage.concat("\n" + this.parser.errorMessage);
            return false;
        }
    }

    public String getEssenceSolution(String string) {
        try {
            return this.tailor.getEssenceSolution(string);
        }
        catch (Exception exception) {
            if (this.settings.debugMode) {
                exception.printStackTrace(System.out);
            }
            this.errorMessage = exception.getMessage();
            return "";
        }
    }

    public boolean hasBeenNormalised() {
        return this.normalisedModel != null;
    }

    public boolean hasBeenFlattened() {
        return this.normalisedModelHasBeenFlattened;
    }

    public String getErrorMessage() {
        String string = this.errorMessage;
        this.errorMessage = "";
        return string;
    }

    public EssencePrimeModel getInitialProblemSpecification() {
        return this.problemSpecification;
    }

    public EssencePrimeModel getInitialParameterSpecification() {
        return this.parameterSpecification;
    }

    protected void print_debug(String string) {
        this.debug = this.debug.concat(" [ DEBUG translator ] " + string + "\n");
    }

    public String printInitialProblemSpecification() {
        return this.problemSpecification.toString();
    }

    public String printIntialParameterSpecification() {
        return this.parameterSpecification.toString();
    }

    public String printConstraints() {
        if (this.normalisedModel != null) {
            ArrayList<Expression> arrayList = this.normalisedModel.getConstraints();
            StringBuffer stringBuffer = new StringBuffer(((Object)arrayList.get(0)).toString());
            for (int i = 1; i < arrayList.size(); ++i) {
                stringBuffer.append(",\n\t" + arrayList.get(i));
            }
            return stringBuffer + "\n";
        }
        ArrayList<Expression> arrayList = this.problemSpecification.getConstraints();
        StringBuffer stringBuffer = new StringBuffer(((Object)arrayList.get(0)).toString());
        for (int i = 1; i < arrayList.size(); ++i) {
            stringBuffer.append(",\n\t" + ((Object)arrayList.get(i)).toString());
        }
        return stringBuffer + "\n";
    }

    public String printAdvancedModel() {
        if (this.normalisedModel != null) {
            return this.normalisedModel.toString();
        }
        return this.problemSpecification.toString();
    }

    public String getTargetSolverInstance() {
        return this.targetSolverInstance;
    }

    public String[] getPrintedVariables() {
        return this.settings.getPrintedVariables();
    }

    public String getCseInfo() {
        return this.cseInfo;
    }

    private void writeTimeInfo(String string) {
        if (this.settings.giveTranslationInfo) {
            System.out.println(string);
        }
    }

    public String getFlattenedEssencePrimeModel() {
        return this.normalisedModel.toString();
    }
}

