/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import translator.solver.Gecode;
import translator.solver.Minion;
import translator.solver.TargetSolver;

public class TranslationSettings {
    public final char MINION = '\u0001';
    public final char GECODE = (char)2;
    public final String TAILOR_VERSION = "0.3.2";
    public final String OUTPUTFILE_HEADER = "This file has been automatically generated by TAILOR v0.3.2";
    public final String OUTPUTFILE_HEADER_BUGS = "bug-reports: andrea@cs.st-and.ac.uk";
    public final String DEFAULT_MODEL_NAME = "ProblemModel";
    public final int DISCRETE_UPPER_BOUND = 200;
    public final String PATH_TO_MINION = "minion-path=";
    public final String PATH_TO_GECODE = "gecode-path=";
    public final String PATH_TO_FLATZINC = "fz-path=";
    public final String SETTINGS_FILE_COMMENT = "#";
    public final int FIND_ALL_SOLUTIONS = 0;
    public final int DEFAULT_NO_OF_SOLUTIONS = 1;
    public final boolean BRANCH_OVER_AUX_VARIABLES = true;
    int discreteUpperBound;
    TargetSolver targetSolver;
    String variableBranching = "default variable branching";
    String valueBranching = "default value branching";
    boolean branchOverAuxVariables;
    boolean useCommonSubExpressions;
    boolean useEqualSubExpressions;
    boolean applyStrictCopyPropagation;
    boolean useExplicitCommonSubExpressions;
    boolean applyDirectVariableReusage;
    boolean giveTranslationTimeInfo;
    boolean giveTranslationInfo;
    public boolean debugMode;
    boolean writeTimeInfoIntoFile;
    boolean writeEssencePIntoFile;
    boolean propagateSingleIntRanges;
    boolean cseDetails;
    boolean auxVarDetails;
    boolean cseVarOrdering;
    boolean negatedCSEs;
    boolean simpleConjunctionCSE;
    boolean simpleDisjunctionCSE;
    int flatzincArrayIndexStart;
    boolean isClassLevelTransformation;
    boolean estimatedIntAuxiliaryBounds;
    boolean flattenProblemClassOnly;
    boolean normaliseProblemOnly;
    boolean flatzincOutput;
    boolean allowParseErrorRecovery;
    int noOfSolutions;
    int maxUpperBound;
    int maxLowerBound;
    String pathToMinion;
    String pathToGecodeDirectory;
    String pathToFz;
    String[] printedVariables;
    String settingsFileName;
    String essenceP_outputFileName;
    String solverInputFileName;
    String modelName;
    private boolean useGecodeLinearMiniModelPost;
    private boolean useGecodeBooleanMiniModelPost;
    private boolean useMinionMinimumForConjunction;
    private boolean useMinionMaximumForDisjunction;
    private boolean useMinionProductForConjunction;
    private boolean useMinionReifyImply;

    public TranslationSettings() {
        this.targetSolver = new Minion(this);
        this.initialiseSettings();
    }

    public TranslationSettings(TargetSolver targetSolver) {
        this.targetSolver = targetSolver;
        this.initialiseSettings();
    }

    private void initialiseSettings() {
        this.settingsFileName = "settings";
        this.targetSolver = new Minion(this);
        this.useCommonSubExpressions = true;
        this.useEqualSubExpressions = true;
        this.useExplicitCommonSubExpressions = true;
        this.applyStrictCopyPropagation = false;
        this.giveTranslationTimeInfo = false;
        this.giveTranslationInfo = true;
        this.applyDirectVariableReusage = false;
        this.pathToMinion = this.readPathToMinion();
        this.pathToGecodeDirectory = this.readPathToGecode();
        this.pathToFz = "fz";
        this.essenceP_outputFileName = "out.eprime";
        this.modelName = "ProblemModel";
        this.debugMode = false;
        this.writeTimeInfoIntoFile = true;
        this.writeEssencePIntoFile = false;
        this.propagateSingleIntRanges = true;
        this.discreteUpperBound = this.DISCRETE_UPPER_BOUND;
        this.allowParseErrorRecovery = false;
        this.getClass();
        this.noOfSolutions = 1;
        this.getClass();
        this.branchOverAuxVariables = true;
        this.useGecodeLinearMiniModelPost = false;
        this.useGecodeBooleanMiniModelPost = false;
        this.cseDetails = false;
        this.auxVarDetails = false;
        this.cseVarOrdering = true;
        this.useMinionMinimumForConjunction = false;
        this.useMinionMaximumForDisjunction = false;
        this.negatedCSEs = false;
        this.simpleConjunctionCSE = true;
        this.simpleDisjunctionCSE = true;
        this.useMinionProductForConjunction = false;
        this.useMinionReifyImply = false;
        this.isClassLevelTransformation = false;
        this.maxLowerBound = -100000;
        this.maxUpperBound = 100000;
        this.estimatedIntAuxiliaryBounds = !this.isClassLevelTransformation;
        this.flattenProblemClassOnly = false;
        this.flatzincOutput = false;
        this.flatzincArrayIndexStart = 1;
    }

    public String readPathToMinion() {
        try {
            File file = new File(this.settingsFileName);
            String string = "";
            BufferedReader bufferedReader = null;
            if (file.createNewFile()) {
                String string2 = System.getProperty("user.dir");
                if (string2.length() > 10) {
                    string2 = string2.substring(0, string2.length() - 10);
                }
                this.pathToMinion = string2 + "bin/minion";
            } else {
                bufferedReader = new BufferedReader(new FileReader(file));
                string = bufferedReader.readLine();
                if (string == null || string.equals("")) {
                    String string3 = System.getProperty("user.dir");
                    if (string3.length() > 10) {
                        string3 = string3.substring(0, string3.length() - 10);
                    }
                    this.pathToMinion = string3 + "bin/minion";
                } else {
                    while (string != null && !string.equalsIgnoreCase("null")) {
                        if (string.startsWith(this.PATH_TO_MINION)) {
                            this.pathToMinion = string.substring("minion-path=".length());
                            break;
                        }
                        string = bufferedReader.readLine();
                    }
                }
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            return this.pathToMinion;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.out.println("Cannot open settings file '" + this.settingsFileName + "'.\n");
            System.exit(1);
            return "";
        }
    }

    public String readPathToGecode() {
        try {
            File file = new File(this.settingsFileName);
            String string = "";
            BufferedReader bufferedReader = null;
            if (file.createNewFile()) {
                String string2 = System.getProperty("user.dir");
                if (string2.length() > 10) {
                    string2 = string2.substring(0, string2.length() - 10);
                }
                this.pathToGecodeDirectory = string2 + "gecode";
            } else {
                bufferedReader = new BufferedReader(new FileReader(file));
                string = bufferedReader.readLine();
                if (string == null || string.equals("")) {
                    String string3 = System.getProperty("user.dir");
                    if (string3.length() > 10) {
                        string3 = string3.substring(0, string3.length() - 10);
                    }
                    this.pathToGecodeDirectory = string3 + "gecode";
                } else {
                    while (string != null && !string.equalsIgnoreCase("null")) {
                        if (string.startsWith(this.PATH_TO_GECODE)) {
                            this.pathToGecodeDirectory = string.substring("gecode-path=".length());
                            break;
                        }
                        string = bufferedReader.readLine();
                    }
                }
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            return this.pathToGecodeDirectory;
        }
        catch (Exception exception) {
            System.out.println("Cannot open settings file '" + this.settingsFileName + "':\n" + exception.getMessage());
            System.exit(1);
            return "";
        }
    }

    public void writeNewPath(String string, char c) {
        try {
            File file = new File(this.settingsFileName);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            if (!file.canRead()) {
                System.out.println("Cannot read file:\n " + file.toString() + "\n");
            } else if (!file.canWrite()) {
                System.out.println("Cannot write file:\n " + file.toString() + "\n");
            }
            String string2 = "";
            StringBuffer stringBuffer = new StringBuffer("");
            do {
                if ((string2 = bufferedReader.readLine()) == null || string2.equals("")) {
                    if (c == '\u0001') {
                        stringBuffer.append(this.PATH_TO_MINION + string + "\n");
                        continue;
                    }
                    if (c != '\u0002') continue;
                    stringBuffer.append(this.PATH_TO_GECODE + string + "\n");
                    continue;
                }
                if (string2.startsWith(this.PATH_TO_GECODE) && c == '\u0002') {
                    stringBuffer.append(this.PATH_TO_GECODE + string + "\n");
                    continue;
                }
                if (string2.startsWith(this.PATH_TO_MINION) && c == '\u0001') {
                    stringBuffer.append(this.PATH_TO_MINION + string + "\n");
                    continue;
                }
                stringBuffer.append(string2 + "\n");
            } while (string2 != null && !string2.equalsIgnoreCase("null"));
            bufferedReader.close();
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(stringBuffer.toString());
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.out.println("Cannot write new path into settings file '" + this.settingsFileName + "'.\n");
            System.exit(1);
        }
    }

    public TargetSolver getTargetSolver() {
        return this.targetSolver;
    }

    public String getEssencePrimeOutputFileName() {
        return this.essenceP_outputFileName;
    }

    public boolean useCommonSubExpressions() {
        return this.useCommonSubExpressions;
    }

    public boolean useExplicitCommonSubExpressions() {
        return this.useExplicitCommonSubExpressions;
    }

    public boolean useEqualCommonSubExpressions() {
        return this.useEqualSubExpressions;
    }

    public boolean giveTranslationTimeInfo() {
        return this.giveTranslationTimeInfo;
    }

    public boolean giveTranslationInfo() {
        return this.giveTranslationInfo;
    }

    public boolean applyDirectVariableReusage() {
        return this.applyDirectVariableReusage;
    }

    public void setTargetSolver(TargetSolver targetSolver) {
        this.targetSolver = targetSolver;
        if (targetSolver instanceof Gecode) {
            if (!this.getGenerateFlatzincOutput()) {
                this.isClassLevelTransformation = true;
            }
        } else if (targetSolver instanceof Minion && !this.flattenProblemClassOnly) {
            this.isClassLevelTransformation = false;
        }
    }

    public void setUseCommonSubExpressions(boolean bl) {
        this.useCommonSubExpressions = bl;
    }

    public void setUseExplicitCommonSubExpressions(boolean bl) {
        this.useExplicitCommonSubExpressions = bl;
    }

    public void setUseInferredCommonSubExpressions(boolean bl) {
        this.useEqualSubExpressions = bl;
    }

    public void setGiveTranslationTimeInfo(boolean bl) {
        this.giveTranslationTimeInfo = bl;
    }

    public void setApplyDirectVariableReusage(boolean bl) {
        this.applyDirectVariableReusage = bl;
    }

    public String getPathToMinion() {
        return this.pathToMinion;
    }

    public String getPathToFz() {
        return this.pathToFz;
    }

    public void setPathToMinion(String string) {
        this.pathToMinion = string;
        this.writeNewPath(string, '\u0001');
    }

    public String getPathToGecode() {
        return this.pathToGecodeDirectory;
    }

    public void setPathToGecode(String string) {
        this.pathToGecodeDirectory = string;
        this.writeNewPath(string, '\u0002');
    }

    public boolean applyStrictCopyPropagation() {
        return this.applyStrictCopyPropagation;
    }

    public void setApplyStrictCopyPropagation(boolean bl) {
        this.applyStrictCopyPropagation = bl;
    }

    public void setPrintedVariables(String[] stringArray) {
        this.printedVariables = stringArray;
    }

    public String[] getPrintedVariables() {
        return this.printedVariables;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String string) {
        this.modelName = string;
    }

    public boolean getPrintTranslationTimeIntoFile() {
        return this.writeTimeInfoIntoFile;
    }

    public void setPrintTranslationTimeIntoFile(boolean bl) {
        this.writeTimeInfoIntoFile = bl;
    }

    public boolean getWriteEssencePrimeModelIntoFile() {
        return this.writeEssencePIntoFile;
    }

    public void setWriteEssencePrimeModelIntoFile(boolean bl) {
        this.writeEssencePIntoFile = bl;
    }

    public boolean getPropagateSingleIntRanges() {
        return this.propagateSingleIntRanges;
    }

    public void setPropagateSingleIntRanges(boolean bl) {
        this.propagateSingleIntRanges = bl;
    }

    public int getDiscreteUpperBound() {
        return this.discreteUpperBound;
    }

    public void setDiscreteUpperBound(int n) {
        if (n < 0) {
            this.discreteUpperBound = -n;
        }
        this.discreteUpperBound = n;
    }

    public void setSolverInputFileName(String string) {
        this.solverInputFileName = string;
    }

    public String getSolverInputFileName() {
        return this.solverInputFileName;
    }

    public void setAllowParseErrorRecovery(boolean bl) {
        this.allowParseErrorRecovery = bl;
    }

    public boolean getAllowParseErrorRecovery() {
        return this.allowParseErrorRecovery;
    }

    public void setNoOfSolutions(int n) {
        this.noOfSolutions = n;
    }

    public int getNoOfSolutions() {
        return this.noOfSolutions;
    }

    public int getFindAllSolutionsAlias() {
        return this.FIND_ALL_SOLUTIONS;
    }

    public String getVarBranching() {
        return this.variableBranching;
    }

    public String getValBranching() {
        return this.valueBranching;
    }

    public void setVarBranching(String string) {
        if (this.targetSolver.supportsVarBranchingStrategy(string)) {
            this.variableBranching = string;
        }
    }

    public void setValBranching(String string) {
        if (this.targetSolver.supportsValBranchingStrategy(string)) {
            this.valueBranching = string;
        }
    }

    public boolean getBranchOverAuxVariables() {
        return this.branchOverAuxVariables;
    }

    public void setBranchOverAuxVariables(boolean bl) {
        this.branchOverAuxVariables = bl;
    }

    public boolean getUseGecodeLinearMinimodelPostConstraints() {
        return this.useGecodeLinearMiniModelPost;
    }

    public void setUseGecodeLinearMinimodelPostConstraints(boolean bl) {
        this.useGecodeLinearMiniModelPost = bl;
    }

    public boolean getUseGecodeBooleanMinimodelPostConstraints() {
        return this.useGecodeBooleanMiniModelPost;
    }

    public void setUseGecodeBooleanMinimodelPostConstraints(boolean bl) {
        this.useGecodeBooleanMiniModelPost = bl;
    }

    public boolean getCseDetails() {
        return this.cseDetails;
    }

    public void setCseDetails(boolean bl) {
        this.cseDetails = bl;
    }

    public boolean getAuxVarDetails() {
        return this.auxVarDetails;
    }

    public void setAuxVarDetails(boolean bl) {
        this.auxVarDetails = bl;
    }

    public boolean useCSEVarOrdering() {
        return this.cseVarOrdering;
    }

    public void setCSEVarOrdering(boolean bl) {
        this.cseVarOrdering = bl;
    }

    public boolean useMinionMinimumForConjunction() {
        return this.useMinionMinimumForConjunction;
    }

    public void setUseMinionMinimumForConjunction(boolean bl) {
        this.useMinionMinimumForConjunction = bl;
    }

    public boolean useMinionMaximumForDisjunction() {
        return this.useMinionMaximumForDisjunction;
    }

    public void setUseMinionMaximumForDisjunction(boolean bl) {
        this.useMinionMaximumForDisjunction = bl;
    }

    public boolean useMinionProductForConjunction() {
        return this.useMinionProductForConjunction;
    }

    public void setUseMinionProductForConjunction(boolean bl) {
        this.useMinionProductForConjunction = bl;
    }

    public boolean useNegatedCSEs() {
        return this.negatedCSEs;
    }

    public void setUseNegatedCSEs(boolean bl) {
        this.negatedCSEs = bl;
    }

    public boolean getUseSimpleDisjunctionCSE() {
        return this.simpleDisjunctionCSE;
    }

    public void setUseSimpleDisjunctionCSE(boolean bl) {
        this.simpleDisjunctionCSE = bl;
    }

    public boolean getUseSimpleConjunctionCSE() {
        return this.simpleConjunctionCSE;
    }

    public void setUseSimpleConjunctionCSE(boolean bl) {
        this.simpleConjunctionCSE = bl;
    }

    public void setUseMinionReifyImply(boolean bl) {
        this.useMinionReifyImply = bl;
    }

    public boolean getUseMinionReifyImply() {
        return this.useMinionReifyImply;
    }

    public void setIsClassLevelTransformation(boolean bl) {
        this.isClassLevelTransformation = bl;
    }

    public boolean isClassLevelTransformation() {
        return this.isClassLevelTransformation;
    }

    public void setMaxUpperBound(int n) {
        this.maxUpperBound = n;
    }

    public int getMaxUpperBound() {
        return this.maxUpperBound;
    }

    public void setMaxLowerBound(int n) {
        this.maxLowerBound = n;
    }

    public int getMaxLowerBound() {
        return this.maxLowerBound;
    }

    public void setUseEstimatedIntAuxiliaryBounds(boolean bl) {
        this.estimatedIntAuxiliaryBounds = bl;
    }

    public boolean useEstimatedIntAuxiliaryBounds() {
        return this.estimatedIntAuxiliaryBounds;
    }

    public void setFlattenProblemClassOnly(boolean bl) {
        this.flattenProblemClassOnly = bl;
        if (bl) {
            this.isClassLevelTransformation = true;
        }
    }

    public boolean flattenProblemClassOnly() {
        return this.flattenProblemClassOnly;
    }

    public void setNormaliseOnly(boolean bl) {
        this.normaliseProblemOnly = bl;
    }

    public boolean normaliseOnly() {
        return this.normaliseProblemOnly;
    }

    public boolean getGenerateFlatzincOutput() {
        return this.flatzincOutput;
    }

    public void setGenerateFlatzincOutput(boolean bl) {
        this.flatzincOutput = bl;
        if (this.flatzincOutput) {
            this.isClassLevelTransformation = false;
        }
    }

    public int getFlatZincArrayIndexStart() {
        return this.flatzincArrayIndexStart;
    }

    public String getTailorVersion() {
        return this.TAILOR_VERSION;
    }
}

