/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import translator.TranslationSettings;
import translator.Translator;
import translator.gui.TailorGUI;
import translator.solver.Gecode;
import translator.solver.Minion;
import translator.xcsp2ep.Xcsp2Ep;

public class Translate {
    public static final String GUI_NAME = "TAILOR v0.3.2";
    public static final String VERSION = "0.3.2";
    public static final String ESSENCE_PRIME_HEADER = "language ESSENCE' 1.b.a\n";
    public static final String ERROR = "ERROR:";
    public static final String XCSP_CONVERSION = "xcsp";
    public static final String MINION_TRANSLATION = "minion";
    public static final String GECODE_TRANSLATION = "gecode";
    public static final String HELP = "help";
    public static final String OLD_GUI = "oldgui";
    public static final String NO_COMMON_SUBEXPRS = "no-cse";
    public static final String NO_COMMON_EXPLICIT_SUBEXPRS = "no-ecse";
    public static final String TIME_OFF = "time";
    public static final String NO_INFO = "silent";
    public static final String NO_DIRECT_VAR_REUSE = "no-dvr";
    public static final String DIRECT_VAR_REUSE = "dvr";
    public static final String DEBUG_MODE = "debug";
    public static final String TIME_INFO_FILE = "tf";
    public static final String WRITE_EP_MODEL_TO_FILE = "out-ep";
    public static final String NO_PROPAGATE_SINGLE_DOMAINS = "no-sdp";
    public static final String DISCRETE_VAR_UPPER_BOUND = "discrete-ub";
    public static final String OUTPUT = "out";
    public static final String NO_OF_SOLUTIONS = "sols";
    public static final String CSE_DETAILS = "cse-info";
    public static final String AUX_VAR_DETAILS = "aux-info";
    public static final String CSE_VAR_ORDERING = "cse-ord-off";
    public static final String MINIMUM_CON = "conj-min";
    public static final String PRODUCT_CON = "conj-prod";
    public static final String MAXIMUM_DIS = "disj-max";
    public static final String NEGATED_CSES = "neg-cse";
    public static final String NO_SIMPLE_CONJ_CSE = "no-conj-cse";
    public static final String NO_SIMPLE_DISJ_CSE = "no-disj-cse";
    public static final String USE_REIFY_IMPLY = "reify-imp";
    public static final String PROBLEM_CLASS = "prb-class";
    public static final String FLATTEN_ONLY = "flat";
    public static final String NORMALISE_ONLY = "norm";
    public static final String FLATZINC = "fz";
    private static boolean giveTimeInfo = true;
    private static boolean giveTranslationInfo = true;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            Translate.runNewGUI();
        }
        TranslationSettings translationSettings = new TranslationSettings();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-")) {
                Object object;
                if (stringArray[i].equalsIgnoreCase("-help") || stringArray[i].equalsIgnoreCase("-h")) {
                    Translate.printWelcomeMessage();
                    Translate.printHelpMessage(translationSettings);
                    System.exit(0);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-no-cse")) {
                    translationSettings.setUseCommonSubExpressions(false);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-no-ecse")) {
                    translationSettings.setUseExplicitCommonSubExpressions(false);
                    translationSettings.useEqualSubExpressions = false;
                    translationSettings.useExplicitCommonSubExpressions = false;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-no-sdp")) {
                    translationSettings.setPropagateSingleIntRanges(false);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-out-ep")) {
                    translationSettings.setWriteEssencePrimeModelIntoFile(true);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-cse-info")) {
                    translationSettings.setCseDetails(true);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-fz")) {
                    translationSettings.setGenerateFlatzincOutput(true);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-aux-info")) {
                    translationSettings.setAuxVarDetails(true);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-reify-imp")) {
                    translationSettings.setUseMinionReifyImply(true);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-prb-class")) {
                    translationSettings.setIsClassLevelTransformation(true);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-norm")) {
                    translationSettings.setNormaliseOnly(true);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-neg-cse")) {
                    translationSettings.setUseNegatedCSEs(true);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-no-conj-cse")) {
                    translationSettings.setUseSimpleConjunctionCSE(false);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-no-disj-cse")) {
                    translationSettings.setUseSimpleDisjunctionCSE(false);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-conj-min")) {
                    translationSettings.setUseMinionMinimumForConjunction(true);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-conj-prod")) {
                    translationSettings.setUseMinionProductForConjunction(true);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-disj-max")) {
                    translationSettings.setUseMinionMaximumForDisjunction(true);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-cse-ord-off")) {
                    translationSettings.setCSEVarOrdering(false);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-flat")) {
                    translationSettings.setFlattenProblemClassOnly(true);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-time")) {
                    translationSettings.setGiveTranslationTimeInfo(true);
                    giveTimeInfo = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-out")) {
                    if (stringArray.length <= i + 1) {
                        Translate.printWelcomeMessage();
                        System.out.println("Sorry, could not read output filename for translation.");
                        System.exit(1);
                    }
                    translationSettings.setSolverInputFileName(stringArray[i + 1]);
                    ++i;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-tf")) {
                    translationSettings.setPrintTranslationTimeIntoFile(false);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-discrete-ub")) {
                    if (i + 1 >= stringArray.length) {
                        Translate.printWelcomeMessage();
                        System.out.println("Sorry, could not read upper bound for discrete variables.");
                        System.exit(1);
                    }
                    if ((Integer)(object = new Integer(stringArray[i + 1])) < 0) {
                        System.out.println("Sorry, cannot set a discrete upper bound that is smaller than zero:" + object + "\nUpper bound flag ignored.");
                    }
                    translationSettings.setDiscreteUpperBound((Integer)object);
                    ++i;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-sols")) {
                    if (i + 1 >= stringArray.length) {
                        Translate.printWelcomeMessage();
                        System.out.println("Sorry, could not read the number of solutions to search for.");
                        System.exit(1);
                    }
                    if ((Integer)(object = new Integer(stringArray[i + 1])) < 0) {
                        System.out.println("Sorry, cannot set the amount of solutions to an amount smaller than zero:" + object + "\n.To search for all solutions set the amount to '0'. Number of solutions flag ignored.");
                    }
                    translationSettings.setNoOfSolutions((Integer)object);
                    ++i;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-silent") || stringArray[i].equalsIgnoreCase("-s")) {
                    translationSettings.giveTranslationInfo = false;
                    translationSettings.giveTranslationTimeInfo = false;
                    giveTimeInfo = false;
                    giveTranslationInfo = false;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-no-dvr")) {
                    translationSettings.setApplyDirectVariableReusage(false);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-dvr")) {
                    translationSettings.setApplyDirectVariableReusage(true);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-gecode") || stringArray[i].equalsIgnoreCase("-g")) {
                    translationSettings.setTargetSolver(new Gecode(translationSettings));
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-minion") || stringArray[i].equalsIgnoreCase("-m")) {
                    translationSettings.setTargetSolver(new Minion(translationSettings));
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-debug")) {
                    translationSettings.debugMode = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-xcsp")) {
                    if (i + 1 == stringArray.length) {
                        System.out.println("No xml-input file specified...");
                        System.out.println("Aborting translation process.\n");
                        Translate.printHelpMessage(translationSettings);
                        System.exit(1);
                        continue;
                    }
                    if (i + 2 == stringArray.length) {
                        if (stringArray[i + 1].startsWith("-")) {
                            System.out.println("No xml-input file specified...");
                            System.out.println("Aborting translation process.\n");
                            Translate.printHelpMessage(translationSettings);
                            System.exit(1);
                        }
                        object = translationSettings.getSolverInputFileName() == null ? (translationSettings.getGenerateFlatzincOutput() ? stringArray[i + 1] + ".fz" : stringArray[i + 1] + "." + translationSettings.targetSolver.getSolverInputExtension()) : translationSettings.getSolverInputFileName();
                        Translate.translateXCSP(stringArray[i + 1], (String)object, translationSettings);
                        System.exit(0);
                        continue;
                    }
                    if (i + 3 == stringArray.length) {
                        if (stringArray[i + 1].startsWith("-") || stringArray[i + 2].startsWith("-")) {
                            Translate.printWelcomeMessage();
                            System.out.println("No xml-input file specified...");
                            System.out.println("Aborting translation process.\n");
                            System.exit(1);
                        }
                        Translate.translateXCSP(stringArray[i + 1], stringArray[i + 2], translationSettings);
                        System.exit(0);
                        continue;
                    }
                    Translate.printWelcomeMessage();
                    System.out.println("Too many input files specified for XCSP translation...");
                    System.out.println("Trying to translate '" + stringArray[i + 1] + " as XCSP input file and '" + stringArray[i + 2] + "' as Minion output file.");
                    Translate.translateXCSP(stringArray[i + 1], stringArray[i + 2], translationSettings);
                    System.exit(0);
                    continue;
                }
                Translate.printWelcomeMessage();
                System.out.println("Sorry, did not understand the flag '" + stringArray[i] + "'\n");
                System.exit(1);
                continue;
            }
            if (i + 1 == stringArray.length) {
                Translate.translate(stringArray[i], translationSettings);
                System.exit(0);
                continue;
            }
            if (i + 2 == stringArray.length) {
                Translate.translate(stringArray[i], stringArray[i + 1], translationSettings);
                System.exit(0);
                continue;
            }
            Translate.printWelcomeMessage();
            System.out.println("Too many input files specified for translation...");
            System.out.println("Trying to translate '" + stringArray[i + 1] + " as input file and '" + stringArray[i + 2] + "' as parameter file.");
            Translate.translateXCSP(stringArray[i], stringArray[i + 1], translationSettings);
            System.exit(1);
        }
    }

    private static void runNewGUI() {
        TailorGUI tailorGUI = new TailorGUI();
        tailorGUI.setVisible(true);
        tailorGUI.setExtendedState(6);
    }

    private static void translate(String string, TranslationSettings translationSettings) {
        try {
            if (translationSettings.giveTranslationInfo) {
                Translate.printWelcomeMessage();
            }
            translationSettings = Translate.readModelName(string, translationSettings);
            giveTimeInfo = translationSettings.giveTranslationTimeInfo;
            Translate.writeInfo("\nTranslating " + string);
            long l = System.currentTimeMillis();
            String string2 = Translate.readStringFromFile(string);
            Translator translator = new Translator(translationSettings);
            boolean bl = translator.tailorTo(string2, ESSENCE_PRIME_HEADER, translationSettings.targetSolver);
            if (!bl) {
                System.out.println("ERROR:Cannot translate to " + translationSettings.targetSolver.getSolverName() + " from problem file '" + string + "'.");
                System.out.println(translator.errorMessage);
                System.exit(1);
            }
            String string3 = null;
            string3 = translationSettings.flattenProblemClassOnly || translationSettings.normaliseProblemOnly ? translator.getFlattenedEssencePrimeModel() : translator.getTargetSolverInstance();
            long l2 = System.currentTimeMillis();
            double d = (double)(l2 - l) / 1000.0;
            if (translationSettings.getPrintTranslationTimeIntoFile()) {
                string3 = translationSettings.flattenProblemClassOnly || translationSettings.normaliseProblemOnly ? "$ Translation Time: " + d + "\n" + string3 : (translationSettings.getGenerateFlatzincOutput() ? "% Translation Time: " + d + "\n" + string3 : (translationSettings.targetSolver instanceof Minion ? "# Translation Time: " + d + "\n" + string3 : "/* Translation Time: " + d + "*/\n" + string3));
            }
            String string4 = translationSettings.getSolverInputFileName() == null ? (translationSettings.flattenProblemClassOnly ? string + ".flat" : (translationSettings.normaliseProblemOnly ? string + ".norm" : string + "." + translationSettings.targetSolver.getSolverInputExtension())) : translationSettings.getSolverInputFileName();
            File file = Translate.writeStringIntoFile(string4, string3);
            if (translationSettings.cseDetails) {
                Translate.writeStringIntoFile(string4 + ".cseinfo", translator.getCseInfo());
                System.out.println("Written CSE info into file: " + string4 + ".cseinfo");
            }
            if (translationSettings.flattenProblemClassOnly) {
                Translate.writeInfo("Tailored problem class '" + string + "' to " + translationSettings.targetSolver.getSolverName());
                Translate.writeInfo("and written flattened (and enhanced) Essence' model into:\n" + file.getAbsolutePath() + "\n");
                Translate.writeTimeInfo("Translation Time: " + d + " sec");
            } else if (translationSettings.normaliseProblemOnly) {
                Translate.writeInfo("Normalised problem class '" + string + "' to " + translationSettings.targetSolver.getSolverName());
                Translate.writeInfo("and written Essence' model into:\n" + file.getAbsolutePath() + "\n");
                Translate.writeTimeInfo("Translation Time: " + d + " sec");
            } else if (translationSettings.getGenerateFlatzincOutput()) {
                Translate.writeInfo("Translated '" + string + "' for solver " + translationSettings.targetSolver.getSolverName());
                Translate.writeInfo("into Flatzinc file:\n'" + file.getAbsolutePath() + "'\n");
                Translate.writeTimeInfo("Translation Time: " + d + " sec");
            } else {
                Translate.writeInfo("Translated '" + string + "' to " + translationSettings.targetSolver.getSolverName());
                Translate.writeInfo(" and written solver input\n into '" + file.getAbsolutePath() + "'.\n");
                Translate.writeTimeInfo("Translation Time: " + d + " sec");
            }
        }
        catch (Exception exception) {
            System.out.println(ERROR);
            if (translationSettings.debugMode) {
                exception.printStackTrace(System.out);
            } else {
                System.out.println(exception.getMessage());
            }
            System.out.println("Cannot translate to " + translationSettings.targetSolver.getSolverName() + " from problemfile:" + string);
            System.exit(1);
        }
    }

    private static void translate(String string, String string2, TranslationSettings translationSettings) {
        try {
            String string3;
            if (translationSettings.giveTranslationInfo) {
                Translate.printWelcomeMessage();
            }
            translationSettings = Translate.readModelName(string2, translationSettings);
            giveTimeInfo = translationSettings.giveTranslationTimeInfo;
            Translate.writeInfo("\nTranslating " + string + " with " + string2);
            long l = System.currentTimeMillis();
            String string4 = Translate.readStringFromFile(string);
            String string5 = Translate.readStringFromFile(string2);
            Translator translator = new Translator(translationSettings);
            boolean bl = translator.tailorTo(string4, string5, translationSettings.targetSolver);
            if (!bl) {
                System.out.println("ERROR:Cannot translate to " + translationSettings.targetSolver.getSolverName() + " from problem file '" + string + "' and parameter file '" + string2 + "'.");
                System.out.println(translator.errorMessage);
                System.exit(1);
            }
            String string6 = null;
            string6 = translationSettings.flattenProblemClassOnly || translationSettings.normaliseProblemOnly ? translator.getFlattenedEssencePrimeModel() : translator.getTargetSolverInstance();
            long l2 = System.currentTimeMillis();
            double d = (double)(l2 - l) / 1000.0;
            if (translationSettings.getPrintTranslationTimeIntoFile()) {
                string6 = translationSettings.flattenProblemClassOnly || translationSettings.normaliseProblemOnly ? "$ Translation Time: " + d + "\n" + string6 : (translationSettings.getGenerateFlatzincOutput() ? "% Translation Time: " + d + "\n" + string6 : (translationSettings.targetSolver instanceof Minion ? "# Translation Time: " + d + "\n" + string6 : "/* Translation Time: " + d + "*/\n" + string6));
            }
            if (translationSettings.getSolverInputFileName() == null) {
                if (translationSettings.flattenProblemClassOnly) {
                    string3 = new File(string2).getName() + ".flat.eprime";
                } else if (translationSettings.normaliseProblemOnly) {
                    string3 = new File(string2).getName() + ".norm.eprime";
                }
                string3 = new File(string2).getName() + "." + translationSettings.targetSolver.getSolverInputExtension();
            } else {
                string3 = translationSettings.getSolverInputFileName();
            }
            File file = Translate.writeStringIntoFile(string3, string6);
            if (translationSettings.cseDetails) {
                Translate.writeStringIntoFile(string3 + ".cseinfo", translator.getCseInfo());
                System.out.println("Written CSE info into file: " + string3 + ".cseinfo");
            }
            if (translationSettings.flattenProblemClassOnly) {
                Translate.writeInfo("Tailored '" + string + "' and '" + string2 + "' to " + translationSettings.targetSolver.getSolverName());
                Translate.writeInfo("and written flattened (and enhanced) Essence' model into:\n" + file.getAbsolutePath() + "\n");
                Translate.writeTimeInfo("Translation Time: " + d + " sec");
            } else if (translationSettings.normaliseProblemOnly) {
                Translate.writeInfo("Normalised '" + string + "' and '" + string2 + "' to " + translationSettings.targetSolver.getSolverName());
                Translate.writeInfo("and written Essence' model into:\n" + file.getAbsolutePath() + "\n");
                Translate.writeTimeInfo("Translation Time: " + d + " sec");
            } else {
                Translate.writeInfo("Translated '" + string + "' and '" + string2 + "' to " + translationSettings.targetSolver.getSolverName() + " and written solver-input\n into '" + file.getName() + "'.\n");
                Translate.writeTimeInfo("Translation Time: " + d + " sec");
            }
        }
        catch (Exception exception) {
            System.out.println(ERROR);
            if (translationSettings.debugMode) {
                exception.printStackTrace(System.out);
            } else {
                System.out.println(exception.getMessage());
            }
            System.out.println("ERROR:Cannot translate to " + translationSettings.targetSolver.getSolverName() + " from problem file '" + string + "' and parameter file '" + string2 + "'.");
            System.out.println(exception.getMessage());
            System.exit(1);
        }
    }

    private static void translateXCSP(String string, String string2, TranslationSettings translationSettings) {
        try {
            if (translationSettings.giveTranslationInfo) {
                Translate.printWelcomeMessage();
            }
            giveTimeInfo = translationSettings.giveTranslationTimeInfo;
            Translate.writeInfo("\nTranslating XCSP file '" + string + "'");
            long l = System.currentTimeMillis();
            Xcsp2Ep xcsp2Ep = new Xcsp2Ep(translationSettings);
            Translator translator = new Translator(translationSettings);
            boolean bl = translator.tailorTo(xcsp2Ep.translateToNormalisedModel(string), translationSettings.targetSolver);
            if (!bl) {
                System.out.println("ERROR:Cannot translate to " + translationSettings.targetSolver.getSolverName() + " from XCSP instance '" + string + "'.");
                System.out.println(translator.errorMessage);
                System.exit(1);
            }
            String string3 = null;
            string3 = translationSettings.flattenProblemClassOnly || translationSettings.normaliseProblemOnly ? translator.getFlattenedEssencePrimeModel() : translator.getTargetSolverInstance();
            long l2 = System.currentTimeMillis();
            double d = (double)(l2 - l) / 1000.0;
            if (translationSettings.getPrintTranslationTimeIntoFile()) {
                string3 = translationSettings.flattenProblemClassOnly || translationSettings.normaliseProblemOnly ? "$ Translation Time: " + d + "\n" + string3 : (translationSettings.getGenerateFlatzincOutput() ? "% Translation Time: " + d + "\n" + string3 : (translationSettings.targetSolver instanceof Minion ? "# Translation Time: " + d + "\n" + string3 : "// Translation Time: " + d + "\n" + string3));
            }
            File file = Translate.writeStringIntoFile(string2, string3);
            if (translationSettings.cseDetails) {
                Translate.writeStringIntoFile(string2 + ".cseinfo", translator.getCseInfo());
                System.out.println("Written CSE info into file: " + string2 + ".cseinfo");
            }
            if (translationSettings.flattenProblemClassOnly) {
                Translate.writeInfo("Tailored '" + string + "' to " + translationSettings.targetSolver.getSolverName());
                Translate.writeInfo("and written flattened (and enhanced) Essence' model into:\n" + file.getAbsolutePath() + "\n");
                Translate.writeTimeInfo("Translation Time: " + d + " sec");
            } else if (translationSettings.normaliseProblemOnly) {
                Translate.writeInfo("Normalised '" + string + "' to " + translationSettings.targetSolver.getSolverName());
                Translate.writeInfo("and written Essence' model into:\n" + file.getAbsolutePath() + "\n");
                Translate.writeTimeInfo("Translation Time: " + d + " sec");
            } else {
                Translate.writeInfo("Translated '" + string + "' to " + translationSettings.targetSolver.getSolverName() + " and written solver input\n into '" + file.getAbsolutePath() + "'.\n");
                Translate.writeTimeInfo("Translation Time: " + d + " sec");
            }
        }
        catch (Exception exception) {
            System.out.println(ERROR);
            if (translationSettings.debugMode) {
                exception.printStackTrace(System.out);
            } else {
                System.out.println(exception.getMessage());
            }
            System.out.println("ERROR:Cannot translate to " + translationSettings.targetSolver.getSolverName() + " from XCSP file '" + string);
            System.out.println(exception.getMessage());
            System.exit(1);
        }
    }

    private static void printHelpMessage(TranslationSettings translationSettings) {
        System.out.println("\nUsage: java -jar tailor.jar [flags] [inputfiles]");
        System.out.println("If no arguments are given, the graphical translator version will start.\n");
        System.out.println("Possible inputfiles are:");
        System.out.println("filename.eprime");
        System.out.println("\tEssence' problem specification: Translates 'filename.eprime' to Minion input format");
        System.out.println("\tThe generated Minion file is written into 'filename.eprime.minion'\n");
        System.out.println("filename.eprime filename.param\n\tEssence' problem and parameter specification:");
        System.out.println("\tTranslates 'filename.eprime' with respect to the parameters given in");
        System.out.println("\t'filename.param' to Minion input format.");
        System.out.println("\tThe generated Minion file is written into 'filename.param.minion'\n");
        System.out.println("-xcsp filename.xml");
        System.out.println("\tTranslates the XCSP file 'filename.xml' to Minion input format.");
        System.out.println("\tThe generated Minion file is written into 'filename.xml.minion'");
        System.out.println("\tPlease make sure that '-xcsp' is the last flag you set.\n");
        System.out.println("-xcsp input.xml output.minion");
        System.out.println("\tTranslates the XCSP file 'input.xml' to Minion input format.");
        System.out.println("\tThe generated Minion file is written into 'output.minion'");
        System.out.println("\tPlease make sure that '-xcsp' is the last flag you set.\n");
        System.out.println("\n\nGeneral flags:");
        System.out.println("-help or -h\n\tprints this help message");
        System.out.println("-minion or -m");
        System.out.println("\tTranslates input files to solver Minion (default).");
        System.out.println("-gecode or -g");
        System.out.println("\tTranslates input files to solver Gecode (not stable yet).");
        System.out.println("-fz");
        System.out.println("\tTranslate to FlatZinc (instances only!).");
        System.out.println("\tDefault: off");
        System.out.println("-out FILENAME");
        System.out.println("\tWrites solver input into FILENAME");
        System.out.println("\n\nTranslation flags:");
        System.out.println("-no-cse");
        System.out.println("\tTurn off eliminating common subexpressions during flattening.");
        System.out.println("\tDefault: on");
        System.out.println("-dvr");
        System.out.println("\tTurn on directly reusing variables (e.g. in x=y, replacing x with y).");
        System.out.println("\tDefault: off");
        System.out.println("-no-ecse");
        System.out.println("\tTurn off eliminating complex common subexpressions.");
        System.out.println("\tDefault: on");
        System.out.println("-neg-cse");
        System.out.println("\tMatch negated common subexpressions.");
        System.out.println("\tDefault: off");
        System.out.println("-cse-ord-off");
        System.out.println("\tPut auxiliary variables, that represent common subexpressions");
        System.out.println("\ton top of the auxiliary variable search hierarchy (i.e. branch on them first).");
        System.out.println("\tDefault: on.");
        System.out.println("-no-sdp");
        System.out.println("\tTurn off propagating single domains on constraints.");
        System.out.println("\t(for instance, if variable X ranges over (1..1) then replace every .");
        System.out.println("\toccurrence of X with 1).");
        System.out.println("\tDefault: on");
        System.out.println("-discrete-ub BOUND");
        System.out.println("\tSet the maximum domain size for which to use discrete variables,");
        System.out.println("\ti.e. if BOUND equals 300, every variable with a domain size smaller or ");
        System.out.println("\tequal 300 will be represented by a discrete variable");
        System.out.println("\t(allowing domain consistency)");
        System.out.println("\tDefault: " + translationSettings.getDiscreteUpperBound());
        System.out.println("-sols AMOUNT");
        System.out.println("\tSet the amount of solutions to search for in the target solver.");
        System.out.println("\tTo search for all solutions, set AMOUNT to '" + translationSettings.getFindAllSolutionsAlias() + "'.");
        System.out.println("\tDefault amount of solutions to search for: " + translationSettings.getNoOfSolutions());
        System.out.println("-conj-min");
        System.out.println("\tExpress conjunctions by minimum constraints instead of sum constraints");
        System.out.println("\tDefault: off");
        System.out.println("-conj-prod");
        System.out.println("\tExpress binary conjunctions by a product instead of a sum constraint");
        System.out.println("\tDefault: off");
        System.out.println("-disj-max");
        System.out.println("\tExpress disjunctions by maximum constraints instead of sum constraints");
        System.out.println("\tDefault: off");
        System.out.println("-reify-imp");
        System.out.println("\tExpress implications by Minion's reifyImply instead of breaking the constraint down.");
        System.out.println("\tDefault: off");
        System.out.println("-flat");
        System.out.println("\tOnly flatten the problem model to the specified solver. This option will only return");
        System.out.println("\ta flat Essence' file. Note that common subexpressions can be eliminated in this option.");
        System.out.println("\tDefault: off");
        System.out.println("-norm");
        System.out.print("\tOnly normalise the problem model. This option will return");
        System.out.println(" an Essence' file");
        System.out.println("\tDefault: off");
        System.out.println("\n\nOutput flags:");
        System.out.println("-time");
        System.out.println("\tDisplay time statistics");
        System.out.println("\tDefault: don't show time statistics");
        System.out.println("-silent");
        System.out.println("\tSilent mode. Don't give translation information.");
        System.out.println("\tDefault: give translation info");
        System.out.println("-debug");
        System.out.println("\tDebug mode. Prints stack trace when exception is thrown.");
        System.out.println("\tDefault: off.");
        System.out.println("-tf");
        System.out.println("\tDon't write translation time into the output file.");
        System.out.println("\tDefault: on.");
        System.out.println("-out-ep");
        System.out.println("\tWrite the generated Essence' model into a file.");
        System.out.println("\tDefault: off");
        System.out.println("-cse-info");
        System.out.println("\tGive detailed information about common subexpression elimination");
        System.out.println("\tDefault: off.");
        System.out.println("-aux-info");
        System.out.println("\tFor each auxiliary variable, write the expression it represents");
        System.out.println("\tnext to its definition in the solver input file");
        System.out.println("\tDefault: off.");
    }

    private static String readStringFromFile(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = bufferedReader.readLine();
        while (string2 != null && !string2.equalsIgnoreCase("null")) {
            stringBuffer.append(string2);
            stringBuffer.append("\n");
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    private static File writeStringIntoFile(String string, String string2) throws IOException {
        File file = new File(string);
        file.createNewFile();
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string2);
        fileWriter.flush();
        fileWriter.close();
        return file;
    }

    private static void printWelcomeMessage() {
        System.out.println("# Welcome to TAILOR v0.3.2");
        System.out.println("# Use flag -h for help. \n# Submit bug reports to: andrea@cs.st-and.ac.uk");
    }

    private static void writeInfo(String string) {
        if (giveTranslationInfo) {
            System.out.println(string);
        }
    }

    private static void writeTimeInfo(String string) {
        if (giveTimeInfo) {
            System.out.println(string);
        }
    }

    private static TranslationSettings readModelName(String string, TranslationSettings translationSettings) {
        int n = string.lastIndexOf(File.separatorChar);
        int n2 = string.lastIndexOf(46);
        translationSettings.setModelName(string.substring(n + 1, n2));
        return translationSettings;
    }
}

