IF (NOT CMAKE_FIND_LIBRARY_PREFIXES)
  SET (CMAKE_FIND_LIBRARY_PREFIXES "")
ENDIF (NOT CMAKE_FIND_LIBRARY_PREFIXES)

FIND_PATH(GMP_INCLUDE_DIR gmp.h $ENV{HOME}/.local/include)
FIND_PATH(GMPXX_INCLUDE_DIR gmpxx.h $ENV{HOME}/.local/include)

FIND_LIBRARY(GMP_LIBRARY NAMES gmp PATH $ENV{HOME}/.local/include)
FIND_LIBRARY(GMPXX_LIBRARY NAMES gmpxx PATH $ENV{HOME}/.local/include)

IF (GMP_INCLUDE_DIR AND GMP_LIBRARY AND GMPXX_INCLUDE_DIR AND GMPXX_LIBRARY)
   SET(GMP_FOUND TRUE)
ENDIF (GMP_INCLUDE_DIR AND GMP_LIBRARY AND GMPXX_INCLUDE_DIR AND GMPXX_LIBRARY)

IF (GMP_FOUND)
   IF (NOT GMP_FIND_QUIETLY)
      MESSAGE(STATUS "Found GMP: ${GMP_LIBRARY} and ${GMPXX_LIBRARY}")
   ENDIF (NOT GMP_FIND_QUIETLY)
ELSE (GMP_FOUND)
   IF (GMP_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could not find GMP or GMPXX")
   ENDIF (GMP_FIND_REQUIRED)
ENDIF (GMP_FOUND)
