/*
 * Decompiled with CFR 0.152.
 */
package parser.flatzinc;

import choco.cp.model.CPModel;
import java.io.File;
import java.util.HashMap;
import parser.flatzinc.reader.DataReader;
import parser.flatzinc.reader.ModelReader;

public class FlatZincModel {
    static boolean verb;
    static long[] time;

    public void generate(String[] args) throws Exception {
        File dataF;
        File modelF;
        HashMap<String, String> options = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i++];
            String val = args[i];
            options.put(arg, val);
        }
        if (options.containsKey("-mzn")) {
            modelF = new File((String)options.get("-mzn"));
            if (!modelF.exists()) {
                throw new Exception("Unknown mzn file");
            }
        } else {
            throw new Exception("file option -mzn is missing");
        }
        if (options.containsKey("-dzn")) {
            dataF = new File((String)options.get("-dzn"));
            if (!dataF.exists()) {
                throw new Exception("Unknown dzn file");
            }
        } else {
            throw new Exception("file option -dzn is missing");
        }
        if (options.containsKey("-verb")) {
            verb = Boolean.parseBoolean((String)options.get("-verb"));
        }
        try {
            this.solveFile(modelF, dataF);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void solveFile(File modelF, File dataF) {
        this.init();
        if (modelF.getName().endsWith(".mzn") && dataF.getName().endsWith(".dzn")) {
            try {
                CPModel model = this.loadAndParse(modelF, dataF);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
    }

    public void init() {
        time = new long[3];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPModel loadAndParse(File modelF, File dataF) throws Exception, Error {
        try {
            if (verb) {
                System.out.println("========================================================");
                System.out.println("Traitement de : " + modelF.getName());
                System.out.println("Donn\u00e9es : " + dataF.getName());
            }
            FlatZincModel.time[0] = System.currentTimeMillis();
            HashMap datas = DataReader.readDataFile(dataF.getAbsolutePath());
            CPModel model = ModelReader.readModelFile(modelF.getAbsolutePath(), datas);
            FlatZincModel.time[1] = System.currentTimeMillis();
            CPModel cPModel = model;
            return cPModel;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Error er) {
            er.printStackTrace();
        }
        finally {
            System.out.println("========================================================");
        }
        return null;
    }

    static {
        time = new long[3];
    }
}

