/*
 * Decompiled with CFR 0.152.
 */
package parser.chocogen;

import choco.cp.model.CPModel;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.integer.extension.ValidityChecker;
import choco.cp.solver.preprocessor.PreProcessCPSolver;
import choco.cp.solver.search.integer.valiterator.IncreasingDomain;
import choco.cp.solver.search.integer.varselector.DomOverDynDeg;
import choco.cp.solver.search.integer.varselector.MinDomain;
import choco.kernel.solver.Solver;
import java.io.File;
import java.util.HashMap;
import parser.absconparseur.tools.InstanceParser;
import parser.absconparseur.tools.SolutionChecker;
import parser.chocogen.ChocoFactory;

public class XmlModel {
    private static final int DOMOVERDEG = 0;
    private static final int DOMOVERWDEG = 1;
    private static final int IMPACT = 2;
    private static final int VERSATILE = 3;
    private static final int SIMPLE = 4;
    private static int heuristic = 0;
    private static int ac = 32;
    private static boolean singleton = false;
    private static Boolean forcerestart = null;
    private static int base = 10;
    private static double growth = 1.5;
    private static int verb = 0;
    private static int timelimit = 10000;
    public int initialisationtime = 60000;
    private Boolean isFeasible = null;
    private int cheuri;
    private int nbnode = 0;
    private int nbback = 0;
    private static long[] time = new long[4];
    private static String[] values;

    public static int getAcAlgo() {
        return ac;
    }

    public static boolean doSingleton() {
        return singleton;
    }

    public void init() {
        time = new long[4];
        this.isFeasible = null;
        this.nbback = 0;
        this.nbnode = 0;
    }

    public void generate(String[] args) throws Exception {
        File dossier;
        HashMap<String, String> options = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i++];
            String val = args[i];
            options.put(arg, val);
        }
        if (options.containsKey("-file")) {
            dossier = new File((String)options.get("-file"));
            if (!dossier.exists()) {
                throw new Exception("Unknown file or directory");
            }
        } else {
            throw new Exception("file option -file is missing");
        }
        if (!options.containsKey("-h")) {
            throw new Exception("heuristic option -h is missing");
        }
        heuristic = Integer.parseInt((String)options.get("-h"));
        if (!options.containsKey("-ac")) {
            throw new Exception("AC option -ac is missing");
        }
        ac = Integer.parseInt((String)options.get("-ac"));
        if (options.containsKey("-s")) {
            singleton = Boolean.parseBoolean((String)options.get("-s"));
        }
        if (options.containsKey("-time")) {
            timelimit = Integer.parseInt((String)options.get("-time"));
        }
        if (options.containsKey("-verb")) {
            verb = Integer.parseInt((String)options.get("-verb"));
        }
        if (options.containsKey("-rest")) {
            forcerestart = Boolean.parseBoolean((String)options.get("-rest"));
        }
        if (options.containsKey("-rb")) {
            base = Integer.parseInt((String)options.get("-rb"));
        }
        if (options.containsKey("-rg")) {
            growth = Double.parseDouble((String)options.get("-rg"));
        }
        if (options.containsKey("-saclim")) {
            this.initialisationtime = Integer.parseInt((String)options.get("-saclim")) * 1000;
        }
        try {
            if (dossier.isFile()) {
                this.solveFile(dossier);
            } else {
                this.solveDirectory(dossier);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void solveFile(File fichier) {
        this.init();
        if (fichier.getName().endsWith(".xml") || fichier.getName().endsWith(".xml.bz2")) {
            try {
                InstanceParser parser = this.load(fichier);
                CPModel model = this.buildModel(parser);
                PreProcessCPSolver s = this.solve(model);
                this.postAnalyze(fichier, parser, s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
    }

    public void solveDirectory(File dossiers) {
        File[] listingDonneesEntree = dossiers.listFiles();
        for (int file = 0; file < listingDonneesEntree.length; ++file) {
            File fichier = listingDonneesEntree[file];
            if (fichier.isFile()) {
                this.solveFile(fichier);
                continue;
            }
            if (!fichier.isDirectory()) continue;
            this.solveDirectory(fichier);
        }
    }

    public InstanceParser load(File fichier) throws Exception, Error {
        try {
            if (verb > 0) {
                System.out.println("========================================================");
                System.out.println("Traitement de :" + fichier.getName());
            }
            XmlModel.time[0] = System.currentTimeMillis();
            InstanceParser parser = new InstanceParser();
            parser.loadInstance(fichier.getAbsolutePath());
            parser.parse(false);
            XmlModel.time[1] = System.currentTimeMillis();
            return parser;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Error er) {
            er.printStackTrace();
        }
        return null;
    }

    public CPModel buildModel(InstanceParser parser) throws Exception, Error {
        boolean forceExp = false;
        CPModel m = new CPModel();
        ChocoFactory chocofact = new ChocoFactory(parser, m);
        chocofact.createVariables();
        chocofact.createRelations();
        chocofact.createConstraints(forceExp);
        return m;
    }

    public PreProcessCPSolver solve(CPModel model) throws Exception, Error {
        PreProcessCPSolver s = new PreProcessCPSolver();
        s.read(model);
        if (verb > 0) {
            System.out.print("solve...");
            System.out.println("dim:[nbv:" + s.getNbIntVars() + "][nbc:" + s.getNbIntConstraints() + "][nbconstants:" + s.getNbConstants() + "]");
        }
        XmlModel.time[2] = System.currentTimeMillis();
        s.setTimeLimit(timelimit * 1000);
        s.monitorBackTrackLimit(true);
        if (verb > 1) {
            System.out.println(s.pretty());
        }
        this.isFeasible = true;
        if (!s.initialPropagation()) {
            this.isFeasible = false;
        } else {
            this.cheuri = heuristic;
            switch (this.cheuri) {
                case 3: {
                    this.isFeasible = s.setVersatile(s, this.initialisationtime);
                    this.cheuri = s.getBBSearch().determineHeuristic(s);
                    break;
                }
                case 0: {
                    DomOverDynDeg dodd = new DomOverDynDeg(s);
                    s.setVarIntSelector(dodd);
                    s.setValIntIterator(new IncreasingDomain());
                    break;
                }
                case 1: {
                    this.isFeasible = s.setDomOverWeg(s, this.initialisationtime);
                    break;
                }
                case 2: {
                    this.isFeasible = s.setImpact(s, this.initialisationtime);
                    break;
                }
                case 4: {
                    s.setVarIntSelector(new MinDomain(s));
                    s.setValIntIterator(new IncreasingDomain());
                }
            }
        }
        if (forcerestart != null) {
            if (forcerestart.booleanValue()) {
                s.setGeometricRestart(base, growth);
            }
        } else if (s.restartMode) {
            s.setGeometricRestart(Math.min(Math.max(s.getNbIntVars(), 200), 400), 1.4);
        }
        CPSolver.setVerbosity(0);
        if (this.isFeasible.booleanValue() && (this.cheuri == 2 || s.rootNodeSingleton(this.initialisationtime))) {
            s.solve();
            this.isFeasible = s.isFeasible();
            this.nbnode = s.getSearchStrategy().getNodeCount();
            this.nbback = s.getBackTrackCount();
        } else {
            this.isFeasible = false;
        }
        return s;
    }

    public void postAnalyze(File fichier, InstanceParser parser, PreProcessCPSolver s) throws Exception, Error {
        XmlModel.time[3] = System.currentTimeMillis();
        if (this.isFeasible == Boolean.TRUE && !this.checkEverythingIsInstantiated(parser, s)) {
            this.isFeasible = null;
        }
        values = new String[parser.getVariables().length + 1];
        String res = "c ";
        if (this.isFeasible == null) {
            res = res + "TIMEOUT";
            System.out.println("s UNKNOWN");
        } else if (!this.isFeasible.booleanValue()) {
            res = res + "UNSAT";
            System.out.println("s UNSATISFIABLE");
        } else {
            res = res + "SAT";
            System.out.println("s SATISFIABLE");
            String sol = "v ";
            XmlModel.values[0] = fichier.getPath();
            for (int i = 0; i < parser.getVariables().length; ++i) {
                try {
                    XmlModel.values[i + 1] = "" + s.getVar(parser.getVariables()[i].getChocovar()).getVal();
                }
                catch (NullPointerException e) {
                    XmlModel.values[i + 1] = "" + parser.getVariables()[i].getChocovar().getLowB();
                }
                sol = sol + values[i + 1] + " ";
            }
            System.out.println(sol);
        }
        double rtime = (double)(time[3] - time[0]) / 1000.0;
        res = res + " " + rtime + " TIME     ";
        res = res + " " + this.nbnode + " NDS   ";
        res = res + " " + (time[1] - time[0]) + " PARSTIME     ";
        res = res + " " + (time[2] - time[1]) + " BUILDPB      ";
        res = res + " " + (time[3] - time[2]) + " RES      ";
        res = res + " " + s.restartMode + " RESTART      ";
        res = res + " " + this.cheuri + " HEURISTIC      ";
        System.out.println("d AC " + ac);
        System.out.println("d RUNTIME " + rtime);
        System.out.println("d NODES " + this.nbnode);
        System.out.println("d NODES/s " + Math.round((double)this.nbnode / rtime));
        System.out.println("d BACKTRACKS " + this.nbback);
        System.out.println("d BACKTRACKS/s " + Math.round((double)this.nbback / rtime));
        System.out.println("d CHECKS " + ValidityChecker.nbCheck);
        System.out.println("d CHECKS/s " + Math.round((double)ValidityChecker.nbCheck / rtime));
        ValidityChecker.nbCheck = 0;
        System.out.println("" + res);
        if (verb > 0 && s.isFeasible() == Boolean.TRUE) {
            SolutionChecker.main(values);
        }
    }

    public long getParseTime() {
        return time[1] - time[0];
    }

    public long getBuildTime() {
        return time[2] - time[1];
    }

    public long getResTime() {
        return time[3] - time[2];
    }

    public long getFullTime() {
        return time[3] - time[0];
    }

    public int getNbNodes() {
        return this.nbnode;
    }

    public Boolean isFeasible() {
        return this.isFeasible;
    }

    public String[] getValues() {
        return values;
    }

    public boolean checkEverythingIsInstantiated(InstanceParser parser, Solver s) {
        for (int i = 0; i < parser.getVariables().length; ++i) {
            try {
                if (s.getVar(parser.getVariables()[i].getChocovar()).isInstantiated()) continue;
                return false;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        return true;
    }

    public static void example() {
        String fichier = "../../ProblemsData/CSPCompet/intension/nonregres/graph1.xml";
        File instance = new File(fichier);
        XmlModel xs = new XmlModel();
        try {
            InstanceParser parser = xs.load(instance);
            CPModel model = xs.buildModel(parser);
            PreProcessCPSolver s = xs.solve(model);
            xs.postAnalyze(instance, parser, s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        XmlModel xs = new XmlModel();
        xs.generate(args);
    }
}

