/*
 * Decompiled with CFR 0.152.
 */
package parser.chocogen;

import choco.Choco;
import choco.kernel.model.Model;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import parser.absconparseur.components.PConstraint;
import parser.absconparseur.components.PExtensionConstraint;
import parser.absconparseur.components.PVariable;
import parser.absconparseur.tools.InstanceParser;
import parser.chocogen.ObjectFactory;

public class VariableFactory
extends ObjectFactory {
    public VariableFactory(Model m, InstanceParser parser) {
        super(m, parser);
    }

    public IntegerVariable makeVariable(PVariable pvar) {
        IntegerVariable var;
        if (pvar.getChocovar() == null) {
            var = this.createVar(pvar);
            pvar.setChocovar(var);
        } else {
            var = pvar.getChocovar();
        }
        return var;
    }

    public IntegerVariable createVar(PVariable pvar) {
        IntegerVariable var;
        int nbvalues = pvar.getDomain().getValues().length;
        int span = pvar.getDomain().getMaxValue() - pvar.getDomain().getMinValue() + 1;
        if (span > nbvalues || nbvalues < 300) {
            var = Choco.makeIntVar(pvar.getName(), pvar.getDomain().getValues(), new String[0]);
            if (this.isVarOnlyInvolvedInExtConstraint(pvar) || 20 * span > 100 * nbvalues) {
                this.m.addVariable("cp:blist", (Variable)var);
            } else {
                this.m.addVariable("cp:enum", (Variable)var);
            }
        } else if (this.isVarOnlyInvolvedInExtConstraint(pvar)) {
            var = Choco.makeIntVar(pvar.getName(), pvar.getDomain().getMinValue(), pvar.getDomain().getMaxValue(), new String[0]);
            this.m.addVariable("cp:blist", (Variable)var);
        } else {
            var = Choco.makeIntVar(pvar.getName(), pvar.getDomain().getMinValue(), pvar.getDomain().getMaxValue(), new String[0]);
            this.m.addVariable("cp:bound", (Variable)var);
        }
        return var;
    }

    public boolean isVarOnlyInvolvedInExtConstraint(PVariable pvar) {
        if (this.parser.getNbExtensionConstraints() != 0) {
            for (PConstraint pc : this.parser.getMapOfConstraints().values()) {
                if (!(pc instanceof PExtensionConstraint)) continue;
                PVariable[] scope = pc.getScope();
                for (int i = 0; i < scope.length; ++i) {
                    if (scope[i] != pvar) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public int getNbvar() {
        return this.parser.getNbVariables();
    }
}

