/*
 * Decompiled with CFR 0.152.
 */
package parser.chocogen;

import choco.Choco;
import choco.kernel.model.Model;
import choco.kernel.model.constraints.automaton.DFA;
import choco.kernel.solver.constraints.integer.extension.BinRelation;
import choco.kernel.solver.constraints.integer.extension.LargeRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import parser.absconparseur.components.PConstraint;
import parser.absconparseur.components.PDomain;
import parser.absconparseur.components.PExtensionConstraint;
import parser.absconparseur.components.PRelation;
import parser.absconparseur.components.PVariable;
import parser.absconparseur.tools.InstanceParser;
import parser.chocogen.ModelConstraintFactory;
import parser.chocogen.ObjectFactory;
import parser.chocogen.XmlClause;
import parser.chocogen.XmlModel;

public class RelationFactory
extends ObjectFactory {
    HashMap<PRelation, List<PExtensionConstraint>> extlist;

    public RelationFactory(Model model, InstanceParser parser) {
        super(model, parser);
        this.initializeExtList();
    }

    public void initializeExtList() {
        this.extlist = new HashMap();
        for (PConstraint p : this.parser.getMapOfConstraints().values()) {
            if (!(p instanceof PExtensionConstraint)) continue;
            PExtensionConstraint p1 = (PExtensionConstraint)p;
            List<PExtensionConstraint> lcts = this.extlist.get(p1.getRelation());
            if (lcts == null) {
                lcts = new LinkedList<PExtensionConstraint>();
                this.extlist.put(p1.getRelation(), lcts);
            }
            lcts.add(p1);
        }
    }

    public DFA makeDFA(PRelation prel) {
        DFA dfa = null;
        if (prel.getSemantics().equals("supports")) {
            dfa = new DFA(prel.getListTuples());
        }
        return dfa;
    }

    public LargeRelation makeLargeRelation(PRelation prel) {
        LargeRelation rel = null;
        int[] min = this.getMin(prel);
        int[] max = this.getMax(prel);
        if (prel.getSemantics().equals("supports")) {
            double matrixsize = this.getCartesianProduct(prel);
            double nbt = prel.getNbTuples();
            double tightness = 1.0 - nbt / matrixsize;
            rel = matrixsize >= 3.2E7 || tightness >= 0.98 ? Choco.makeLargeRelation(min, max, prel.getListTuples(), true, XmlModel.getAcAlgo() == 2008 ? 2 : 0) : Choco.makeLargeRelation(min, max, prel.getListTuples(), true, XmlModel.getAcAlgo() == 2008 ? 2 : 1);
        } else {
            rel = Choco.makeLargeRelation(min, max, prel.getListTuples(), false);
        }
        return rel;
    }

    public BinRelation makeBinRelation(PRelation prel) {
        BinRelation brel = null;
        int[] min = this.getMin(prel);
        int[] max = this.getMax(prel);
        if (prel.getSemantics().equals("supports")) {
            brel = Choco.makeBinRelation(min, max, prel.getListTuples(), true, true);
            if (prel.checkEqInCouples()) {
                prel.setEqInTuples(true);
                prel.setNeqInTuples(false);
            } else if (prel.checkNeqInCouples()) {
                prel.setNeqInTuples(true);
                prel.setEqInTuples(false);
            }
            prel.eraseListTuple();
        } else {
            brel = Choco.makeBinRelation(min, max, prel.getListTuples(), false, true);
            if (prel.checkEqInCouples()) {
                prel.setEqInTuples(true);
                prel.setNeqInTuples(false);
            } else if (prel.checkNeqInCouples()) {
                prel.setNeqInTuples(true);
                prel.setEqInTuples(false);
            }
            prel.eraseListTuple();
        }
        return brel;
    }

    public boolean isSatDecomposable(PRelation prel) {
        if (this.isAllBoolean(prel) && prel.getArity() <= 10) {
            double cp = this.getCartesianProduct(prel);
            int nbsupports = prel.getNbTuples();
            if (prel.getSemantics().equals("supports")) {
                return cp - (double)nbsupports < 5.0;
            }
            return nbsupports < 5;
        }
        return false;
    }

    public int getVal(int[] bint) {
        int val = 0;
        for (int i = 0; i < bint.length; ++i) {
            val = (int)((double)val + (double)bint[i] * Math.pow(2.0, i));
        }
        return val;
    }

    public int[] getTuple(int val, int arity) {
        int[] t = new int[arity];
        for (int i = 0; i < arity; ++i) {
            if ((val & 1 << i) == 0) continue;
            t[i] = 1;
        }
        return t;
    }

    public void makeClausesEncoding(PRelation prel) {
        ArrayList<XmlClause> enc = new ArrayList<XmlClause>();
        if (prel.getSemantics().equals("conflicts")) {
            List<int[]> ltuples = prel.getListTuples();
            for (int[] cl : ltuples) {
                enc.add(this.makeClause(cl, 0));
            }
        } else {
            List<int[]> ltuples = prel.getListTuples();
            LinkedList<int[]> conflict = new LinkedList<int[]>();
            BitSet validTuple = new BitSet();
            for (int[] cl : ltuples) {
                validTuple.set(this.getVal(cl));
            }
            int cartp = (int)Math.pow(2.0, prel.getArity());
            for (int i = 0; i < cartp; ++i) {
                if (validTuple.get(i)) continue;
                conflict.add(this.getTuple(i, prel.getArity()));
            }
            for (int[] cl : conflict) {
                enc.add(this.makeClause(cl, 0));
            }
        }
        prel.setClauseEncoding(enc);
    }

    public XmlClause makeClause(int[] cl, int valtest) {
        int nbposv = 0;
        int nbnegv = 0;
        for (int i = 0; i < cl.length; ++i) {
            if (cl[i] == valtest) {
                ++nbposv;
                continue;
            }
            ++nbnegv;
        }
        int[] poslit = new int[nbposv];
        int[] neglit = new int[nbnegv];
        int cpt1 = 0;
        int cpt2 = 0;
        for (int i = 0; i < cl.length; ++i) {
            if (cl[i] == valtest) {
                poslit[cpt1] = i;
                ++cpt1;
                continue;
            }
            neglit[cpt2] = i;
            ++cpt2;
        }
        return new XmlClause(poslit, neglit);
    }

    public double getCartesianProduct(PRelation prel) {
        double cartprod = 1.0;
        int[] nbvalues = new int[prel.getArity()];
        for (PExtensionConstraint ct : this.extlist.get(prel)) {
            PVariable[] vs = ct.getScope();
            for (int i = 0; i < vs.length; ++i) {
                nbvalues[i] = Math.max(vs[i].getDomain().getNbValues(), nbvalues[i]);
            }
        }
        for (int i = 0; i < nbvalues.length; ++i) {
            cartprod *= (double)nbvalues[i];
        }
        return cartprod;
    }

    public boolean isAllBoolean(PRelation prel) {
        for (PExtensionConstraint ct : this.extlist.get(prel)) {
            PVariable[] vs = ct.getScope();
            for (int i = 0; i < vs.length; ++i) {
                if (vs[i].getDomain().getMinValue() >= 0 && vs[i].getDomain().getMaxValue() <= 1) continue;
                return false;
            }
        }
        return true;
    }

    public int[] getMin(PRelation prel) {
        int[] min = new int[prel.getArity()];
        Arrays.fill(min, Integer.MAX_VALUE);
        for (PExtensionConstraint ct : this.extlist.get(prel)) {
            PVariable[] vs = ct.getScope();
            for (int i = 0; i < vs.length; ++i) {
                PVariable v = vs[i];
                if (v.getDomain().getMinValue() >= min[i]) continue;
                min[i] = v.getDomain().getMinValue();
            }
        }
        return min;
    }

    public int[] getMax(PRelation prel) {
        int[] max = new int[prel.getArity()];
        Arrays.fill(max, Integer.MIN_VALUE);
        for (PExtensionConstraint ct : this.extlist.get(prel)) {
            if (ct.getRelation() != prel) continue;
            PVariable[] vs = ct.getScope();
            for (int i = 0; i < vs.length; ++i) {
                PVariable v = vs[i];
                if (v.getDomain().getMaxValue() <= max[i]) continue;
                max[i] = v.getDomain().getMaxValue();
            }
        }
        return max;
    }

    public boolean detectIntensionConstraint(PExtensionConstraint pec) {
        assert (pec.getArity() == 2);
        PRelation brel = pec.getRelation();
        PDomain[] doms = new PDomain[]{pec.getScope()[0].getDomain(), pec.getScope()[1].getDomain()};
        for (int i = 0; i < 2; ++i) {
            if (i == 0) {
                if (!this.checkEqInCouples(brel, doms)) continue;
                if (brel.getSemantics().equals("supports")) {
                    pec.setIntensionCts(ModelConstraintFactory.ConstExp.eq);
                } else {
                    pec.setIntensionCts(ModelConstraintFactory.ConstExp.ne);
                }
                return true;
            }
            if (i != 1 || !this.checkNeqInCouples(brel, doms)) continue;
            if (brel.getSemantics().equals("supports")) {
                pec.setIntensionCts(ModelConstraintFactory.ConstExp.ne);
            } else {
                pec.setIntensionCts(ModelConstraintFactory.ConstExp.eq);
            }
            return true;
        }
        return false;
    }

    public boolean checkEqInCouples(PRelation brel, PDomain[] pdom) {
        if (brel.isEqInTuples() && pdom[0].getNbValues() < 5000 && pdom[1].getNbValues() < 5000) {
            int scard = pdom[0].getIntersectionSize(pdom[1]);
            return scard == brel.getNbTuples();
        }
        return false;
    }

    public boolean checkNeqInCouples(PRelation brel, PDomain[] pdom) {
        if (brel.isNeqInTuples() && pdom[0].getNbValues() < 5000 && pdom[1].getNbValues() < 5000) {
            int inter = pdom[0].getIntersectionSize(pdom[1]);
            if (inter != -1) {
                int scard = pdom[0].getNbValues() * pdom[1].getNbValues() - inter;
                return scard == brel.getNbTuples();
            }
            return false;
        }
        return false;
    }
}

