/*
 * Decompiled with CFR 0.152.
 */
package parser.chocogen;

import choco.Choco;
import choco.kernel.model.Model;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.scheduling.TaskVariable;
import parser.absconparseur.components.PAllDifferent;
import parser.absconparseur.components.PCumulative;
import parser.absconparseur.components.PElement;
import parser.absconparseur.components.PGlobalConstraint;
import parser.absconparseur.components.PVariable;
import parser.absconparseur.components.PWeightedSum;
import parser.absconparseur.tools.InstanceParser;
import parser.chocogen.ChocoFactory;
import parser.chocogen.ObjectFactory;

public class GloConstraintFactory
extends ObjectFactory {
    public GloConstraintFactory(Model m, InstanceParser parser) {
        super(m, parser);
    }

    public static Constraint buildAllDiff(IntegerVariable[] vars) {
        int maxdszise = 0;
        boolean holes = false;
        int nbnoninstvar = 0;
        for (int i = 0; i < vars.length; ++i) {
            int span = vars[i].getUppB() - vars[i].getLowB() + 1;
            if (vars[i].getDomainSize() > maxdszise) {
                maxdszise = vars[i].getDomainSize();
            }
            if (vars[i].getDomainSize() > 1) {
                ++nbnoninstvar;
            }
            if (!(ChocoFactory.ratioHole * (float)span > (float)vars[i].getDomainSize())) continue;
            holes = true;
        }
        if (vars.length <= 3) {
            return Choco.allDifferent("cp:clique", vars);
        }
        if (holes || maxdszise <= 30 && (vars.length <= 10 || nbnoninstvar < vars.length && nbnoninstvar < 20)) {
            return Choco.allDifferent("cp:ac", vars);
        }
        return Choco.allDifferent("cp:bc", vars);
    }

    public Constraint[] makeGlobalConstraint(PGlobalConstraint pgc) {
        if (pgc instanceof PAllDifferent) {
            PAllDifferent pa = (PAllDifferent)pgc;
            IntegerVariable[] vars = new IntegerVariable[pa.getScope().length];
            for (int i = 0; i < pa.getScope().length; ++i) {
                vars[i] = pa.getScope()[i].getChocovar();
            }
            return new Constraint[]{GloConstraintFactory.buildAllDiff(vars)};
        }
        if (pgc instanceof PCumulative) {
            PCumulative pc = (PCumulative)pgc;
            int n = pc.getTasks().length;
            if (pc.getLimit() == 1) {
                TaskVariable[] tasks = new TaskVariable[n];
                for (int i = 0; i < n; ++i) {
                    PCumulative.Task t = pc.getTasks()[i];
                    IntegerVariable start = ((PVariable)t.getOrigin()).getChocovar();
                    int duration = (Integer)t.getDuration();
                    IntegerVariable end = t.getEnd() == null ? Choco.makeIntVar("end_" + i, start.getLowB() + (Integer)t.getDuration(), start.getUppB() + (Integer)t.getDuration(), new String[0]) : ((PVariable)t.getEnd()).getChocovar();
                    tasks[i] = new TaskVariable("t", start, end, Choco.constant(duration));
                }
                return new Constraint[]{Choco.disjunctive(tasks, new String[0])};
            }
            TaskVariable[] taskvars = new TaskVariable[n];
            int[] heights = new int[n];
            for (int i = 0; i < n; ++i) {
                PCumulative.Task t = pc.getTasks()[i];
                IntegerVariable start = ((PVariable)t.getOrigin()).getChocovar();
                IntegerConstantVariable duration = Choco.constant("dur_" + i, (int)((Integer)t.getDuration()));
                heights[i] = (Integer)t.getHeight();
                IntegerVariable end = t.getEnd() == null ? Choco.makeIntVar("end_" + i, start.getLowB() + (Integer)t.getDuration(), start.getUppB() + (Integer)t.getDuration(), new String[0]) : ((PVariable)t.getEnd()).getChocovar();
                taskvars[i] = new TaskVariable("", start, end, duration);
            }
            return new Constraint[]{Choco.cumulativeMax(taskvars, heights, pc.getLimit(), new String[0])};
        }
        if (pgc instanceof PElement) {
            PElement pe = (PElement)pgc;
            IntegerVariable v = null;
            if (pe.getValue() instanceof PVariable) {
                v = ((PVariable)pe.getValue()).getChocovar();
            } else if (pe.getValue() instanceof Integer) {
                v = Choco.makeIntVar("value", (Integer)pe.getValue(), (Integer)pe.getValue(), new String[0]);
                this.m.addVariable("cp:bound", (Variable)v);
            }
            if (pe.getTable().length > 0 && pe.getTable()[0] instanceof PVariable) {
                IntegerVariable[] vars = new IntegerVariable[pe.getTable().length];
                for (int i = 0; i < vars.length; ++i) {
                    vars[i] = ((PVariable)pe.getTable()[i]).getChocovar();
                }
                int offset = -1;
                return new Constraint[]{Choco.nth(pe.getIndex().getChocovar(), vars, v, offset)};
            }
            if (pe.getTable().length > 0 && pe.getTable()[0] instanceof Integer) {
                int[] vars = new int[pe.getTable().length];
                for (int i = 0; i < vars.length; ++i) {
                    vars[i] = (Integer)pe.getTable()[i];
                }
                int offset = -1;
                return new Constraint[]{Choco.nth(pe.getIndex().getChocovar(), vars, v, offset)};
            }
        }
        if (pgc instanceof PWeightedSum) {
            PWeightedSum pws = (PWeightedSum)pgc;
            int[] coef = pws.getCoeffs();
            IntegerVariable[] vars = new IntegerVariable[pws.getScope().length];
            for (int i = 0; i < pws.getScope().length; ++i) {
                vars[i] = pws.getScope()[i].getChocovar();
            }
            switch (pws.getOperator()) {
                case EQ: {
                    return new Constraint[]{Choco.eq(Choco.scalar(coef, vars), pws.getLimit())};
                }
                case GE: {
                    return new Constraint[]{Choco.geq(Choco.scalar(coef, vars), pws.getLimit())};
                }
                case GT: {
                    return new Constraint[]{Choco.gt(Choco.scalar(coef, vars), pws.getLimit())};
                }
                case LE: {
                    return new Constraint[]{Choco.leq(Choco.scalar(coef, vars), pws.getLimit())};
                }
                case LT: {
                    return new Constraint[]{Choco.lt(Choco.scalar(coef, vars), pws.getLimit())};
                }
                case NE: {
                    return new Constraint[]{Choco.neq(Choco.scalar(coef, vars), pws.getLimit())};
                }
            }
        }
        throw new Error("Unknown global constraint");
    }
}

