/*
 * Decompiled with CFR 0.152.
 */
package parser.chocogen;

import choco.Choco;
import choco.kernel.model.Model;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.automaton.DFA;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.constraints.integer.extension.LargeRelation;
import java.util.List;
import parser.absconparseur.components.PConstraint;
import parser.absconparseur.components.PExtensionConstraint;
import parser.absconparseur.components.PRelation;
import parser.absconparseur.components.PVariable;
import parser.absconparseur.tools.InstanceParser;
import parser.chocogen.ModelConstraintFactory;
import parser.chocogen.ObjectFactory;
import parser.chocogen.RelationFactory;
import parser.chocogen.XmlClause;
import parser.chocogen.XmlModel;

public class ExtConstraintFactory
extends ObjectFactory {
    public ExtConstraintFactory(Model m, InstanceParser parser) {
        super(m, parser);
    }

    public void preAnalyse(RelationFactory relfact) {
        for (PConstraint pec : this.parser.getMapOfConstraints().values()) {
            if (!(pec instanceof PExtensionConstraint) || pec.getArity() != 2) continue;
            relfact.detectIntensionConstraint((PExtensionConstraint)pec);
        }
    }

    public static Constraint[] makeExtConstraint(PExtensionConstraint pec) {
        Constraint[] extct;
        block12: {
            PRelation prel;
            block10: {
                PVariable[] sc;
                block11: {
                    extct = new Constraint[1];
                    prel = pec.getRelation();
                    if (prel.getNbTuples() == 0) {
                        extct[0] = prel.getSemantics().equals("supports") ? Choco.FALSE : Choco.TRUE;
                        return extct;
                    }
                    if (prel.getSatEncoding() != null) {
                        PVariable[] sc2 = pec.getScope();
                        List<XmlClause> lcls = prel.getSatEncoding();
                        extct = new Constraint[lcls.size()];
                        for (int i = 0; i < lcls.size(); ++i) {
                            int k;
                            XmlClause xcl = lcls.get(i);
                            IntegerVariable[] pos = new IntegerVariable[xcl.poslits.length];
                            IntegerVariable[] neg = new IntegerVariable[xcl.neglits.length];
                            for (k = 0; k < pos.length; ++k) {
                                pos[k] = sc2[xcl.poslits[k]].getChocovar();
                            }
                            for (k = 0; k < neg.length; ++k) {
                                neg[k] = sc2[xcl.neglits[k]].getChocovar();
                            }
                            extct[i] = Choco.clause(pos, neg);
                        }
                        return extct;
                    }
                    if (pec.getArity() != 2) break block10;
                    sc = pec.getScope();
                    ModelConstraintFactory.ConstExp ctexp = pec.getIntensionCts();
                    if (ctexp == null) break block11;
                    switch (ctexp) {
                        case eq: {
                            extct[0] = Choco.eq((IntegerExpressionVariable)sc[0].getChocovar(), (IntegerExpressionVariable)sc[1].getChocovar());
                            break block12;
                        }
                        case ne: {
                            extct[0] = Choco.neq((IntegerExpressionVariable)sc[0].getChocovar(), (IntegerExpressionVariable)sc[1].getChocovar());
                            break block12;
                        }
                        default: {
                            return null;
                        }
                    }
                }
                extct[0] = Choco.relationPairAC(sc[0].getChocovar(), sc[1].getChocovar(), prel.getBrel());
                break block12;
            }
            PVariable[] sc = pec.getScope();
            IntegerVariable[] intvars = new IntegerVariable[sc.length];
            for (int i = 0; i < intvars.length; ++i) {
                intvars[i] = sc[i].getChocovar();
            }
            LargeRelation lrel = prel.getLrel();
            DFA dfa = prel.getDfa();
            extct[0] = lrel != null ? Choco.relationTupleAC("cp:ac" + XmlModel.getAcAlgo(), intvars, prel.getLrel()) : Choco.regular(dfa, intvars);
        }
        return extct;
    }
}

