/*
 * Decompiled with CFR 0.152.
 */
package parser.chocogen;

import choco.kernel.model.Model;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.constraints.integer.extension.BinRelation;
import choco.kernel.solver.constraints.integer.extension.LargeRelation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import parser.absconparseur.components.PConstraint;
import parser.absconparseur.components.PExtensionConstraint;
import parser.absconparseur.components.PGlobalConstraint;
import parser.absconparseur.components.PIntensionConstraint;
import parser.absconparseur.components.PRelation;
import parser.absconparseur.components.PVariable;
import parser.absconparseur.tools.InstanceParser;
import parser.chocogen.ExtConstraintFactory;
import parser.chocogen.GloConstraintFactory;
import parser.chocogen.ModelConstraintFactory;
import parser.chocogen.RelationFactory;
import parser.chocogen.VariableFactory;

public class ChocoFactory {
    protected static float ratioHole = 0.7f;
    protected InstanceParser parser;
    protected Boolean restartMode = null;
    protected Model m;
    protected RelationFactory relfactory;
    protected IntegerVariable[] vars;
    protected List cstrs;

    public ChocoFactory(InstanceParser parser, Model m) {
        this.m = m;
        this.parser = parser;
        this.restartMode = null;
    }

    public Model getM() {
        return this.m;
    }

    public void createVariables() {
        VariableFactory factory = new VariableFactory(this.m, this.parser);
        this.vars = new IntegerVariable[factory.getNbvar()];
        PVariable[] pvars = this.parser.getVariables();
        for (int i = 0; i < pvars.length; ++i) {
            this.vars[i] = factory.makeVariable(pvars[i]);
        }
        this.m.addVariables(this.vars);
    }

    public void createRelations() {
        this.relfactory = new RelationFactory(this.m, this.parser);
        for (PRelation prel : this.parser.getMapOfRelations().values()) {
            if (this.relfactory.isSatDecomposable(prel)) {
                this.relfactory.makeClausesEncoding(prel);
                continue;
            }
            if (prel.getArity() == 2) {
                BinRelation brel = this.relfactory.makeBinRelation(prel);
                prel.setBrel(brel);
                continue;
            }
            LargeRelation lrel = this.relfactory.makeLargeRelation(prel);
            prel.setLrel(lrel);
        }
    }

    public void createConstraints(boolean forceExp) {
        String options;
        ExtConstraintFactory extFact = new ExtConstraintFactory(this.m, this.parser);
        extFact.preAnalyse(this.relfactory);
        Map<String, PConstraint> pcstr = this.parser.getMapOfConstraints();
        Iterator<String> it = pcstr.keySet().iterator();
        this.cstrs = new ArrayList();
        String string = options = forceExp ? "cp:decomp" : "";
        while (it.hasNext()) {
            PConstraint pc = pcstr.get(it.next());
            this.makeModelConstraint(pc, options);
        }
    }

    public void makeModelConstraint(PConstraint pc, String options) {
        Constraint[] c = null;
        if (pc instanceof PExtensionConstraint) {
            c = ExtConstraintFactory.makeExtConstraint((PExtensionConstraint)pc);
        } else if (pc instanceof PIntensionConstraint) {
            ModelConstraintFactory mcf = new ModelConstraintFactory(this.m, this.parser);
            c = mcf.makeIntensionConstraint((PIntensionConstraint)pc);
        } else if (pc instanceof PGlobalConstraint) {
            GloConstraintFactory gf = new GloConstraintFactory(this.m, this.parser);
            c = gf.makeGlobalConstraint((PGlobalConstraint)pc);
        }
        if (c != null) {
            this.m.addConstraints(options, c);
        }
    }
}

