/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.StringTokenizer;
import parser.absconparseur.components.PConstraint;
import parser.absconparseur.components.PVariable;
import parser.absconparseur.tools.InstanceParser;

public class SolutionChecker {
    private InstanceParser parser;

    private InstanceParser loadAndParseInstance(String instanceFileName) throws Exception {
        InstanceParser parser = new InstanceParser();
        parser.loadInstance(instanceFileName);
        parser.parse(false);
        return parser;
    }

    private int[] buildSolutionFrom(String line, int nbVariables) throws Exception {
        int[] t = new int[nbVariables];
        int i = 0;
        StringTokenizer st = new StringTokenizer(line);
        while (st.hasMoreTokens()) {
            int last;
            String token = st.nextToken();
            for (last = token.length() - 1; last >= 0 && Character.isDigit(token.charAt(last)); --last) {
            }
            if (last >= 0 && token.charAt(last) == '-') {
                --last;
            }
            t[i++] = Integer.parseInt(token.substring(last + 1));
        }
        if (i < nbVariables) {
            throw new IllegalArgumentException();
        }
        return t;
    }

    private int[] loadSolution(String solutionFileName, int nbVariables) throws Exception {
        BufferedReader rd = new BufferedReader(new FileReader(solutionFileName));
        String line = rd.readLine().trim();
        if (line.equals("UNSAT")) {
            System.err.println("PROBLEM \t The file " + solutionFileName + " does not contain any solution.");
            System.exit(2);
        }
        if (line.equals("SAT")) {
            line = rd.readLine().trim();
            return this.buildSolutionFrom(line, nbVariables);
        }
        String previousLine = null;
        while (line != null && line.startsWith("SOL")) {
            previousLine = line;
            line = rd.readLine().trim();
        }
        if (previousLine != null) {
            return this.buildSolutionFrom(previousLine, nbVariables);
        }
        return this.buildSolutionFrom(line, nbVariables);
    }

    private void dealWithInstanceFileName(String instanceFileName) {
        if (!new File(instanceFileName).exists()) {
            System.err.println("PROBLEM \t The file " + instanceFileName + " has not been found.");
            System.exit(2);
        }
        try {
            this.parser = this.loadAndParseInstance(instanceFileName);
        }
        catch (Exception e) {
            System.err.println("PROBLEM \t When loading and/or parsing file " + instanceFileName + " " + e);
            e.printStackTrace();
            System.exit(2);
        }
    }

    private int[] dealWithSolutionFileName(String solutionFileName) {
        try {
            if (!new File(solutionFileName).exists()) {
                System.err.println("The file " + solutionFileName + " has not been found");
                System.exit(2);
            }
            try {
                return this.loadSolution(solutionFileName, this.parser.getVariables().length);
            }
            catch (Exception e) {
                System.err.println("PROBLEM \t When loading and/or parsing file " + solutionFileName + " " + e);
                System.exit(2);
                return null;
            }
        }
        catch (Throwable e) {
            System.err.println("PROBLEM \t " + e.getMessage());
            System.exit(2);
            return null;
        }
    }

    public int isSolutionValid(int[] solution) {
        assert (this.parser.getVariables().length == solution.length);
        for (int i = 0; i < solution.length; ++i) {
            if (this.parser.getVariables()[i].getDomain().contains(solution[i])) continue;
            return i;
        }
        return -1;
    }

    private int[] buildTupleFor(PConstraint constraint, int[] solution) {
        int[] tuple = new int[constraint.getScope().length];
        PVariable[] involvedVariables = constraint.getScope();
        for (int i = 0; i < involvedVariables.length; ++i) {
            int position = 0;
            while (involvedVariables[i] != this.parser.getVariables()[position]) {
                ++position;
            }
            tuple[i] = solution[position];
        }
        return tuple;
    }

    private void checkSolution(int[] solution) {
        int invalidPosition;
        if (this.parser.getVariables().length != solution.length) {
            System.err.println("PROBLEM \t The number of variables is " + this.parser.getVariables().length + " while the size of the solution is " + solution.length);
            System.exit(2);
        }
        if ((invalidPosition = this.isSolutionValid(solution)) != -1) {
            System.out.println("ERROR \t The given solution is not valid as the " + invalidPosition + "th value of the solution is not present in the domain of the associated variable");
            System.exit(1);
        }
        LinkedList<String> list = new LinkedList<String>();
        int sum = 0;
        for (PConstraint constraint : this.parser.getMapOfConstraints().values()) {
            int cost = constraint.computeCostOf(this.buildTupleFor(constraint, solution));
            if (cost > 0) {
                list.add(constraint.getName());
            }
            sum += cost;
        }
        System.out.println("solutionCost " + sum);
        System.out.println("listOfUnsatisfiedConstraints " + list);
    }

    public SolutionChecker(String instanceFileName) {
        this.dealWithInstanceFileName(instanceFileName);
        String s0 = "satisfiable " + this.parser.getSatisfiable() + "  minViolatedConstraints " + this.parser.getMinViolatedConstraints();
        String s1 = "\t nbVariables " + this.parser.getVariables().length + "  nbConstraints " + this.parser.getMapOfConstraints().size();
        String s2 = "\t maxConstraintArity " + this.parser.getMaxConstraintArity() + "  nbExtensionConstraints " + this.parser.getNbExtensionConstraints() + "  nbIntensionConstraints " + this.parser.getNbIntensionConstraints() + "  nbGlobalConstraints " + this.parser.getNbGlobalConstraints();
        System.out.println(s0 + s1 + s2);
        System.exit(0);
    }

    public SolutionChecker(String instanceFileName, String solutionFileName) {
        this.dealWithInstanceFileName(instanceFileName);
        this.checkSolution(this.dealWithSolutionFileName(solutionFileName));
    }

    public SolutionChecker(String instanceFileName, int[] solution) {
        this.dealWithInstanceFileName(instanceFileName);
        this.checkSolution(solution);
    }

    public static void main(String[] args) {
        try {
            if (args.length == 1) {
                new SolutionChecker(args[0]);
            } else if (args.length == 2) {
                new SolutionChecker(args[0], args[1]);
            } else if (args.length > 2) {
                int[] solution = new int[args.length - 1];
                for (int i = 0; i < solution.length; ++i) {
                    try {
                        solution[i] = Integer.parseInt(args[i + 1]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("PROBLEM \t With the given solution: " + args[i + 1] + " is not an integer " + e);
                        System.exit(2);
                    }
                }
                new SolutionChecker(args[0], solution);
            } else {
                System.out.println();
                System.out.println("SolutionChecker version 2.1.2 (March 30, 2008)");
                System.out.println("Usage 1: java ... SolutionChecker <instanceFileName>");
                System.out.println("Usage 2: java ... SolutionChecker <instanceFileName> <solutionFileName>");
                System.out.println("Usage 3: java ... SolutionChecker <instanceFileName> <solution>");
                System.out.println();
                System.out.println("  <instanceFileName> must be the name of a file which contains the representation of a CSP or WCSP instance in format XCSP 2.1.");
                System.out.println("  <solutionFileName> must be the name of a file which:");
                System.out.println("     - either contains on the first line a sequence of values (integers separated by whitespace(s)), one for each variable of the instance");
                System.out.println("     - or respects the output format of the 2008 CSP competition");
                System.out.println("  <solution> must be a sequence of values (integers separated by whitespace(s)), one for each variable of the instance");
                System.out.println();
                System.out.println("With Usage 1, SolutionChecker outputs some information about the given instance");
                System.out.println("With Usage 2 and Usage 3, SolutionChecker outputs the cost of the given solution (number of violated constraints for CSP)");
                System.out.println();
                System.out.println("Exit code of solutionChecker is as follows:");
                System.out.println("  0 : no problem occurs and the solution is valid");
                System.out.println("  1 : the solution is not valid");
                System.out.println("  2 : a problem occurs (file not found, ...)");
                System.exit(0);
            }
        }
        catch (Throwable e) {
            System.err.println("PROBLEM \t " + e.getMessage());
            System.exit(2);
        }
    }
}

