/*
 * Decompiled with CFR 0.152.
 */
package parser.absconparseur.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import parser.absconparseur.InstanceTokens;
import parser.absconparseur.PredicateTokens;
import parser.absconparseur.Toolkit;
import parser.absconparseur.XMLManager;
import parser.absconparseur.components.PAllDifferent;
import parser.absconparseur.components.PConstraint;
import parser.absconparseur.components.PCumulative;
import parser.absconparseur.components.PDomain;
import parser.absconparseur.components.PElement;
import parser.absconparseur.components.PExtensionConstraint;
import parser.absconparseur.components.PIntensionConstraint;
import parser.absconparseur.components.PPredicate;
import parser.absconparseur.components.PRelation;
import parser.absconparseur.components.PVariable;
import parser.absconparseur.components.PWeightedSum;

public class InstanceParser {
    public static final String VERSION = "version 2.1.2 (March 30, 2008)";
    private Document document;
    private String type;
    private String format;
    private int maxConstraintArity;
    private Map<String, PDomain> mapOfDomains;
    private Map<String, PVariable> mapOfVariables;
    private Map<String, PRelation> mapOfRelations;
    private Map<String, PPredicate> mapOfPredicates;
    private Map<String, PConstraint> mapOfConstraints;
    private PVariable[] variables;
    private int nbExtensionConstraints;
    private int nbIntensionConstraints;
    private int nbGlobalConstraints;
    private int nbDomains;
    private String satisfiable;
    private String minViolatedConstraints;
    private boolean displayInstance = true;
    private int[] weights;

    public String getType() {
        return this.type;
    }

    public PVariable[] getVariables() {
        return this.variables;
    }

    public int getNbVariables() {
        return this.variables.length;
    }

    public int getMaxConstraintArity() {
        return this.maxConstraintArity;
    }

    public Map<String, PConstraint> getMapOfConstraints() {
        return this.mapOfConstraints;
    }

    public Map<String, PDomain> getMapOfDomains() {
        return this.mapOfDomains;
    }

    public Map<String, PRelation> getMapOfRelations() {
        return this.mapOfRelations;
    }

    public Map<String, PPredicate> getMapOfPredicat() {
        return this.mapOfPredicates;
    }

    public int getNbExtensionConstraints() {
        return this.nbExtensionConstraints;
    }

    public int getNbIntensionConstraints() {
        return this.nbIntensionConstraints;
    }

    public int getNbGlobalConstraints() {
        return this.nbGlobalConstraints;
    }

    public String getConstraintsCategory() {
        return (this.nbExtensionConstraints > 0 ? "E" : "") + (this.nbIntensionConstraints > 0 ? "I" : "") + (this.nbGlobalConstraints > 0 ? "G" : "");
    }

    public int getNBDomain() {
        return this.nbDomains;
    }

    public String getSatisfiable() {
        return this.satisfiable;
    }

    public String getMinViolatedConstraints() {
        return this.minViolatedConstraints;
    }

    public void loadInstance(String fileName) {
        this.document = XMLManager.load(fileName);
    }

    private void parsePresentation(Element presentationElement) {
        String s = presentationElement.getAttribute("maxConstraintArity".trim());
        this.maxConstraintArity = s.length() == 0 || s.equals("?") ? -1 : Integer.parseInt(s);
        this.type = presentationElement.getAttribute("type".trim());
        this.type = this.type.length() == 0 || this.type.equals("?") ? "CSP" : this.type;
        this.format = presentationElement.getAttribute("format".trim());
        if (this.displayInstance) {
            System.out.println("Instance with maxConstraintArity=" + this.maxConstraintArity + " type=" + this.type + " format=" + this.format);
        }
        this.satisfiable = (s = presentationElement.getAttribute("nbSolutions").trim()).length() == 0 || s.equals("?") ? "unknown" : (s.equals("0") ? "false" : "true");
        s = presentationElement.getAttribute("minViolatedConstraints").trim();
        this.minViolatedConstraints = this.satisfiable.equals("true") ? "0" : (s.length() == 0 || s.equals("?") ? "unknown" : s);
    }

    private int[] parseDomainValues(int nbValues, String stringOfValues) {
        int cnt = 0;
        int[] values = new int[nbValues];
        StringTokenizer st = new StringTokenizer(stringOfValues);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int position = token.indexOf("..");
            if (position == -1) {
                values[cnt++] = Integer.parseInt(token);
                continue;
            }
            int min = Integer.parseInt(token.substring(0, position));
            int max = Integer.parseInt(token.substring(position + "..".length()));
            int j = min;
            while (j <= max) {
                values[cnt++] = j++;
            }
        }
        return values;
    }

    private PDomain parseDomain(Element domainElement) {
        int[] values;
        String name = domainElement.getAttribute("name");
        int nbValues = Integer.parseInt(domainElement.getAttribute("nbValues"));
        if (nbValues != (values = this.parseDomainValues(nbValues, domainElement.getTextContent())).length) {
            throw new RuntimeException();
        }
        return new PDomain(name, values);
    }

    private void parseDomains(Element domainsElement) {
        this.mapOfDomains = new HashMap<String, PDomain>();
        this.nbDomains = Integer.parseInt(domainsElement.getAttribute("nbDomains"));
        if (this.displayInstance) {
            System.out.println("=> " + this.nbDomains + " domains");
        }
        NodeList nodeList = domainsElement.getElementsByTagName("domain");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            PDomain domain = this.parseDomain((Element)nodeList.item(i));
            this.mapOfDomains.put(domain.getName(), domain);
            if (!this.displayInstance) continue;
            System.out.println(domain);
        }
    }

    private PVariable parseVariable(Element variableElement) {
        String name = variableElement.getAttribute("name");
        String domainName = variableElement.getAttribute("domain");
        return new PVariable(name, this.mapOfDomains.get(domainName));
    }

    private void parseVariables(Element variablesElement) {
        this.mapOfVariables = new HashMap<String, PVariable>();
        int nbVariables = Integer.parseInt(variablesElement.getAttribute("nbVariables"));
        if (this.displayInstance) {
            System.out.println("=> " + nbVariables + " variables");
        }
        this.variables = new PVariable[nbVariables];
        NodeList nodeList = variablesElement.getElementsByTagName("variable");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            PVariable variable = this.parseVariable((Element)nodeList.item(i));
            this.mapOfVariables.put(variable.getName(), variable);
            this.variables[i] = variable;
            if (!this.displayInstance) continue;
            System.out.println(variable);
        }
    }

    private int[][] parseRelationTuples(int nbTuples, int arity, String s) {
        int[][] tuples = new int[nbTuples][arity];
        StringTokenizer st = new StringTokenizer(s, " \t\n\r\f|");
        for (int i = 0; i < tuples.length; ++i) {
            for (int j = 0; j < arity; ++j) {
                tuples[i][j] = Integer.parseInt(st.nextToken());
            }
        }
        return tuples;
    }

    private int[][] parseSoftRelationTuples(int nbTuples, int arity, String s) {
        int[][] tuples = new int[nbTuples][arity];
        this.weights = new int[nbTuples];
        StringTokenizer st = new StringTokenizer(s, " \t\n\r\f|");
        int currentCost = -2;
        for (int i = 0; i < nbTuples; ++i) {
            String token = st.nextToken();
            int costFlagPosition = token.lastIndexOf(":");
            if (costFlagPosition != -1) {
                currentCost = Integer.parseInt(token.substring(0, costFlagPosition));
                token = token.substring(costFlagPosition + 1);
            }
            this.weights[i] = currentCost;
            tuples[i][0] = Integer.parseInt(token);
            for (int j = 1; j < arity; ++j) {
                tuples[i][j] = Integer.parseInt(st.nextToken());
            }
        }
        return tuples;
    }

    private PRelation parseRelation(Element relationElement) {
        String name = relationElement.getAttribute("name");
        int arity = Integer.parseInt(relationElement.getAttribute("arity"));
        int nbTuples = Integer.parseInt(relationElement.getAttribute("nbTuples"));
        String semantics = relationElement.getAttribute("semantics");
        if (semantics.equals("soft")) {
            int[][] tuples = this.parseSoftRelationTuples(nbTuples, arity, relationElement.getTextContent());
            String s = relationElement.getAttribute("defaultCost");
            int defaultCost = s.equals("infinity") ? Integer.MAX_VALUE : Integer.parseInt(s);
            return new PRelation(name, arity, nbTuples, semantics, tuples, this.weights, defaultCost);
        }
        int[][] tuples = this.parseRelationTuples(nbTuples, arity, relationElement.getTextContent());
        return new PRelation(name, arity, nbTuples, semantics, tuples);
    }

    private void parseRelations(Element relationsElement) {
        this.mapOfRelations = new HashMap<String, PRelation>();
        if (relationsElement == null) {
            return;
        }
        int nbRelations = Integer.parseInt(relationsElement.getAttribute("nbRelations"));
        if (this.displayInstance) {
            System.out.println("=> " + nbRelations + " relations");
        }
        NodeList nodeList = relationsElement.getElementsByTagName("relation");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            PRelation relation = this.parseRelation((Element)nodeList.item(i));
            this.mapOfRelations.put(relation.getName(), relation);
            if (!this.displayInstance) continue;
            System.out.println(relation);
        }
    }

    private PPredicate parsePredicate(Element predicateElement) {
        String name = predicateElement.getAttribute("name");
        Element parameters = (Element)predicateElement.getElementsByTagName("parameters").item(0);
        Element expression = (Element)predicateElement.getElementsByTagName("expression").item(0);
        Element functional = (Element)expression.getElementsByTagName("functional").item(0);
        return new PPredicate(name, parameters.getTextContent(), functional.getTextContent());
    }

    private void parsePredicates(Element predicatesElement) {
        this.mapOfPredicates = new HashMap<String, PPredicate>();
        if (predicatesElement == null) {
            return;
        }
        int nbPredicates = Integer.parseInt(predicatesElement.getAttribute("nbPredicates"));
        if (this.displayInstance) {
            System.out.println("=> " + nbPredicates + " predicates");
        }
        NodeList nodeList = predicatesElement.getElementsByTagName("predicate");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            PPredicate predicate = this.parsePredicate((Element)nodeList.item(i));
            this.mapOfPredicates.put(predicate.getName(), predicate);
            if (!this.displayInstance) continue;
            System.out.println(predicate);
        }
    }

    private PVariable[] parseScope(String scope) {
        StringTokenizer st = new StringTokenizer(scope, " ");
        PVariable[] involvedVariables = new PVariable[st.countTokens()];
        for (int i = 0; i < involvedVariables.length; ++i) {
            involvedVariables[i] = this.mapOfVariables.get(st.nextToken());
        }
        return involvedVariables;
    }

    private int searchIn(String s, PVariable[] t) {
        for (int i = 0; i < t.length; ++i) {
            if (!t[i].getName().equals(s)) continue;
            return i;
        }
        return -1;
    }

    private PConstraint parseElementConstraint(String name, PVariable[] scope, Element parameters) {
        StringTokenizer st = new StringTokenizer(Toolkit.insertWhitespaceAround(parameters.getTextContent(), "[]{}"), " \t\n\r\f");
        PVariable index = this.mapOfVariables.get(st.nextToken());
        st.nextToken();
        ArrayList<PVariable> table = new ArrayList<PVariable>();
        String token = st.nextToken();
        while (!token.equals("]")) {
            Object object = this.mapOfVariables.get(token);
            if (object == null) {
                object = Integer.parseInt(token);
            }
            table.add((PVariable)object);
            token = st.nextToken();
        }
        token = st.nextToken();
        Object value = this.mapOfVariables.get(token);
        if (value == null) {
            value = Integer.parseInt(token);
        }
        return new PElement(name, scope, index, table.toArray(new Object[table.size()]), value);
    }

    private PConstraint parseWeightedSumConstraint(String name, PVariable[] scope, Element parameters) {
        NodeList nodeList = parameters.getChildNodes();
        StringTokenizer st = new StringTokenizer(nodeList.item(0).getTextContent(), " \t\n\r\f[{}]");
        int[] coeffs = new int[scope.length];
        while (st.hasMoreTokens()) {
            int position;
            int coeff = Integer.parseInt(st.nextToken());
            int n = position = this.searchIn(st.nextToken(), scope);
            coeffs[n] = coeffs[n] + coeff;
        }
        PredicateTokens.RelationalOperator operator = PredicateTokens.RelationalOperator.getRelationalOperatorFor(nodeList.item(1).getNodeName());
        int limit = Integer.parseInt(nodeList.item(2).getTextContent().trim());
        return new PWeightedSum(name, scope, coeffs, operator, limit);
    }

    private String buildStringRepresentationOf(Element parameters) {
        NodeList nodeList = parameters.getChildNodes();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeName().equals("nil")) {
                sb.append(" ");
                sb.append("nil");
                sb.append(" ");
                continue;
            }
            sb.append(Toolkit.insertWhitespaceAround(node.getTextContent(), "[]{}"));
        }
        return sb.toString();
    }

    private PConstraint parseCumulativeConstraint(String name, PVariable[] scope, Element parameters) {
        StringTokenizer st = new StringTokenizer(this.buildStringRepresentationOf(parameters), " \t\n\r\f{}");
        st.nextToken();
        ArrayList<PCumulative.Task> tasks = new ArrayList<PCumulative.Task>();
        String token = st.nextToken();
        while (!token.equals("]")) {
            Object height;
            PVariable end;
            PVariable duration;
            PVariable origin = this.mapOfVariables.get(token);
            if (origin == null) {
                PVariable pVariable = origin = token.equals("nil") ? null : Integer.valueOf(Integer.parseInt(token));
            }
            if ((duration = this.mapOfVariables.get(token = st.nextToken())) == null) {
                PVariable pVariable = duration = token.equals("nil") ? null : Integer.valueOf(Integer.parseInt(token));
            }
            if ((end = this.mapOfVariables.get(token = st.nextToken())) == null) {
                PVariable pVariable = end = token.equals("nil") ? null : Integer.valueOf(Integer.parseInt(token));
            }
            if ((height = this.mapOfVariables.get(token = st.nextToken())) == null) {
                height = Integer.parseInt(token);
            }
            tasks.add(new PCumulative.Task(origin, duration, end, height));
            token = st.nextToken();
        }
        int limit = Integer.parseInt(st.nextToken());
        return new PCumulative(name, scope, tasks.toArray(new PCumulative.Task[tasks.size()]), limit);
    }

    private PConstraint parseConstraint(Element constraintElement) {
        String name = constraintElement.getAttribute("name");
        int arity = Integer.parseInt(constraintElement.getAttribute("arity"));
        if (arity > this.maxConstraintArity) {
            this.maxConstraintArity = arity;
        }
        PVariable[] scope = this.parseScope(constraintElement.getAttribute("scope"));
        String reference = constraintElement.getAttribute("reference");
        if (this.mapOfRelations.containsKey(reference)) {
            ++this.nbExtensionConstraints;
            return new PExtensionConstraint(name, scope, this.mapOfRelations.get(reference));
        }
        if (this.mapOfPredicates.containsKey(reference)) {
            Element parameters = (Element)constraintElement.getElementsByTagName("parameters").item(0);
            ++this.nbIntensionConstraints;
            return new PIntensionConstraint(name, scope, this.mapOfPredicates.get(reference), parameters.getTextContent());
        }
        ++this.nbGlobalConstraints;
        String lreference = reference.toLowerCase();
        Element parameters = (Element)constraintElement.getElementsByTagName("parameters").item(0);
        if (lreference.equals(InstanceTokens.getLowerCaseGlobalNameOf("allDifferent"))) {
            return new PAllDifferent(name, scope);
        }
        if (lreference.equals(InstanceTokens.getLowerCaseGlobalNameOf("element"))) {
            return this.parseElementConstraint(name, scope, parameters);
        }
        if (lreference.equals(InstanceTokens.getLowerCaseGlobalNameOf("weightedSum"))) {
            return this.parseWeightedSumConstraint(name, scope, parameters);
        }
        if (lreference.equals(InstanceTokens.getLowerCaseGlobalNameOf("cumulative"))) {
            return this.parseCumulativeConstraint(name, scope, parameters);
        }
        System.out.println("Problem with the reference " + reference);
        return null;
    }

    private void parseConstraints(Element constraintsElement) {
        this.mapOfConstraints = new HashMap<String, PConstraint>();
        int nbConstraints = Integer.parseInt(constraintsElement.getAttribute("nbConstraints"));
        if (this.displayInstance) {
            System.out.print("=> " + nbConstraints + " constraints");
            if (this.type.equals("WCSP")) {
                int maximalCost = Integer.parseInt(constraintsElement.getAttribute("maximalCost"));
                String s = constraintsElement.getAttribute("initialCost");
                int initialCost = s.equals("") ? 0 : Integer.parseInt(s);
                System.out.print(" maximalCost=" + maximalCost + " initialCost=" + initialCost);
            }
            System.out.println();
        }
        NodeList nodeList = constraintsElement.getElementsByTagName("constraint");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            PConstraint constraint = this.parseConstraint((Element)nodeList.item(i));
            this.mapOfConstraints.put(constraint.getName(), constraint);
            if (!this.displayInstance) continue;
            System.out.println(constraint);
        }
    }

    public void parse(boolean displayInstance) {
        this.displayInstance = displayInstance;
        this.parsePresentation((Element)this.document.getDocumentElement().getElementsByTagName("presentation").item(0));
        this.parseDomains((Element)this.document.getDocumentElement().getElementsByTagName("domains").item(0));
        this.parseVariables((Element)this.document.getDocumentElement().getElementsByTagName("variables").item(0));
        this.parseRelations((Element)this.document.getDocumentElement().getElementsByTagName("relations").item(0));
        this.parsePredicates((Element)this.document.getDocumentElement().getElementsByTagName("predicates").item(0));
        this.parseConstraints((Element)this.document.getDocumentElement().getElementsByTagName("constraints").item(0));
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("InstanceParser version 2.1.2 (March 30, 2008)");
            System.out.println("Usage : java ... InstanceParser <instanceName>");
            System.exit(1);
        }
        InstanceParser parser = new InstanceParser();
        parser.loadInstance(args[0]);
        parser.parse(true);
    }
}

